/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class KotlinLineBreakpointBase
extends LineBreakpoint<JavaLineBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance(KotlinLineBreakpointBase.class);

    protected KotlinLineBreakpointBase(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Nullable
    private static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location2, @NotNull DebugProcessImpl debugProcess) {
        if (requestor == null) {
            KotlinLineBreakpointBase.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            KotlinLineBreakpointBase.$$$reportNull$$$0(1);
        }
        if (location2 != null) {
            RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
            BreakpointRequest request2 = requestsManager.createBreakpointRequest(requestor, location2);
            requestsManager.enableRequest((EventRequest)request2);
            return request2;
        }
        return null;
    }

    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        if (!((Boolean)ReadAction.compute(() -> this.isInScopeOf(debugProcess, classType.name()))).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List locations = debugProcess.getPositionManager().locationsOfLine(classType, this.getSourcePosition());
            if (!locations.isEmpty()) {
                locations = ((StreamEx)((StreamEx)StreamEx.of((Collection)locations).peek(loc -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + loc.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && loc.method().isObsolete()));
                    }
                })).filter(l -> this.acceptLocation(debugProcess, classType, (Location)l))).toList();
                for (Location loc2 : locations) {
                    KotlinLineBreakpointBase.createLocationBreakpointRequest((FilteredRequestor)this, loc2, debugProcess);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + loc2.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations((ReferenceType)classType) == null) {
                debugProcess.getRequestsManager().setInvalid((Requestor)this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No line number info in " + classType.name());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid((Requestor)this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
        this.updateUI();
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className2) {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            VirtualFile breakpointFile = position.getFile().getVirtualFile();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (breakpointFile != null && fileIndex.isUnderSourceRootOfType(breakpointFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcess.getSearchScope().contains(breakpointFile)) {
                    return true;
                }
                Collection<VirtualFile> candidates2 = this.findClassCandidatesInSourceContent(className2, debugProcess.getSearchScope(), fileIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + (Serializable)(candidates2 == null ? "null" : Integer.valueOf(candidates2.size())) + " candidate containing files for class " + className2);
                }
                if (candidates2 == null) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    GlobalSearchScope scope2 = debugProcess.getSearchScope();
                    boolean contains2 = scope2.contains(breakpointFile);
                    List files2 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className2, scope2), aClass -> aClass.getContainingFile().getVirtualFile());
                    List allFiles2 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className2, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), aClass -> aClass.getContainingFile().getVirtualFile());
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(breakpointFile);
                    Module module2 = fileIndex.getModuleForFile(breakpointFile);
                    LOG.debug("Did not find '" + className2 + "' in " + scope2 + "; contains=" + contains2 + "; contentRoot=" + contentRoot + "; module = " + module2 + "; all files in index are: " + files2 + "; all possible files are: " + allFiles2);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className2, GlobalSearchScope scope2, ProjectFileIndex fileIndex) {
        int dollarIndex = className2.indexOf("$");
        String topLevelClassName = dollarIndex >= 0 ? className2.substring(0, dollarIndex) : className2;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(topLevelClassName, scope2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + classes2.length + " classes " + topLevelClassName + " in scope " + scope2);
            }
            if (classes2.length == 0) {
                return null;
            }
            ArrayList<VirtualFile> list2 = new ArrayList<VirtualFile>(classes2.length);
            for (PsiClass aClass : classes2) {
                PsiFile psiFile2 = aClass.getContainingFile();
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg2 = new StringBuilder();
                    msg2.append("Checking class ").append(aClass.getQualifiedName());
                    msg2.append("\n\t").append("PsiFile=").append(psiFile2);
                    if (psiFile2 != null) {
                        VirtualFile vFile = psiFile2.getVirtualFile();
                        msg2.append("\n\t").append("VirtualFile=").append(vFile);
                        if (vFile != null) {
                            msg2.append("\n\t").append("isInSourceContent=").append(fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    LOG.debug(msg2.toString());
                }
                if (psiFile2 == null) {
                    return null;
                }
                VirtualFile vFile = psiFile2.getVirtualFile();
                if (vFile == null || !fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                list2.add(vFile);
            }
            return list2;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "requestor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debugProcess";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointBase";
        objectArray[2] = "createLocationBreakpointRequest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

