/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findDecompiledDeclaration", "builtInsSearchScope", "findInScope", "isLocal", "", "descriptor", "kotlin.core"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project2, @NotNull DeclarationDescriptor referencedDescriptor, @Nullable GlobalSearchScope builtInsSearchScope) {
        block9: {
            GlobalSearchScope globalSearchScope;
            GlobalSearchScope globalSearchScope2;
            block11: {
                block10: {
                    GlobalSearchScope globalSearchScope3;
                    BinaryModuleInfo binaryInfo;
                    BinaryModuleInfo binaryModuleInfo;
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)referencedDescriptor, (String)"referencedDescriptor");
                    if (ErrorUtils.isError((DeclarationDescriptor)referencedDescriptor)) {
                        return null;
                    }
                    if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
                        return null;
                    }
                    if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
                        return null;
                    }
                    Object object = DescriptorUtilsKt.getModule((DeclarationDescriptor)referencedDescriptor).getCapability(ModuleInfo.Companion.getCapability());
                    if (!(object instanceof BinaryModuleInfo)) {
                        object = null;
                    }
                    if ((binaryModuleInfo = (binaryInfo = (BinaryModuleInfo)object)) != null && (binaryModuleInfo = binaryModuleInfo.binariesScope()) != null) {
                        BinaryModuleInfo binaryModuleInfo2;
                        BinaryModuleInfo it = binaryModuleInfo2 = binaryModuleInfo;
                        boolean bl = false;
                        return FindDecompiledDeclarationKt.findInScope(referencedDescriptor, (GlobalSearchScope)it);
                    }
                    if (!KotlinBuiltIns.isBuiltIn((DeclarationDescriptor)referencedDescriptor)) break block9;
                    globalSearchScope2 = builtInsSearchScope;
                    if (globalSearchScope2 == null) break block10;
                    GlobalSearchScope it = globalSearchScope3 = globalSearchScope2;
                    boolean bl = false;
                    globalSearchScope2 = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, it);
                    if (globalSearchScope2 != null) break block11;
                }
                GlobalSearchScope globalSearchScope4 = GlobalSearchScope.allScope((Project)project2);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope4, (String)"GlobalSearchScope.allScope(project)");
                globalSearchScope2 = globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope4);
            }
            if (globalSearchScope2 == null) {
                GlobalSearchScope globalSearchScope5 = GlobalSearchScope.everythingScope((Project)project2);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope5, (String)"GlobalSearchScope.everythingScope(project)");
                globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope5);
            }
            return globalSearchScope;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration findInScope(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2) {
        void $this$mapNotNullTo$iv;
        Project project2 = scope2.getProject();
        if (project2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"scope.project ?: return null");
        Project project3 = project2;
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(referencedDescriptor, KotlinSourceFilterScope.Companion.libraryClassFiles(scope2, project3), project3);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            KtDecompiledFile ktDecompiledFile;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl2 = false;
            KtDeclaration ktDeclaration = it;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if (!(object instanceof KtDecompiledFile)) {
                object = null;
            }
            if ((KtDecompiledFile)((Object)object) == null) continue;
            KtDecompiledFile it$iv = ktDecompiledFile;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet decompiledFiles = (LinkedHashSet)destination$iv;
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), (Function1)((Function1)new Function1<KtDecompiledFile, KtDeclaration>(referencedDescriptor){
            final /* synthetic */ DeclarationDescriptor $referencedDescriptor;

            @Nullable
            public final KtDeclaration invoke(@NotNull KtDecompiledFile file2) {
                Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
                return ByDescriptorIndexer.INSTANCE.getDeclarationForDescriptor$kotlin_core(this.$referencedDescriptor, file2);
            }
            {
                this.$referencedDescriptor = declarationDescriptor;
                super(1);
            }
        })));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        boolean bl;
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            bl = FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        } else {
            bl = DescriptorUtils.isLocal((DeclarationDescriptor)descriptor2);
        }
        return bl;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2, Project project2) {
        Collection<KtNamedFunction> collection;
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2;
        ClassDescriptor containingClass2 = (ClassDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, ClassDescriptor.class, (boolean)false);
        if (containingClass2 != null) {
            Collection<KtClassOrObject> collection2 = KotlinFullClassNameIndex.getInstance().get(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)containingClass2)).asString(), project2, scope2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"KotlinFullClassNameIndex\u2026String(), project, scope)");
            return collection2;
        }
        DeclarationDescriptor declarationDescriptor3 = DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, PropertyDescriptor.class, (boolean)false);
        if (declarationDescriptor3 == null) {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasConstructorDescriptor.class, (boolean)false);
            declarationDescriptor3 = declarationDescriptor2 = (DeclarationDescriptor)(typeAliasConstructorDescriptor != null ? typeAliasConstructorDescriptor.getTypeAliasDescriptor() : null);
        }
        if (declarationDescriptor3 == null) {
            declarationDescriptor2 = declarationDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, FunctionDescriptor.class, (boolean)false);
        }
        if (declarationDescriptor2 == null) {
            declarationDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasDescriptor.class, (boolean)false);
        }
        if (declarationDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        DeclarationDescriptor topLevelDeclaration = declarationDescriptor;
        if (!DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)topLevelDeclaration)) {
            return CollectionsKt.emptyList();
        }
        String string = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)topLevelDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topLevelDeclaration.fqNameSafe.asString()");
        String fqName2 = string;
        DeclarationDescriptor declarationDescriptor4 = topLevelDeclaration;
        if (declarationDescriptor4 instanceof FunctionDescriptor) {
            Collection<KtNamedFunction> collection3 = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(fqName2, project2, scope2);
            collection = collection3;
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"KotlinTopLevelFunctionFq\u2026t(fqName, project, scope)");
        } else if (declarationDescriptor4 instanceof PropertyDescriptor) {
            Collection<KtProperty> collection4 = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(fqName2, project2, scope2);
            collection = collection4;
            Intrinsics.checkNotNullExpressionValue(collection4, (String)"KotlinTopLevelPropertyFq\u2026t(fqName, project, scope)");
        } else if (declarationDescriptor4 instanceof TypeAliasDescriptor) {
            collection = KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance().get(fqName2, project2, scope2);
        } else {
            String string2 = "Referenced non local declaration that is not inside top level function, property, class or typealias:\n " + referencedDescriptor;
            throw new IllegalStateException(string2.toString());
        }
        return collection;
    }
}

