/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.execution;

import com.intellij.build.BuildViewManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.JpsProjectTaskRunner;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class KotlinMPPGradleProjectTaskRunner
extends ProjectTaskRunner {
    @Language(value="Groovy")
    private static final String FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE = "projectsEvaluated { \n  rootProject.findProject('%s')?.tasks?.withType(AbstractCompile) {  \n    outputs.upToDateWhen { false } \n  } \n}\n";

    KotlinMPPGradleProjectTaskRunner() {
    }

    public Promise<ProjectTaskRunner.Result> run(final @NotNull Project project2, @NotNull ProjectTaskContext context2, ProjectTask ... tasks) {
        if (project2 == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(2);
        }
        final AsyncPromise resultPromise = new AsyncPromise();
        MultiMap buildTasksMap = MultiMap.createLinkedSet();
        MultiMap cleanTasksMap = MultiMap.createLinkedSet();
        MultiMap initScripts = MultiMap.createLinkedSet();
        Map taskMap = JpsProjectTaskRunner.groupBy(Arrays.asList(tasks));
        final List<Module> modules2 = KotlinMPPGradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        final List<Module> modulesOfFiles = KotlinMPPGradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        final Set rootPaths = buildTasksMap.keySet();
        final AtomicInteger successCounter = new AtomicInteger();
        final AtomicInteger errorCounter = new AtomicInteger();
        TaskCallback taskCallback2 = new TaskCallback(){

            public void onSuccess() {
                this.handle(true);
            }

            public void onFailure() {
                this.handle(false);
            }

            private void handle(boolean success2) {
                int errors;
                int successes = success2 ? successCounter.incrementAndGet() : successCounter.get();
                int n = errors = success2 ? errorCounter.get() : errorCounter.incrementAndGet();
                if (successes + errors == rootPaths.size()) {
                    List affectedModules;
                    HashSet affectedRoots;
                    if (!project2.isDisposed() && !(affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPathsEx.getOutputPaths((Module[])(affectedModules = ContainerUtil.concat((List)modules2, (List)modulesOfFiles)).toArray(Module.EMPTY_ARRAY)))).isEmpty()) {
                        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
                    }
                    resultPromise.setResult((Object)(errors > 0 ? TaskRunnerResults.FAILURE : TaskRunnerResults.SUCCESS));
                }
            }
        };
        String compilerOptionsInitScript = "allprojects {\n  tasks.withType(JavaCompile) {\n    options.compilerArgs += [\"-Xlint:deprecation\"]\n  }}\n";
        String gradleVmOptions = GradleSettings.getInstance((Project)project2).getGradleVmOptions();
        for (String rootProjectPath : rootPaths) {
            Collection buildTasks = buildTasksMap.get((Object)rootProjectPath);
            if (buildTasks.isEmpty()) continue;
            Collection cleanTasks = cleanTasksMap.get((Object)rootProjectPath);
            ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
            File projectFile = new File(rootProjectPath);
            String projectName2 = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
            String executionName = KotlinIdeaGradleBundle.message("build.0.project", projectName2);
            settings2.setExecutionName(executionName);
            settings2.setExternalProjectPath(rootProjectPath);
            settings2.setTaskNames(ContainerUtil.collect(ContainerUtil.concat((Iterable)cleanTasks, (Iterable)buildTasks).iterator()));
            settings2.setVmOptions(gradleVmOptions);
            settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            UserDataHolderBase userData = new UserDataHolderBase();
            userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, BuildViewManager.class);
            Collection scripts = initScripts.getModifiable((Object)rootProjectPath);
            scripts.add(compilerOptionsInitScript);
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)StringUtil.join((Collection)scripts, (String)SystemProperties.getLineSeparator()));
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)executionName);
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback2, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        }
        return resultPromise;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(3);
        }
        if (projectTask instanceof ModuleBuildTask) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            Module module2 = moduleBuildTask.getModule();
            if (module2.getProject().getPresentableUrl() == null || !GradleProjectSettings.isDelegatedBuildEnabled((Module)module2)) {
                return false;
            }
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
                return false;
            }
            if (KotlinMPPGradleProjectTaskRunner.isProjectWithNativeSourceOrCommonProductionSourceModules(module2.getProject())) {
                return true;
            }
        }
        return false;
    }

    private static List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks, @NotNull MultiMap<String, String> buildTasksMap, @NotNull MultiMap<String, String> initScripts) {
        if (buildTasksMap == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (initScripts == null) {
            KotlinMPPGradleProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        Map rootPathsMap = FactoryMap.create(module2 -> StringUtil.notNullize((String)GradleRunnerUtil.resolveProjectPath((Module)module2)));
        CachedModuleDataFinder moduleDataFinder = new CachedModuleDataFinder();
        for (ProjectTask projectTask : projectTasks) {
            String gradlePath;
            DataNode moduleDataNode;
            String externalProjectPath;
            String projectId2;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            Module module3 = moduleBuildTask.getModule();
            affectedModules.add(module3);
            String rootProjectPath = (String)rootPathsMap.get(module3);
            if (StringUtil.isEmpty((String)rootProjectPath) || (projectId2 = ExternalSystemApiUtil.getExternalProjectId((Module)module3)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module3)) == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc") || (moduleDataNode = moduleDataFinder.findMainModuleData(module3)) == null || Boolean.parseBoolean(((ModuleData)moduleDataNode.getData()).getProperty("buildSrcModule")) || (gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module3)) == null) continue;
            Object taskPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ":";
            List gradleTasks = ContainerUtil.mapNotNull((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), arg_0 -> KotlinMPPGradleProjectTaskRunner.lambda$addModulesBuildTasks$1((String)taskPrefix, arg_0));
            Collection projectInitScripts = initScripts.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module3);
            if (!moduleBuildTask.isIncrementalBuild()) {
                projectInitScripts.add(String.format(FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE, gradlePath));
            }
            String assembleTask = "assemble";
            if ("sourceSet".equals(moduleType)) {
                String gradleTask;
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module3);
                String string = gradleTask = StringUtil.isEmpty((String)sourceSetName) || "main".equals(sourceSetName) ? "classes" : sourceSetName + "Classes";
                if (gradleTasks.contains(gradleTask)) {
                    buildRootTasks.add((String)taskPrefix + gradleTask);
                    continue;
                }
                if ("main".equals(sourceSetName) || "test".equals(sourceSetName)) {
                    buildRootTasks.add((String)taskPrefix + assembleTask);
                    continue;
                }
                if (KotlinMPPGradleProjectTaskRunner.isNativeSourceModule(module3)) {
                    buildRootTasks.addAll(KotlinMPPGradleProjectTaskRunner.addPrefix(KotlinMPPGradleProjectTaskRunner.findNativeGradleBuildTasks(gradleTasks, sourceSetName), (String)taskPrefix));
                    continue;
                }
                if (!KotlinMPPGradleProjectTaskRunner.isCommonProductionSourceModule(module3)) continue;
                buildRootTasks.addAll(KotlinMPPGradleProjectTaskRunner.addPrefix(KotlinMPPGradleProjectTaskRunner.findMetadataBuildTasks(gradleTasks, sourceSetName), (String)taskPrefix));
                continue;
            }
            if (gradleTasks.contains("classes")) {
                buildRootTasks.add((String)taskPrefix + "classes");
                buildRootTasks.add((String)taskPrefix + "testClasses");
                continue;
            }
            if (!gradleTasks.contains(assembleTask)) continue;
            buildRootTasks.add((String)taskPrefix + assembleTask);
        }
        return affectedModules;
    }

    private static boolean isProjectWithNativeSourceOrCommonProductionSourceModules(Project project2) {
        return (Boolean)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> new CachedValueProvider.Result((Object)Arrays.stream(ModuleManager.getInstance((Project)project2).getModules()).anyMatch(module2 -> KotlinMPPGradleProjectTaskRunner.isNativeSourceModule(module2) || KotlinMPPGradleProjectTaskRunner.isCommonProductionSourceModule(module2)), new Object[]{ProjectRootModificationTracker.getInstance((Project)project2)}));
    }

    private static boolean isNativeSourceModule(Module module2) {
        KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module2);
        if (kotlinFacet == null) {
            return false;
        }
        TargetPlatform platform2 = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getTargetPlatform();
        if (platform2 == null) {
            return false;
        }
        return NativePlatformKt.isNative((TargetPlatform)platform2);
    }

    private static boolean isCommonProductionSourceModule(Module module2) {
        KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module2);
        if (kotlinFacet == null) {
            return false;
        }
        KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings();
        if (facetSettings.isTestModule()) {
            return false;
        }
        TargetPlatform platform2 = facetSettings.getTargetPlatform();
        if (platform2 == null) {
            return false;
        }
        return TargetPlatformKt.isCommon((TargetPlatform)platform2);
    }

    private static Collection<String> findNativeGradleBuildTasks(Collection<String> gradleTasks, String sourceSetName) {
        ArrayList linkPrefixes;
        String targetName2;
        String conventionGradleTask = sourceSetName + "Binaries";
        if (gradleTasks.contains(conventionGradleTask)) {
            return Collections.singletonList(conventionGradleTask);
        }
        if (sourceSetName.endsWith("Main")) {
            targetName2 = StringUtil.substringBeforeLast((String)sourceSetName, (String)"Main");
            linkPrefixes = ContainerUtil.newArrayList((Object[])new String[]{"link", "linkMain"});
        } else if (sourceSetName.endsWith("Test")) {
            targetName2 = StringUtil.substringBeforeLast((String)sourceSetName, (String)"Test");
            linkPrefixes = Collections.singletonList("linkTest");
        } else {
            targetName2 = sourceSetName;
            linkPrefixes = Collections.singletonList("link");
        }
        return linkPrefixes.stream().map(linkPrefix -> linkPrefix + StringUtil.capitalize((String)targetName2)).flatMap(nativeTaskName -> gradleTasks.stream().filter(taskName2 -> taskName2.startsWith((String)nativeTaskName))).collect(Collectors.toList());
    }

    private static Collection<String> findMetadataBuildTasks(Collection<String> gradleTasks, String sourceSetName) {
        if ("commonMain".equals(sourceSetName)) {
            String metadataTaskName = "metadataMainClasses";
            if (gradleTasks.contains("metadataMainClasses")) {
                return Collections.singletonList("metadataMainClasses");
            }
        }
        return Collections.emptyList();
    }

    private static Collection<String> addPrefix(Collection<String> tasks, String taskPrefix) {
        return tasks.stream().map(task2 -> taskPrefix + task2).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$addModulesBuildTasks$1(String taskPrefix, DataNode node2) {
        return ((TaskData)node2.getData()).isInherited() ? null : StringUtil.trimStart((String)((TaskData)node2.getData()).getName(), (String)taskPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTasksMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScripts";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/gradleJava/execution/KotlinMPPGradleProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addModulesBuildTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

