/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.FunctionWithLambdaExpressionBodyInspectionKt;
import org.jetbrains.kotlin.idea.intentions.SpecifyExplicitLambdaSignatureIntention;
import org.jetbrains.kotlin.idea.quickfix.SpecifyTypeExplicitlyFix;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FunctionWithLambdaExpressionBodyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "AddArrowIntention", "RemoveBracesFix", "WrapRunFix", "kotlin.idea"})
public final class FunctionWithLambdaExpressionBodyInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.check((KtDeclarationWithBody)function2);
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                if (accessor.isSetter()) {
                    return;
                }
                if (accessor.getReturnTypeReference() != null) {
                    return;
                }
                this.check((KtDeclarationWithBody)accessor);
            }

            /*
             * Unable to fully structure code
             */
            private final void check(KtDeclarationWithBody element) {
                block10: {
                    $this$getNonStrictParentOfType$iv = (PsiElement)element;
                    $i$f$getNonStrictParentOfType = false;
                    v0 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)false);
                    if (v0 == null) {
                        return;
                    }
                    callableDeclaration = v0;
                    if (callableDeclaration.getTypeReference() != null) {
                        return;
                    }
                    v1 = element.getBodyExpression();
                    if (!(v1 instanceof KtLambdaExpression)) {
                        v1 = null;
                    }
                    v2 = (KtLambdaExpression)v1;
                    if (v2 == null) {
                        return;
                    }
                    lambda = v2;
                    v3 = lambda.getFunctionLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"lambda.functionLiteral");
                    functionLiteral = v3;
                    if (functionLiteral.getArrow() != null || functionLiteral.getValueParameterList() != null) {
                        return;
                    }
                    v4 = functionLiteral.getBodyBlockExpression();
                    if (v4 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"functionLiteral.bodyBlockExpression ?: return");
                    lambdaBody = v4;
                    v5 = ReferencesSearch.search((PsiElement)((PsiElement)callableDeclaration));
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"ReferencesSearch.search(callableDeclaration)");
                    used = CollectionsKt.any((Iterable)((Iterable)v5));
                    v6 = new LocalQuickFix[4];
                    v6[0] = (LocalQuickFix)new IntentionWrapper((IntentionAction)new SpecifyTypeExplicitlyFix());
                    v6[1] = (LocalQuickFix)new IntentionWrapper((IntentionAction)new AddArrowIntention());
                    v7 = v6;
                    v8 = v6;
                    v9 = 2;
                    if (used || lambdaBody.getStatements().size() != 1) ** GOTO lbl-1000
                    var8_8 = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)lambdaBody));
                    var16_9 = v9;
                    var15_10 = v7;
                    var14_11 = v8;
                    $i$f$none = false;
                    for (E element$iv : $this$none$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-none-FunctionWithLambdaExpressionBodyInspection$buildVisitor$1$check$fixes$1 = false;
                        if (!(it instanceof PsiComment)) continue;
                        v10 = false;
                        break block10;
                    }
                    v10 = true;
                }
                var17_17 = v10;
                v8 = var14_11;
                v7 = var15_10;
                v9 = var16_9;
                if (var17_17) {
                    v11 = new RemoveBracesFix();
                } else lbl-1000:
                // 2 sources

                {
                    v11 = null;
                }
                v7[v9] = v11;
                v8[3] = used == false ? new WrapRunFix() : null;
                fixes = CollectionsKt.listOfNotNull((Object[])v8);
                $this$toTypedArray$iv = fixes;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                v12 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (v12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                this.$holder.registerProblem((PsiElement)lambda, KotlinBundle.message("inspection.function.with.lambda.expression.body.display.name", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(v12, v12.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FunctionWithLambdaExpressionBodyInspection$AddArrowIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SpecifyExplicitLambdaSignatureIntention;", "()V", "skipProcessingFurtherElementsAfter", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    private static final class AddArrowIntention
    extends SpecifyExplicitLambdaSignatureIntention {
        @Override
        protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FunctionWithLambdaExpressionBodyInspection$RemoveBracesFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveBracesFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("remove.braces.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            if (!(psiElement3 instanceof KtLambdaExpression)) {
                psiElement3 = null;
            }
            KtLambdaExpression ktLambdaExpression2 = (KtLambdaExpression)psiElement3;
            if (ktLambdaExpression2 == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression2;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            Object object = ktFunctionLiteral.getBodyExpression();
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
                return;
            }
            Object singleStatement = object;
            PsiElement $this$replaced$iv = (PsiElement)lambda2;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)singleStatement))) {
                psiElement2 = (PsiElement)singleStatement;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)singleStatement);
                PsiElement psiElement4 = result$iv;
                if (!(psiElement4 instanceof KtExpression)) {
                    psiElement4 = null;
                }
                if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
                    PsiElement psiElement5 = result$iv;
                    if (psiElement5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced2 = (KtExpression)psiElement2;
            FunctionWithLambdaExpressionBodyInspectionKt.access$setTypeIfNeed(replaced2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FunctionWithLambdaExpressionBodyInspection$WrapRunFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class WrapRunFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("wrap.run.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            if (!(psiElement3 instanceof KtLambdaExpression)) {
                psiElement3 = null;
            }
            KtLambdaExpression ktLambdaExpression2 = (KtLambdaExpression)psiElement3;
            if (ktLambdaExpression2 == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression2;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            KtBlockExpression ktBlockExpression = ktFunctionLiteral.getBodyExpression();
            if (ktBlockExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"lambda.functionLiteral.bodyExpression ?: return");
            KtBlockExpression body2 = ktBlockExpression;
            PsiElement psiElement4 = (PsiElement)lambda2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)lambda2), (boolean)false, (int)2, null), (String)"run { $0 }", (Object[])new Object[]{PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)body2))}, (boolean)false, (int)4, null);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                PsiElement psiElement5 = result$iv;
                if (!(psiElement5 instanceof KtExpression)) {
                    psiElement5 = null;
                }
                if ((psiElement2 = (PsiElement)((KtExpression)psiElement5)) == null) {
                    PsiElement psiElement6 = result$iv;
                    if (psiElement6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression = ((KtParenthesizedExpression)psiElement6).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced2 = (KtExpression)psiElement2;
            FunctionWithLambdaExpressionBodyInspectionKt.access$setTypeIfNeed(replaced2);
        }
    }
}

