/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix$applyFix$;
import org.jetbrains.kotlin.idea.util.SafeAnalyzeKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
public final class RemoveRedundantQualifierNameQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("remove.redundant.qualifier.name.quick.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        int endOffset2;
        String selectorReference;
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
        PsiFile psiFile2 = psiElement2.getContainingFile();
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file2 = (KtFile)psiFile2;
        PsiElement element3 = descriptor2.getPsiElement();
        if (element3 instanceof KtUserType) {
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element3), PsiUtilsKt.getEndOffset((PsiElement)element3));
        } else if (element3 instanceof KtDotQualifiedExpression) {
            int n;
            KtExpression ktExpression = ((KtDotQualifiedExpression)element3).getSelectorExpression();
            String string = selectorReference = ktExpression != null ? RemoveRedundantQualifierNameInspectionKt.access$declarationDescriptor((KtElement)ktExpression, SafeAnalyzeKt.safeAnalyzeNonSourceRootCode((KtElement)element3, BodyResolveMode.FULL)) : null;
            if (RemoveRedundantQualifierNameInspectionKt.access$isEnumClass((DeclarationDescriptor)selectorReference) || RemoveRedundantQualifierNameInspectionKt.access$isEnumCompanionObject((DeclarationDescriptor)selectorReference)) {
                n = PsiUtilsKt.getEndOffset((PsiElement)element3);
            } else {
                KtDotQualifiedExpression ktDotQualifiedExpression;
                PsiElement $this$getLastParentOfTypeInRowWithSelf$iv = element3;
                boolean $i$f$getLastParentOfTypeInRowWithSelf = false;
                Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getLastParentOfTypeInRowWithSelf$iv), (Function1)applyFix$$inlined$getLastParentOfTypeInRowWithSelf$1.INSTANCE));
                if (!(object instanceof KtDotQualifiedExpression)) {
                    object = null;
                }
                if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)((KtDotQualifiedExpression)object))) != null && (ktDotQualifiedExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktDotQualifiedExpression))) != null) {
                    n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktDotQualifiedExpression));
                } else {
                    return;
                }
            }
            endOffset2 = n;
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element3), endOffset2);
        } else {
            intRange = IntRange.Companion.getEMPTY();
        }
        IntRange range = intRange;
        String string = file2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
        selectorReference = string;
        endOffset2 = range.getFirst();
        int n = range.getLast();
        String string2 = selectorReference.substring(endOffset2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String substring = string2;
        Regex regex = Regex.Companion.fromLiteral(substring);
        String string3 = file2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.text");
        KtImportList ktImportList = file2.getImportList();
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)regex.findAll((CharSequence)string3, ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, file2, it.getRange().getFirst(), it.getRange().getLast() + 1, null, null, 24, null);
        }
    }
}

