/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceGuardClauseWithFunctionCallInspection$WhenMappings;
import org.jetbrains.kotlin.idea.inspections.SimplifyNegatedBinaryExpressionInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0002H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00022\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002J\f\u0010\u001a\u001a\u00020\u0014*\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u0004\u0018\u00010\u001bH\u0002J\u001c\u0010\u001d\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceGuardClauseWithFunctionCallInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "getCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getKotlinFunction", "Lorg/jetbrains/kotlin/idea/inspections/ReplaceGuardClauseWithFunctionCallInspection$KotlinFunction;", "call", "isNullConstant", "Lorg/jetbrains/kotlin/psi/KtExpression;", "notNullCheckExpression", "replaceWith", "newExpression", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Companion", "KotlinFunction", "kotlin.idea"})
public final class ReplaceGuardClauseWithFunctionCallInspection
extends AbstractApplicabilityBasedInspection<KtIfExpression> {
    private static final String ILLEGAL_STATE_EXCEPTION = "IllegalStateException";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "IllegalArgumentException";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String inspectionText(@NotNull KtIfExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("replace.guard.clause.with.kotlin.s.function.call", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.with.kotlin.s.function.call", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtIfExpression element3) {
        Object object;
        block3: {
            block2: {
                KotlinFunction kotlinFunction;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                object = ReplaceGuardClauseWithFunctionCallInspection.getKotlinFunction$default(this, element3, null, 1, null);
                if (object == null) break block2;
                KotlinFunction it = kotlinFunction = object;
                boolean bl = false;
                object = KotlinBundle.message("replace.with.0.call", it.getFunctionName());
                if (object != null) break block3;
            }
            object = this.getDefaultFixText();
        }
        return object;
    }

    @Override
    @NotNull
    public TextRange inspectionHighlightRangeInElement(@NotNull KtIfExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.ifKeyword");
        return ExpressionExtKt.textRangeIn(psiElement2, (PsiElement)element3);
    }

    @Override
    public boolean isApplicable(@NotNull KtIfExpression element3) {
        KotlinType argumentType;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        LanguageVersionSettings languageVersionSettings2 = PlatformKt.getLanguageVersionSettings((PsiElement)element3);
        if (!languageVersionSettings2.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return false;
        }
        if (element3.getCondition() == null) {
            return false;
        }
        KtCallExpression ktCallExpression = this.getCallExpression(element3);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call = ktCallExpression;
        Object object = call.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            return false;
        }
        Object calleeText = object;
        List list2 = call.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.valueArguments");
        List valueArguments2 = list2;
        if (valueArguments2.size() > 1) {
            return false;
        }
        if (Intrinsics.areEqual((Object)calleeText, (Object)ILLEGAL_STATE_EXCEPTION) ^ true && Intrinsics.areEqual((Object)calleeText, (Object)ILLEGAL_ARGUMENT_EXCEPTION) ^ true) {
            return false;
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)call), (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA);
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)valueArguments2);
        KotlinType kotlinType = ktValueArgument != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null ? CallUtilKt.getType((KtExpression)ktValueArgument, (BindingContext)context2) : (argumentType = null);
        if (argumentType != null && !KotlinBuiltIns.isStringOrNullableString((KotlinType)argumentType)) {
            return false;
        }
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)element3), (BindingContext)context2)) {
            return false;
        }
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)call), (BindingContext)context2);
        FqName fqName2 = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2))) != null ? FqNamesUtilKt.parentOrNull((FqName)resolvedCall2) : null;
        return Intrinsics.areEqual((Object)fqName2, (Object)new FqName("kotlin." + (String)calleeText)) || Intrinsics.areEqual((Object)fqName2, (Object)new FqName("java.lang." + (String)calleeText));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyTo(@NotNull KtIfExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtExpression ktExpression;
        KotlinFunction kotlinFunction;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtExpression ktExpression2 = element3.getCondition();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.condition ?: return");
        KtExpression condition2 = ktExpression2;
        KtCallExpression ktCallExpression = this.getCallExpression(element3);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression call = ktCallExpression;
        List list2 = call.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
        KtExpression argument2 = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
        KotlinFunction kotlinFunction2 = kotlinFunction = this.getKotlinFunction(element3, call);
        if (kotlinFunction2 == null) return;
        switch (ReplaceGuardClauseWithFunctionCallInspection$WhenMappings.$EnumSwitchMapping$0[kotlinFunction2.ordinal()]) {
            case 1: 
            case 2: {
                KtPrefixExpression negatedExpression;
                KtExpression ktExpression3;
                KtExpression replaced2;
                KtExpression ktExpression4;
                KtExpression newExpression2;
                KtExpression ktExpression5;
                void excl;
                void kotlinFunction3;
                Pair pair;
                if (condition2 instanceof KtPrefixExpression && Intrinsics.areEqual((Object)((KtPrefixExpression)condition2).getOperationToken(), (Object)KtTokens.EXCL)) {
                    KtExpression ktExpression6 = ((KtPrefixExpression)condition2).getBaseExpression();
                    if (ktExpression6 == null) {
                        return;
                    }
                    pair = TuplesKt.to((Object)"", (Object)ktExpression6);
                } else {
                    pair = TuplesKt.to((Object)"!", (Object)condition2);
                }
                Pair pair2 = pair;
                String string = (String)pair2.component1();
                KtExpression newCondition = (KtExpression)pair2.component2();
                if (argument2 == null) {
                    String string2 = kotlinFunction3.getFqName() + "(" + (String)excl + "$0)";
                    Object[] objectArray = new Object[1];
                    KtExpression ktExpression7 = newCondition;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression7, (String)"newCondition");
                    objectArray[0] = ktExpression7;
                    ktExpression5 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string2, (Object[])objectArray, (boolean)false, (int)4, null);
                } else {
                    String string3 = kotlinFunction3.getFqName() + "(" + (String)excl + "$0) { $1 }";
                    Object[] objectArray = new Object[2];
                    KtExpression ktExpression8 = newCondition;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression8, (String)"newCondition");
                    objectArray[0] = ktExpression8;
                    objectArray[1] = argument2;
                    ktExpression5 = newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string3, (Object[])objectArray, (boolean)false, (int)4, null);
                }
                if (!((ktExpression4 = (replaced2 = this.replaceWith(element3, newExpression2, psiFactory))) instanceof KtDotQualifiedExpression)) {
                    ktExpression4 = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression4;
                Object object = ktDotQualifiedExpression != null ? UtilsKt.getCallExpression((KtQualifiedExpression)ktDotQualifiedExpression) : null;
                Object object2 = object;
                if (!((object2 != null && (object2 = object2.getValueArguments()) != null && (object2 = (KtValueArgument)CollectionsKt.firstOrNull((List)object2)) != null ? object2.getArgumentExpression() : (ktExpression3 = null)) instanceof KtPrefixExpression)) {
                    ktExpression3 = null;
                }
                if ((negatedExpression = (KtPrefixExpression)ktExpression3) != null) {
                    SimplifyNegatedBinaryExpressionInspection.Companion.simplifyNegatedBinaryExpressionIfNeeded(negatedExpression);
                }
                ktExpression = replaced2;
                break;
            }
            case 3: 
            case 4: {
                void kotlinFunction3;
                KtExpression ktExpression9 = this.notNullCheckExpression(condition2);
                if (ktExpression9 == null) {
                    return;
                }
                KtExpression nullCheckedExpression = ktExpression9;
                KtExpression newExpression3 = argument2 == null ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)(kotlinFunction3.getFqName() + "($0)"), (Object[])new Object[]{nullCheckedExpression}, (boolean)false, (int)4, null) : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)(kotlinFunction3.getFqName() + "($0) { $1 }"), (Object[])new Object[]{nullCheckedExpression, argument2}, (boolean)false, (int)4, null);
                ktExpression = this.replaceWith(element3, newExpression3, psiFactory);
                break;
            }
            default: {
                return;
            }
        }
        KtExpression replaced3 = ktExpression;
        CommentSaver.restore$default(commentSaver, (PsiElement)replaced3, false, 2, null);
        Editor editor3 = editor2;
        if (editor3 != null && (editor3 = editor3.getCaretModel()) != null) {
            editor3.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)replaced3)));
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)replaced3, null, 2, null);
    }

    private final KtExpression replaceWith(KtIfExpression $this$replaceWith, KtExpression newExpression2, KtPsiFactory psiFactory) {
        KtExpression ktExpression;
        PsiElement parent2 = $this$replaceWith.getParent();
        KtExpression elseBranch = $this$replaceWith.getElse();
        if (elseBranch != null) {
            PsiElement psiElement2 = parent2.addBefore((PsiElement)newExpression2, (PsiElement)$this$replaceWith);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression added = (KtExpression)psiElement2;
            parent2.addBefore(psiFactory.createNewLine(), (PsiElement)$this$replaceWith);
            ConstantConditionIfInspectionKt.replaceWithBranch((KtExpression)$this$replaceWith, elseBranch, false, false);
            ktExpression = added;
        } else {
            PsiElement psiElement3;
            PsiElement $this$replaced$iv = (PsiElement)$this$replaceWith;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)newExpression2))) {
                psiElement3 = (PsiElement)newExpression2;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newExpression2);
                PsiElement psiElement4 = result$iv;
                if (!(psiElement4 instanceof KtExpression)) {
                    psiElement4 = null;
                }
                if ((psiElement3 = (PsiElement)((KtExpression)psiElement4)) == null) {
                    PsiElement psiElement5 = result$iv;
                    if (psiElement5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement5).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement3 = (PsiElement)ktExpression2;
                }
            }
            ktExpression = (KtExpression)psiElement3;
        }
        return ktExpression;
    }

    private final KtCallExpression getCallExpression(KtIfExpression $this$getCallExpression) {
        Object object;
        KtExpression it;
        KtExpression ktExpression;
        KtExpression ktExpression2;
        block14: {
            block13: {
                KtThrowExpression ktThrowExpression;
                ktExpression2 = $this$getCallExpression.getThen();
                if (ktExpression2 == null) break block13;
                it = ktExpression = ktExpression2;
                boolean bl = false;
                KtExpression ktExpression3 = it;
                if (!(ktExpression3 instanceof KtThrowExpression)) {
                    ktExpression3 = null;
                }
                if ((ktThrowExpression = (KtThrowExpression)ktExpression3) == null) {
                    KtExpression ktExpression4;
                    Object object2;
                    KtExpression ktExpression5 = it;
                    if (!(ktExpression5 instanceof KtBlockExpression)) {
                        ktExpression5 = null;
                    }
                    if (!(((object2 = (KtBlockExpression)ktExpression5) != null && (object2 = object2.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object2) : (ktExpression4 = null)) instanceof KtThrowExpression)) {
                        ktExpression4 = null;
                    }
                    ktThrowExpression = ktExpression2 = (KtThrowExpression)ktExpression4;
                }
                if (ktThrowExpression != null) break block14;
            }
            return null;
        }
        KtExpression throwExpression2 = ktExpression2;
        KtExpression ktExpression6 = throwExpression2.getThrownExpression();
        if (ktExpression6 != null) {
            it = ktExpression = ktExpression6;
            boolean bl = false;
            KtExpression ktExpression7 = it;
            if (!(ktExpression7 instanceof KtCallExpression)) {
                ktExpression7 = null;
            }
            if ((object = (KtCallExpression)ktExpression7) == null) {
                KtExpression ktExpression8 = it;
                if (!(ktExpression8 instanceof KtQualifiedExpression)) {
                    ktExpression8 = null;
                }
                KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression8;
                object = ktQualifiedExpression != null ? UtilsKt.getCallExpression(ktQualifiedExpression) : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private final KotlinFunction getKotlinFunction(KtIfExpression $this$getKotlinFunction, KtCallExpression call) {
        KotlinFunction kotlinFunction;
        Object object = call;
        if (object == null || (object = object.getCalleeExpression()) == null || (object = object.getText()) == null) {
            return null;
        }
        Object calleeText = object;
        boolean isNotNullCheck = this.notNullCheckExpression($this$getKotlinFunction.getCondition()) != null;
        switch (calleeText) {
            case "IllegalStateException": {
                if (isNotNullCheck) {
                    kotlinFunction = KotlinFunction.CHECK_NOT_NULL;
                    break;
                }
                kotlinFunction = KotlinFunction.CHECK;
                break;
            }
            case "IllegalArgumentException": {
                if (isNotNullCheck) {
                    kotlinFunction = KotlinFunction.REQUIRE_NOT_NULL;
                    break;
                }
                kotlinFunction = KotlinFunction.REQUIRE;
                break;
            }
            default: {
                kotlinFunction = null;
            }
        }
        return kotlinFunction;
    }

    static /* synthetic */ KotlinFunction getKotlinFunction$default(ReplaceGuardClauseWithFunctionCallInspection replaceGuardClauseWithFunctionCallInspection, KtIfExpression ktIfExpression, KtCallExpression ktCallExpression, int n, Object object) {
        if ((n & 1) != 0) {
            ktCallExpression = replaceGuardClauseWithFunctionCallInspection.getCallExpression(ktIfExpression);
        }
        return replaceGuardClauseWithFunctionCallInspection.getKotlinFunction(ktIfExpression, ktCallExpression);
    }

    private final KtExpression notNullCheckExpression(KtExpression $this$notNullCheckExpression) {
        if ($this$notNullCheckExpression == null) {
            return null;
        }
        if (!($this$notNullCheckExpression instanceof KtBinaryExpression)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((KtBinaryExpression)$this$notNullCheckExpression).getOperationToken(), (Object)KtTokens.EQEQ) ^ true) {
            return null;
        }
        KtExpression ktExpression = ((KtBinaryExpression)$this$notNullCheckExpression).getLeft();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"this.left ?: return null");
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = ((KtBinaryExpression)$this$notNullCheckExpression).getRight();
        if (ktExpression2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"this.right ?: return null");
        KtExpression right2 = ktExpression2;
        return this.isNullConstant(right2) ? left : (this.isNullConstant(left) ? right2 : null);
    }

    private final boolean isNullConstant(KtExpression $this$isNullConstant) {
        KtExpression ktExpression = $this$isNullConstant;
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        KtConstantExpression ktConstantExpression = (KtConstantExpression)ktExpression;
        String string = ktConstantExpression != null ? ktConstantExpression.getText() : null;
        KtKeywordToken ktKeywordToken = KtTokens.NULL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NULL_KEYWORD");
        return Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue());
    }

    public ReplaceGuardClauseWithFunctionCallInspection() {
        super(KtIfExpression.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceGuardClauseWithFunctionCallInspection$KotlinFunction;", "", "functionName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "fqName", "getFqName", "()Ljava/lang/String;", "getFunctionName", "CHECK", "CHECK_NOT_NULL", "REQUIRE", "REQUIRE_NOT_NULL", "kotlin.idea"})
    private static final class KotlinFunction
    extends Enum<KotlinFunction> {
        public static final /* enum */ KotlinFunction CHECK;
        public static final /* enum */ KotlinFunction CHECK_NOT_NULL;
        public static final /* enum */ KotlinFunction REQUIRE;
        public static final /* enum */ KotlinFunction REQUIRE_NOT_NULL;
        private static final /* synthetic */ KotlinFunction[] $VALUES;
        @NotNull
        private final String functionName;

        static {
            KotlinFunction[] kotlinFunctionArray = new KotlinFunction[4];
            KotlinFunction[] kotlinFunctionArray2 = kotlinFunctionArray;
            kotlinFunctionArray[0] = CHECK = new KotlinFunction("check");
            kotlinFunctionArray[1] = CHECK_NOT_NULL = new KotlinFunction("checkNotNull");
            kotlinFunctionArray[2] = REQUIRE = new KotlinFunction("require");
            kotlinFunctionArray[3] = REQUIRE_NOT_NULL = new KotlinFunction("requireNotNull");
            $VALUES = kotlinFunctionArray;
        }

        @NotNull
        public final String getFqName() {
            return "kotlin." + this.functionName;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        private KotlinFunction(String functionName) {
            this.functionName = functionName;
        }

        public static KotlinFunction[] values() {
            return (KotlinFunction[])$VALUES.clone();
        }

        public static KotlinFunction valueOf(String string) {
            return Enum.valueOf(KotlinFunction.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceGuardClauseWithFunctionCallInspection$Companion;", "", "()V", "ILLEGAL_ARGUMENT_EXCEPTION", "", "ILLEGAL_STATE_EXCEPTION", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

