/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaVisitor;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.TrailingCommaInspection;
import org.jetbrains.kotlin.idea.inspections.TrailingCommaInspection$WhenMappings;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/TrailingCommaInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "addCommaWarning", "", "(Z)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createOptionsPanel", "Ljavax/swing/JComponent;", "ReformatTrailingCommaFix", "kotlin.idea"})
public final class TrailingCommaInspection
extends AbstractKotlinInspection {
    @JvmField
    public boolean addCommaWarning;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new TrailingCommaVisitor(this, isOnTheFly, holder){
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            private final boolean recursively;
            private final ReadWriteProperty useTrailingComma$delegate;
            final /* synthetic */ TrailingCommaInspection this$0;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(buildVisitor.1.class, "useTrailingComma", "getUseTrailingComma()Z", 0))};
            }

            protected boolean getRecursively() {
                return this.recursively;
            }

            private final boolean getUseTrailingComma() {
                return (Boolean)this.useTrailingComma$delegate.getValue((Object)((Object)this), $$delegatedProperties[0]);
            }

            private final void setUseTrailingComma(boolean bl) {
                this.useTrailingComma$delegate.setValue((Object)((Object)this), $$delegatedProperties[0], (Object)bl);
            }

            protected void process(@NotNull TrailingCommaContext trailingCommaContext) {
                Intrinsics.checkNotNullParameter((Object)trailingCommaContext, (String)"trailingCommaContext");
                KtElement element3 = trailingCommaContext.getKtElement();
                KtFile ktFile = element3.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
                KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)ktFile);
                this.setUseTrailingComma(UtilKt.addTrailingCommaIsAllowedFor(kotlinCustomSettings, (PsiElement)element3));
                switch (TrailingCommaInspection$WhenMappings.$EnumSwitchMapping$0[trailingCommaContext.getState().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.checkCommaPosition(element3);
                        this.checkLineBreaks(element3);
                        break;
                    }
                }
                this.checkTrailingComma(trailingCommaContext);
            }

            private final void checkLineBreaks(KtElement commaOwner2) {
                PsiElement last;
                PsiElement psiElement2;
                PsiElement first2 = TrailingCommaHelper.INSTANCE.elementBeforeFirstElement(commaOwner2);
                PsiElement psiElement3 = first2;
                if (psiElement3 != null && (psiElement3 = PsiUtilsKt.nextLeaf((PsiElement)psiElement3, (boolean)true)) != null) {
                    if (!FormatterUtilKt.isLineBreak(psiElement3)) {
                        PsiElement psiElement4 = first2.getNextSibling();
                        if (psiElement4 != null) {
                            PsiElement psiElement5;
                            PsiElement it = psiElement5 = psiElement4;
                            boolean bl = false;
                            this.registerProblemForLineBreak(commaOwner2, it, ProblemHighlightType.INFORMATION);
                        }
                    }
                }
                if ((psiElement2 = (last = TrailingCommaHelper.INSTANCE.elementAfterLastElement(commaOwner2))) != null && (psiElement2 = PsiUtilsKt.prevLeaf((PsiElement)psiElement2, (boolean)true)) != null) {
                    if (!FormatterUtilKt.isLineBreak(psiElement2)) {
                        this.registerProblemForLineBreak(commaOwner2, last, this.this$0.addCommaWarning ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION);
                    }
                }
            }

            private final void checkCommaPosition(KtElement commaOwner2) {
                for (PsiElement invalidComma : TrailingCommaHelper.INSTANCE.findInvalidCommas(commaOwner2)) {
                    buildVisitor.1.reportProblem$default(this, invalidComma, KotlinBundle.message("inspection.trailing.comma.comma.loses.the.advantages.in.this.position", new Object[0]), KotlinBundle.message("inspection.trailing.comma.fix.comma.position", new Object[0]), null, false, 24, null);
                }
            }

            private final void checkTrailingComma(TrailingCommaContext trailingCommaContext) {
                KtElement commaOwner2 = trailingCommaContext.getKtElement();
                PsiElement psiElement2 = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(commaOwner2);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement trailingCommaOrLastElement = psiElement2;
                switch (TrailingCommaInspection$WhenMappings.$EnumSwitchMapping$1[trailingCommaContext.getState().ordinal()]) {
                    case 1: {
                        if (!UtilsKt.trailingCommaAllowedInModule((PsiElement)commaOwner2)) {
                            return;
                        }
                        buildVisitor.1.reportProblem$default(this, trailingCommaOrLastElement, KotlinBundle.message("inspection.trailing.comma.missing.trailing.comma", new Object[0]), KotlinBundle.message("inspection.trailing.comma.add.trailing.comma", new Object[0]), this.this$0.addCommaWarning ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION, false, 16, null);
                        break;
                    }
                    case 2: {
                        this.reportProblem(trailingCommaOrLastElement, KotlinBundle.message("inspection.trailing.comma.useless.trailing.comma", new Object[0]), KotlinBundle.message("inspection.trailing.comma.remove.trailing.comma", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                        break;
                    }
                }
            }

            private final void reportProblem(PsiElement commaOrElement, @InspectionMessage String message2, @IntentionFamilyName String fixMessage, ProblemHighlightType highlightType, boolean checkTrailingCommaSettings) {
                PsiElement psiElement2 = commaOrElement.getParent();
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                KtElement commaOwner2 = (KtElement)psiElement2;
                PsiElement problemOwner = this.commonParent((PsiElement)commaOwner2, commaOrElement);
                ProblemHighlightType highlightTypeWithAppliedCondition = this.applyCondition(highlightType, !checkTrailingCommaSettings || this.getUseTrailingComma());
                if (this.$isOnTheFly || highlightTypeWithAppliedCondition != ProblemHighlightType.INFORMATION) {
                    this.$holder.registerProblem(problemOwner, message2, highlightTypeWithAppliedCondition, this.getTextRangeOfCommaOrSymbolAfter(commaOrElement).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)problemOwner)), new LocalQuickFix[]{this.createQuickFix(fixMessage, commaOwner2)});
                }
            }

            static /* synthetic */ void reportProblem$default(buildVisitor.1 var0, PsiElement psiElement2, String string, String string2, ProblemHighlightType problemHighlightType2, boolean bl, int n, Object object) {
                if ((n & 8) != 0) {
                    problemHighlightType2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                if ((n & 0x10) != 0) {
                    bl = true;
                }
                var0.reportProblem(psiElement2, string, string2, problemHighlightType2, bl);
            }

            private final void registerProblemForLineBreak(KtElement commaOwner2, PsiElement elementForTextRange, ProblemHighlightType highlightType) {
                PsiElement problemElement = this.commonParent((PsiElement)commaOwner2, elementForTextRange);
                ProblemHighlightType highlightTypeWithAppliedCondition = this.applyCondition(highlightType, this.getUseTrailingComma());
                if (this.$isOnTheFly || highlightTypeWithAppliedCondition != ProblemHighlightType.INFORMATION) {
                    this.$holder.registerProblem(problemElement, KotlinBundle.message("inspection.trailing.comma.missing.line.break", new Object[0]), highlightTypeWithAppliedCondition, TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)elementForTextRange), (int)1).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)problemElement)), new LocalQuickFix[]{this.createQuickFix(KotlinBundle.message("inspection.trailing.comma.add.line.break", new Object[0]), commaOwner2)});
                }
            }

            private final PsiElement commonParent(PsiElement commaOwner2, PsiElement elementForTextRange) {
                PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)commaOwner2, (PsiElement)elementForTextRange);
                if (psiElement2 == null) {
                    KotlinExceptionWithAttachments kotlinExceptionWithAttachments = ApplicationUtilsKt.withPsiAttachment(ApplicationUtilsKt.withPsiAttachment(ApplicationUtilsKt.withPsiAttachment(new KotlinExceptionWithAttachments("Common parent not found"), "commaOwner", commaOwner2).withAttachment("commaOwnerRange", (Object)commaOwner2.getTextRange()), "elementForTextRange", elementForTextRange).withAttachment("elementForTextRangeRange", (Object)elementForTextRange.getTextRange()), "parent", commaOwner2.getParent());
                    PsiElement psiElement3 = commaOwner2.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"commaOwner.parent");
                    throw (Throwable)kotlinExceptionWithAttachments.withAttachment("parentRange", (Object)psiElement3.getTextRange());
                }
                return psiElement2;
            }

            private final ProblemHighlightType applyCondition(ProblemHighlightType $this$applyCondition, boolean condition2) {
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isUnitTestMode() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (condition2 ? $this$applyCondition : ProblemHighlightType.INFORMATION);
            }

            private final LocalQuickFix createQuickFix(@IntentionFamilyName String fixMessage, KtElement commaOwner2) {
                return new ReformatTrailingCommaFix(commaOwner2, fixMessage);
            }

            private final TextRange getTextRangeOfCommaOrSymbolAfter(PsiElement $this$textRangeOfCommaOrSymbolAfter) {
                Object object;
                block5: {
                    TextRange textRange;
                    block4: {
                        textRange = $this$textRangeOfCommaOrSymbolAfter.getTextRange();
                        if (FormatterUtilKt.isComma($this$textRangeOfCommaOrSymbolAfter)) {
                            TextRange textRange2 = textRange;
                            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
                            return textRange2;
                        }
                        object = PsiUtilsKt.nextLeaf$default((PsiElement)$this$textRangeOfCommaOrSymbolAfter, (boolean)false, (int)1, null);
                        if (object == null || (object = FormatterUtilKt.leafIgnoringWhitespaceAndComments$default(object, false, false, 2, null)) == null) break block4;
                        Integer n = PsiUtilsKt.getEndOffset((PsiElement)object);
                        int it = ((Number)n).intValue();
                        boolean bl = false;
                        object = it > 0 ? n : null;
                        if (object == null) break block4;
                        n = object;
                        it = ((Number)n).intValue();
                        boolean bl2 = false;
                        object = TextRange.create((int)(it - 1), (int)it).intersection(textRange);
                        if (object != null) break block5;
                    }
                    TextRange textRange3 = textRange;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"textRange");
                    TextRange textRange4 = TextRange.create((int)(textRange3.getEndOffset() - 1), (int)textRange.getEndOffset());
                    object = textRange4;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"TextRange.create(textRan\u2026- 1, textRange.endOffset)");
                }
                return object;
            }
            {
                this.this$0 = this$0;
                this.$isOnTheFly = $captured_local_variable$1;
                this.$holder = $captured_local_variable$2;
                this.useTrailingComma$delegate = Delegates.INSTANCE.notNull();
            }
        };
    }

    @NotNull
    public JComponent createOptionsPanel() {
        return (JComponent)new SingleCheckboxOptionsPanel(KotlinBundle.message("inspection.trailing.comma.report.also.a.missing.comma", new Object[0]), (InspectionProfileEntry)this, "addCommaWarning");
    }

    public TrailingCommaInspection(boolean addCommaWarning) {
        this.addCommaWarning = addCommaWarning;
    }

    public /* synthetic */ TrailingCommaInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public TrailingCommaInspection() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/TrailingCommaInspection$ReformatTrailingCommaFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "commaOwner", "Lorg/jetbrains/kotlin/psi/KtElement;", "fixMessage", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "commaOwnerPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getCommaOwnerPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createFormatterTextRange", "Lcom/intellij/openapi/util/TextRange;", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "kotlin.idea"})
    public static final class ReformatTrailingCommaFix
    implements LocalQuickFix {
        @NotNull
        private final SmartPsiElementPointer<KtElement> commaOwnerPointer;
        private final String fixMessage;

        @NotNull
        public final SmartPsiElementPointer<KtElement> getCommaOwnerPointer() {
            return this.commaOwnerPointer;
        }

        @NotNull
        public String getFamilyName() {
            return this.fixMessage;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
            KtElement ktElement = (KtElement)this.commaOwnerPointer.getElement();
            if (ktElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"commaOwnerPointer.element ?: return");
            KtElement element3 = ktElement;
            TextRange range = this.createFormatterTextRange(element3);
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project2).cloneSettings(CodeStyle.getSettings((PsiFile)((PsiFile)element3.getContainingKtFile())));
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyleSettingsManager\u2026lement.containingKtFile))");
            CodeStyleSettings settings2 = codeStyleSettings;
            CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)settings2).ALLOW_TRAILING_COMMA = true;
            CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)settings2).ALLOW_TRAILING_COMMA_ON_CALL_SITE = true;
            CodeStyle.doWithTemporarySettings((Project)project2, (CodeStyleSettings)settings2, (Runnable)new Runnable(project2, element3, range){
                final /* synthetic */ Project $project;
                final /* synthetic */ KtElement $element;
                final /* synthetic */ TextRange $range;

                public final void run() {
                    CodeStyleManager.getInstance((Project)this.$project).reformatRange((PsiElement)this.$element, this.$range.getStartOffset(), this.$range.getEndOffset());
                }
                {
                    this.$project = project2;
                    this.$element = ktElement;
                    this.$range = textRange;
                }
            });
        }

        private final TextRange createFormatterTextRange(KtElement commaOwner2) {
            PsiElement psiElement2;
            PsiElement startElement2;
            PsiElement psiElement3 = TrailingCommaHelper.INSTANCE.elementBeforeFirstElement(commaOwner2);
            if (psiElement3 == null) {
                psiElement3 = startElement2 = (PsiElement)commaOwner2;
            }
            if ((psiElement2 = TrailingCommaHelper.INSTANCE.elementAfterLastElement(commaOwner2)) == null) {
                psiElement2 = (PsiElement)commaOwner2;
            }
            PsiElement endElement2 = psiElement2;
            TextRange textRange = TextRange.create((int)PsiUtilsKt.getStartOffset((PsiElement)startElement2), (int)PsiUtilsKt.getEndOffset((PsiElement)endElement2));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(startEl\u2026et, endElement.endOffset)");
            return textRange;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            KtElement ktElement = (KtElement)this.commaOwnerPointer.getElement();
            if (ktElement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"commaOwnerPointer.element ?: return null");
            KtElement element3 = ktElement;
            PsiElement psiElement2 = PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)element3), (PsiFile)target2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.findSameElementInCopy(element, target)");
            return (FileModifier)new ReformatTrailingCommaFix((KtElement)psiElement2, this.fixMessage);
        }

        public ReformatTrailingCommaFix(@NotNull KtElement commaOwner2, @IntentionFamilyName @NotNull String fixMessage) {
            Intrinsics.checkNotNullParameter((Object)commaOwner2, (String)"commaOwner");
            Intrinsics.checkNotNullParameter((Object)fixMessage, (String)"fixMessage");
            this.fixMessage = fixMessage;
            this.commaOwnerPointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)commaOwner2));
        }
    }
}

