/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToLabeledReturnFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "element", "labeledReturn", "", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Ljava/lang/String;)V", "getLabeledReturn", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ChangeToLabeledReturnFix
extends KotlinQuickFixAction<KtReturnExpression> {
    @NotNull
    private final String labeledReturn;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.change.to.labeled.return.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.change.to.labeled.return.text", this.labeledReturn);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtReturnExpression ktReturnExpression = (KtReturnExpression)this.getElement();
        if (ktReturnExpression == null) {
            return;
        }
        KtReturnExpression returnExpression2 = ktReturnExpression;
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        KtExpression returnedExpression = returnExpression2.getReturnedExpression();
        KtExpression newExpression2 = returnedExpression == null ? factory2.createExpression(this.labeledReturn) : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0 $1", (Object[])new Object[]{this.labeledReturn, returnedExpression}, (boolean)false, (int)4, null);
        returnExpression2.replace((PsiElement)newExpression2);
    }

    @NotNull
    public final String getLabeledReturn() {
        return this.labeledReturn;
    }

    public ChangeToLabeledReturnFix(@NotNull KtReturnExpression element3, @NotNull String labeledReturn) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)labeledReturn, (String)"labeledReturn");
        super((PsiElement)element3);
        this.labeledReturn = labeledReturn;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToLabeledReturnFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findAccessibleLabels", "Lorg/jetbrains/kotlin/name/Name;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "position", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getLambdaReturnExpression", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        /*
         * WARNING - void declaration
         */
        private final List<Name> findAccessibleLabels(BindingContext bindingContext2, KtReturnExpression position) {
            PsiElement parent2;
            PsiElement psiElement2;
            List result2 = new ArrayList();
            Iterator iterator = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)position)).iterator();
            while (iterator.hasNext() && !((psiElement2 = (parent2 = (PsiElement)iterator.next())) instanceof KtClassOrObject)) {
                KtReferenceExpression callee2;
                void label2;
                if (!(psiElement2 instanceof KtFunctionLiteral)) continue;
                Pair pair = KtPsiUtilKt.findLabelAndCall((KtFunctionLiteral)((KtFunctionLiteral)parent2));
                Name name2 = (Name)pair.component1();
                KtCallExpression call = (KtCallExpression)pair.component2();
                if (label2 != null) {
                    result2.add(label2);
                }
                KtCallExpression ktCallExpression = call;
                Object object = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
                if (!(object instanceof KtReferenceExpression)) {
                    object = null;
                }
                if ((KtReferenceExpression)object == null) {
                    break;
                }
                if (InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)callee2)))) continue;
                break;
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            void $this$mapTo$iv$iv;
            Object var8_7;
            Lazy lazy;
            KtReturnExpression ktReturnExpression;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = (KtElement)psiElement2;
            if (ktElement == null) {
                return CollectionsKt.emptyList();
            }
            KtElement element3 = ktElement;
            Object var4_3 = null;
            Lazy context2 = LazyKt.lazy((Function0)((Function0)new Function0<BindingContext>(element3){
                final /* synthetic */ KtElement $element;

                @NotNull
                public final BindingContext invoke() {
                    return ResolutionUtils.analyze$default((KtElement)this.$element, null, (int)1, null);
                }
                {
                    this.$element = ktElement;
                    super(0);
                }
            }));
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.RETURN_NOT_ALLOWED)) {
                PsiElement psiElement3 = diagnostic.getPsiElement();
                if (!(psiElement3 instanceof KtReturnExpression)) {
                    psiElement3 = null;
                }
                ktReturnExpression = (KtReturnExpression)psiElement3;
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH_WARNING) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.NULL_FOR_NONNULL_TYPE)) {
                lazy = context2;
                var8_7 = null;
                ktReturnExpression = this.getLambdaReturnExpression(diagnostic.getPsiElement(), (BindingContext)lazy.getValue());
            } else {
                ktReturnExpression = null;
            }
            if (ktReturnExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtReturnExpression returnExpression2 = ktReturnExpression;
            lazy = context2;
            var8_7 = null;
            List<Name> candidates2 = this.findAccessibleLabels((BindingContext)lazy.getValue(), returnExpression2);
            Iterable $this$map$iv = candidates2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ChangeToLabeledReturnFix changeToLabeledReturnFix = new ChangeToLabeledReturnFix(returnExpression2, "return@" + RenderingUtilsKt.render((Name)it));
                collection.add(changeToLabeledReturnFix);
            }
            return (List)destination$iv$iv;
        }

        private final KtReturnExpression getLambdaReturnExpression(PsiElement element3, BindingContext bindingContext2) {
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            KtReturnExpression ktReturnExpression = (KtReturnExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtReturnExpression.class, (boolean)true);
            if (ktReturnExpression == null) {
                return null;
            }
            KtReturnExpression returnExpression2 = ktReturnExpression;
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)returnExpression2;
            boolean $i$f$getStrictParentOfType2 = false;
            KtLambdaExpression ktLambdaExpression2 = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtLambdaExpression.class, (boolean)true);
            if (ktLambdaExpression2 == null) {
                return null;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression2;
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)lambda2.getFunctionLiteral());
            if (simpleFunctionDescriptor == null || (simpleFunctionDescriptor = simpleFunctionDescriptor.getReturnType()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"bindingContext[BindingCo\u2026returnType ?: return null");
            SimpleFunctionDescriptor lambdaReturnType = simpleFunctionDescriptor;
            KtExpression ktExpression = returnExpression2.getReturnedExpression();
            if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)bindingContext2)) == null) {
                return null;
            }
            KtExpression returnType2 = ktExpression;
            if (!TypeUtilsKt.isSubtypeOf((KotlinType)returnType2, (KotlinType)lambdaReturnType)) {
                return null;
            }
            return returnExpression2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

