/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.quickfix.InvalidPsiElementTypeException;
import org.jetbrains.kotlin.idea.quickfix.PsiElementSuitabilityChecker;
import org.jetbrains.kotlin.idea.quickfix.QuickFixFactory;
import org.jetbrains.kotlin.idea.quickfix.UnsupportedPsiElementException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u0002J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixesPsiBasedFactory;", "PSI", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactory;", "classTag", "Lkotlin/reflect/KClass;", "suitabilityChecker", "Lorg/jetbrains/kotlin/idea/quickfix/PsiElementSuitabilityChecker;", "(Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/idea/quickfix/PsiElementSuitabilityChecker;)V", "checkIfPsiElementIsSupported", "", "psiElement", "createQuickFix", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "doCreateQuickFix", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "kotlin.fir.frontend-independent"})
public abstract class QuickFixesPsiBasedFactory<PSI extends PsiElement>
implements QuickFixFactory {
    private final KClass<PSI> classTag;
    private final PsiElementSuitabilityChecker<PSI> suitabilityChecker;

    @NotNull
    public final List<IntentionAction> createQuickFix(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        this.checkIfPsiElementIsSupported(psiElement2);
        return this.doCreateQuickFix(psiElement2);
    }

    private final void checkIfPsiElementIsSupported(PsiElement psiElement2) {
        if (!KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(psiElement2.getClass()), this.classTag)) {
            throw (Throwable)new InvalidPsiElementTypeException((KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(psiElement2.getClass()), this.classTag, Reflection.getOrCreateKotlinClass(this.getClass()).toString());
        }
        PsiElement psiElement3 = psiElement2;
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type PSI");
        }
        if (!this.suitabilityChecker.isSupported(psiElement3)) {
            throw (Throwable)new UnsupportedPsiElementException(psiElement2, Reflection.getOrCreateKotlinClass(this.getClass()).toString());
        }
    }

    @NotNull
    protected abstract List<IntentionAction> doCreateQuickFix(@NotNull PSI var1);

    public QuickFixesPsiBasedFactory(@NotNull KClass<PSI> classTag, @NotNull PsiElementSuitabilityChecker<? super PSI> suitabilityChecker) {
        Intrinsics.checkNotNullParameter(classTag, (String)"classTag");
        Intrinsics.checkNotNullParameter(suitabilityChecker, (String)"suitabilityChecker");
        this.classTag = classTag;
        this.suitabilityChecker = suitabilityChecker;
    }
}

