/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/SelectionAwareScopeHighlighter;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "highlighters", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addHighlighter", "", "r", "Lcom/intellij/openapi/util/TextRange;", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "dropHighlight", "highlight", "wholeAffected", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class SelectionAwareScopeHighlighter {
    private final ArrayList<RangeHighlighter> highlighters;
    @NotNull
    private final Editor editor;

    private final void addHighlighter(TextRange r, TextAttributes attr) {
        this.highlighters.add(this.editor.getMarkupModel().addRangeHighlighter(r.getStartOffset(), r.getEndOffset(), 6001, attr, HighlighterTargetArea.EXACT_RANGE));
    }

    public final void highlight(@NotNull PsiElement wholeAffected) {
        SelectionModel selectionModel;
        Intrinsics.checkNotNullParameter((Object)wholeAffected, (String)"wholeAffected");
        this.dropHighlight();
        TextRange textRange = wholeAffected.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange affectedRange = textRange;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Intrinsics.checkNotNull((Object)textAttributes);
        TextAttributes attributes = textAttributes;
        SelectionModel $this$with = selectionModel = this.editor.getSelectionModel();
        boolean bl = false;
        TextRange selectedRange = new TextRange($this$with.getSelectionStart(), $this$with.getSelectionEnd());
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        int textLength = document.getTextLength();
        Iterator iterator = RangeSplitter.split((TextRange)affectedRange, Collections.singletonList(selectedRange)).iterator();
        while (iterator.hasNext()) {
            TextRange r;
            TextRange textRange2 = r = (TextRange)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"r");
            if (textRange2.getEndOffset() > textLength) continue;
            this.addHighlighter(r, attributes);
        }
    }

    public final void dropHighlight() {
        Iterable $this$forEach$iv = this.highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.highlighters.clear();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public SelectionAwareScopeHighlighter(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.highlighters = new ArrayList();
    }
}

