/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.io.CorruptedException;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.kotlin.idea.search.refIndex.ClassOneToManyStorage;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexStorage$Companion$initializeSubtypeStorage$;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexStorageKt;
import org.jetbrains.kotlin.idea.search.refIndex.LookupStorageReader;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage;", "", "kotlinDataContainerPath", "Ljava/nio/file/Path;", "lookupStorageReader", "Lorg/jetbrains/kotlin/idea/search/refIndex/LookupStorageReader;", "(Ljava/nio/file/Path;Lorg/jetbrains/kotlin/idea/search/refIndex/LookupStorageReader;)V", "subtypesStorage", "Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "close", "", "getSubtypesOf", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "deep", "", "getUsages", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "initialize", "buildDataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "Companion", "kotlin.refIndex"})
public final class KotlinCompilerReferenceIndexStorage {
    private final ClassOneToManyStorage subtypesStorage;
    private final LookupStorageReader lookupStorageReader;
    private static final String SUBTYPES_STORAGE_NAME;
    private static final ExecutorService STORAGE_INDEXING_EXECUTOR;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final boolean initialize(BuildDataPaths buildDataPaths) {
        return KotlinCompilerReferenceIndexStorage.Companion.initializeSubtypeStorage(buildDataPaths, this.subtypesStorage);
    }

    private final void close() {
        this.lookupStorageReader.close();
        this.subtypesStorage.closeAndClean();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getUsages(@NotNull FqName fqName2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Iterable $this$mapNotNull$iv = this.lookupStorageReader.get(fqName2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFile((Path)it, (boolean)true) == null) continue;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Sequence<FqName> getSubtypesOf(@NotNull FqName fqName2, boolean deep) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.subtypesStorage.get(fqName2, deep);
    }

    private KotlinCompilerReferenceIndexStorage(Path kotlinDataContainerPath, LookupStorageReader lookupStorageReader) {
        this.lookupStorageReader = lookupStorageReader;
        Path path2 = kotlinDataContainerPath.resolve(SUBTYPES_STORAGE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"kotlinDataContainerPath.\u2026ve(SUBTYPES_STORAGE_NAME)");
        this.subtypesStorage = new ClassOneToManyStorage(path2);
    }

    static {
        Companion = new Companion(null);
        SUBTYPES_STORAGE_NAME = "subtypes." + BasicMapsOwner.Companion.getCACHE_EXTENSION();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Kotlin compiler references indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026dexingThreads()\n        )");
        STORAGE_INDEXING_EXECUTOR = executorService;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinCompilerReferenceIndexStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public /* synthetic */ KotlinCompilerReferenceIndexStorage(Path kotlinDataContainerPath, LookupStorageReader lookupStorageReader, DefaultConstructorMarker $constructor_marker) {
        this(kotlinDataContainerPath, lookupStorageReader);
    }

    public static final /* synthetic */ ExecutorService access$getSTORAGE_INDEXING_EXECUTOR$cp() {
        return STORAGE_INDEXING_EXECUTOR;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\fJ$\u0010\u001f\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140!H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "STORAGE_INDEXING_EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "SUBTYPES_STORAGE_NAME", "", "buildDataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "Lcom/intellij/openapi/project/Project;", "getBuildDataPaths$kotlin_refIndex", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "kotlinDataContainer", "Ljava/nio/file/Path;", "getKotlinDataContainer$kotlin_refIndex", "(Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)Ljava/nio/file/Path;", "close", "", "storage", "Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage;", "hasIndex", "", "project", "initializeForTests", "destination", "Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "initializeSubtypeStorage", "open", "visitSubtypeStorages", "processor", "Lkotlin/Function1;", "kotlin.refIndex"})
    public static final class Companion {
        @Nullable
        public final KotlinCompilerReferenceIndexStorage open(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            String string = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(project2){
                final /* synthetic */ Project $project;

                @Nullable
                public final String invoke() {
                    Project project2;
                    Project p1 = project2 = this.$project;
                    boolean bl = false;
                    Object object = !p1.isDisposed() ? project2 : null;
                    return object != null ? object.getBasePath() : null;
                }
                {
                    this.$project = project2;
                    super(0);
                }
            });
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runReadAction { project.\u2026basePath } ?: return null");
            String projectPath2 = string;
            BuildDataPaths buildDataPaths = this.getBuildDataPaths$kotlin_refIndex(project2);
            Object object = buildDataPaths;
            if (object == null || (object = this.getKotlinDataContainer$kotlin_refIndex((BuildDataPaths)object)) == null) {
                boolean bl = false;
                LOG.warn("kotlin-data-container is not found");
                return null;
            }
            Object kotlinDataContainerPath = object;
            LookupStorageReader lookupStorageReader = LookupStorageReader.Companion.create((Path)kotlinDataContainerPath, projectPath2);
            if (lookupStorageReader == null) {
                boolean bl = false;
                LOG.warn("LookupStorage not found or corrupted");
                return null;
            }
            LookupStorageReader lookupStorageReader2 = lookupStorageReader;
            KotlinCompilerReferenceIndexStorage storage = new KotlinCompilerReferenceIndexStorage((Path)kotlinDataContainerPath, lookupStorageReader2, null);
            if (!storage.initialize(buildDataPaths)) {
                return null;
            }
            return storage;
        }

        public final void close(@Nullable KotlinCompilerReferenceIndexStorage storage) {
            Unit unit;
            Unit unit2;
            KotlinCompilerReferenceIndexStorage kotlinCompilerReferenceIndexStorage = storage;
            if (kotlinCompilerReferenceIndexStorage != null) {
                kotlinCompilerReferenceIndexStorage.close();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            Unit it = unit = unit2;
            boolean bl = false;
            LOG.info("KCRI storage is closed" + (it == null ? " (didn't exist)" : ""));
        }

        public final boolean hasIndex(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return LookupStorageReader.Companion.hasStorage(project2);
        }

        @TestOnly
        public final boolean initializeForTests(@NotNull BuildDataPaths buildDataPaths, @NotNull ClassOneToManyStorage destination) {
            Intrinsics.checkNotNullParameter((Object)buildDataPaths, (String)"buildDataPaths");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return this.initializeSubtypeStorage(buildDataPaths, destination);
        }

        @Nullable
        public final BuildDataPaths getBuildDataPaths$kotlin_refIndex(@NotNull Project $this$buildDataPaths) {
            BuildDataPathsImpl buildDataPathsImpl;
            Intrinsics.checkNotNullParameter((Object)$this$buildDataPaths, (String)"$this$buildDataPaths");
            File file2 = BuildManager.getInstance().getProjectSystemDirectory($this$buildDataPaths);
            if (file2 != null) {
                File file3;
                File p1 = file3 = file2;
                boolean bl = false;
                buildDataPathsImpl = new BuildDataPathsImpl(p1);
            } else {
                buildDataPathsImpl = null;
            }
            return (BuildDataPaths)buildDataPathsImpl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Path getKotlinDataContainer$kotlin_refIndex(@NotNull BuildDataPaths $this$kotlinDataContainer) {
            Comparable<File> comparable;
            Intrinsics.checkNotNullParameter((Object)$this$kotlinDataContainer, (String)"$this$kotlinDataContainer");
            File file2 = $this$kotlinDataContainer.getTargetsDataRoot();
            Object object = file2;
            if (file2 == null) return null;
            Path path2 = ((File)object).toPath();
            object = path2;
            if (path2 == null) return null;
            Path path3 = object.resolve("kotlin-data-container");
            object = path3;
            if (path3 == null) return null;
            Comparable<File> it = comparable = object;
            boolean bl = false;
            Comparable<File> comparable2 = it;
            LinkOption[] linkOptionArray = new LinkOption[0];
            if (!Files.exists(comparable2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
            comparable2 = it;
            linkOptionArray = new LinkOption[0];
            if (!Files.isDirectory(comparable2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            Comparable<File> comparable3 = comparable;
            object = comparable3;
            if (comparable3 == null) return null;
            List list2 = PathsKt.listDirectoryEntries(object, (String)"kotlin-data-container*");
            object = list2;
            if (list2 == null) return null;
            Path path4 = (Path)CollectionsKt.firstOrNull((List)object);
            return path4;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean initializeSubtypeStorage(BuildDataPaths buildDataPaths, ClassOneToManyStorage destination) {
            void wasCorrupted;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            MultiMap multiMap = MultiMap.createConcurrentSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createConcurrentSet<String, String>()");
            MultiMap destinationMap = multiMap;
            List futures = new ArrayList();
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Companion.visitSubtypeStorages(buildDataPaths, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(buildDataPaths, futures, destinationMap, (Ref.BooleanRef)wasCorrupted){
                final /* synthetic */ BuildDataPaths $buildDataPaths$inlined;
                final /* synthetic */ List $futures$inlined;
                final /* synthetic */ MultiMap $destinationMap$inlined;
                final /* synthetic */ Ref.BooleanRef $wasCorrupted$inlined;
                {
                    this.$buildDataPaths$inlined = buildDataPaths;
                    this.$futures$inlined = list2;
                    this.$destinationMap$inlined = multiMap;
                    this.$wasCorrupted$inlined = booleanRef;
                    super(1);
                }

                public final void invoke(@NotNull Path storagePath) {
                    Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
                    Collection collection = this.$futures$inlined;
                    Future<?> future = KotlinCompilerReferenceIndexStorage.access$getSTORAGE_INDEXING_EXECUTOR$cp().submit(new Runnable(this, storagePath){
                        final /* synthetic */ Companion$initializeSubtypeStorage$$inlined$measureTimeMillis$lambda$1 this$0;
                        final /* synthetic */ Path $storagePath;
                        {
                            this.this$0 = var1_1;
                            this.$storagePath = path2;
                        }

                        public final void run() {
                            try {
                                KotlinCompilerReferenceIndexStorageKt.access$initializeStorage(this.this$0.$destinationMap$inlined, this.$storagePath);
                            }
                            catch (CorruptedException e) {
                                this.this$0.$wasCorrupted$inlined.element = true;
                                KotlinCompilerReferenceIndexStorage.access$getLOG$cp().warn("KCRI storage was corrupted", (Throwable)e);
                            }
                        }
                    });
                    collection.add(future);
                }
            }));
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("KCRI initialization was interrupted");
                throw (Throwable)e;
            }
            long timeOfFilling = System.currentTimeMillis() - start$iv;
            if (wasCorrupted.element) {
                return false;
            }
            boolean $i$f$measureTimeMillis2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl2 = false;
            Iterator iterator = destinationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                String string = (String)entry2.getKey();
                entry2 = entry;
                Collection values2 = (Collection)entry2.getValue();
                void v1 = key;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
                Collection collection = values2;
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values");
                destination.put((String)v1, collection);
            }
            long timeOfFlush = System.currentTimeMillis() - start$iv2;
            LOG.info("KCRI storage is opened: took " + (timeOfFilling + timeOfFlush) + " ms for " + futures.size() + " storages (filling map: " + timeOfFilling + " ms, flush to storage: " + timeOfFlush + " ms)");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void visitSubtypeStorages(BuildDataPaths buildDataPaths, Function1<? super Path, Unit> processor2) {
            for (JavaModuleBuildTargetType buildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
                Path path2;
                Path buildTargetPath = buildDataPaths.getTargetTypeDataRoot((BuildTargetType)buildTargetType).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)buildTargetPath, (String)"buildTargetPath");
                Object object = new LinkOption[0];
                if (Files.notExists(path2, Arrays.copyOf(object, ((LinkOption[])object).length)) || !Files.isDirectory(path2 = buildTargetPath, Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length))) continue;
                path2 = buildTargetPath;
                object = "*";
                Closeable closeable = Files.newDirectoryStream(path2, (String)object);
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
                    Iterable iterable = directoryStream;
                    for (Object t : iterable) {
                        Path path3;
                        Path targetDataRoot = (Path)t;
                        boolean bl = false;
                        Path it = path3 = targetDataRoot;
                        boolean bl2 = false;
                        Path path4 = it;
                        LinkOption[] linkOptionArray = new LinkOption[0];
                        Path path5 = Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path3 : null;
                        if (path5 == null || (path5 = path5.resolve(IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME())) == null || (path5 = path5.resolve(SUBTYPES_STORAGE_NAME)) == null) continue;
                        it = path3 = path5;
                        boolean bl3 = false;
                        path4 = it;
                        linkOptionArray = new LinkOption[0];
                        path5 = !Files.notExists(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path3 : null;
                        if (path5 == null) {
                            continue;
                        }
                        Path workingPath = path5;
                        processor2.invoke((Object)workingPath);
                    }
                    directoryStream = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

