/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.update;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.update.PluginUpdateVerifier;
import org.jetbrains.kotlin.idea.update.PluginVerifyResult;
import org.jetbrains.kotlin.idea.util.VersioningKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier;", "Lorg/jetbrains/kotlin/idea/update/PluginUpdateVerifier;", "()V", "verifierName", "", "getVerifierName", "()Ljava/lang/String;", "buildInRange", "", "name", "sinceBuild", "untilBuild", "getRelease", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "pluginCompatibility", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "verify", "Lorg/jetbrains/kotlin/idea/update/PluginVerifyResult;", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "Companion", "kotlin.idea"})
public final class GooglePluginUpdateVerifier
extends PluginUpdateVerifier {
    private static final String KOTLIN_PLUGIN_ID = "org.jetbrains.kotlin";
    private static final String METADATA_FILE_URL = "https://dl.google.com/android/studio/plugins/compatibility.xml";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getVerifierName() {
        return KotlinBundle.message("update.name.android.studio", new Object[0]);
    }

    @Override
    @Nullable
    public PluginVerifyResult verify(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        String version2;
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        PluginId pluginId = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
        if (Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)KOTLIN_PLUGIN_ID) ^ true) {
            return null;
        }
        String string = version2 = pluginDescriptor.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version");
        if (VersioningKt.isEap(string) || VersioningKt.isDev(version2)) {
            return PluginVerifyResult.Companion.accept();
        }
        try {
            boolean bl;
            block7: {
                URL url = new URL(METADATA_FILE_URL);
                InputStream stream = url.openStream();
                JAXBContext context2 = JAXBContext.newInstance((Class[])new Class[]{Companion.PluginCompatibility.class});
                Unmarshaller unmarshaller = context2.createUnmarshaller();
                Object object = unmarshaller.unmarshal(stream);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.update.GooglePluginUpdateVerifier.Companion.PluginCompatibility");
                }
                Companion.PluginCompatibility pluginCompatibility = (Companion.PluginCompatibility)object;
                Companion.StudioRelease studioRelease = this.getRelease(pluginCompatibility);
                if (studioRelease == null) {
                    return PluginVerifyResult.Companion.decline(KotlinBundle.message("update.reason.text.no.verified.versions.for.this.build", new Object[0]));
                }
                Companion.StudioRelease release = studioRelease;
                Companion.IdeaPlugin[] $this$any$iv = GooglePluginUpdateVerifier.Companion.plugins(release);
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Companion.IdeaPlugin element$iv;
                    Companion.IdeaPlugin it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)KOTLIN_PLUGIN_ID, (Object)it.getId()) && Intrinsics.areEqual((Object)version2, (Object)it.getVersion()))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            return bl ? PluginVerifyResult.Companion.accept() : PluginVerifyResult.Companion.decline(KotlinBundle.message("update.reason.text.version.to.be.verified", new Object[0]));
        }
        catch (Exception e) {
            PluginId pluginId2 = pluginDescriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"pluginDescriptor.pluginId");
            LOG.info("Exception when verifying plugin " + pluginId2.getIdString() + " version " + version2, (Throwable)e);
            Exception exception = e;
            return exception instanceof IOException ? PluginVerifyResult.Companion.decline(KotlinBundle.message("update.reason.text.unable.to.connect.to.compatibility.verification.repository", new Object[0])) : (exception instanceof JAXBException ? PluginVerifyResult.Companion.decline(KotlinBundle.message("update.reason.text.unable.to.parse.compatibility.verification.metadata", new Object[0])) : PluginVerifyResult.Companion.decline(KotlinBundle.message("update.reason.text.exception.during.verification", String.valueOf(e.getMessage()))));
        }
    }

    private final Companion.StudioRelease getRelease(Companion.PluginCompatibility pluginCompatibility) {
        for (Companion.StudioRelease studioRelease : GooglePluginUpdateVerifier.Companion.releases(pluginCompatibility)) {
            if (!this.buildInRange(studioRelease.getName(), studioRelease.getSinceBuild(), studioRelease.getUntilBuild())) continue;
            return studioRelease;
        }
        return null;
    }

    private final boolean buildInRange(String name2, String sinceBuild, String untilBuild) {
        PluginNode descriptor2 = new PluginNode();
        descriptor2.setName(name2);
        descriptor2.setSinceBuild(sinceBuild);
        descriptor2.setUntilBuild(untilBuild);
        return PluginManagerCore.isCompatible((IdeaPluginDescriptor)((IdeaPluginDescriptor)descriptor2));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GooglePluginUpdateVerifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Googl\u2026dateVerifier::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\n*\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion;", "", "()V", "KOTLIN_PLUGIN_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "METADATA_FILE_URL", "plugins", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;)[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "releases", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;)[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "IdeaPlugin", "IdeaVersion", "PluginCompatibility", "StudioRelease", "kotlin.idea"})
    public static final class Companion {
        private final StudioRelease[] releases(PluginCompatibility $this$releases) {
            StudioRelease[] studioReleaseArray = $this$releases.getStudioRelease();
            if (studioReleaseArray == null) {
                studioReleaseArray = new StudioRelease[]{};
            }
            return studioReleaseArray;
        }

        private final IdeaPlugin[] plugins(StudioRelease $this$plugins) {
            IdeaPlugin[] ideaPluginArray = $this$plugins.getIdeaPlugin();
            if (ideaPluginArray == null) {
                ideaPluginArray = new IdeaPlugin[]{};
            }
            return ideaPluginArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @XmlRootElement(name="plugin-compatibility")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "", "()V", "studioRelease", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "getStudioRelease", "()[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "setStudioRelease", "([Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;)V", "[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "toString", "", "kotlin.idea"})
        public static final class PluginCompatibility {
            @XmlElement(name="studio-release")
            @Nullable
            private StudioRelease[] studioRelease;

            @Nullable
            public final StudioRelease[] getStudioRelease() {
                return this.studioRelease;
            }

            public final void setStudioRelease(@Nullable StudioRelease[] studioReleaseArray) {
                this.studioRelease = studioReleaseArray;
            }

            @NotNull
            public String toString() {
                return "PluginCompatibility(studioRelease=" + Arrays.toString(this.studioRelease) + ")";
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR \u0010\u0014\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR \u0010\u0017\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "", "()V", "channel", "", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "ideaPlugin", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "getIdeaPlugin", "()[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "setIdeaPlugin", "([Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;)V", "[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "name", "getName", "setName", "sinceBuild", "getSinceBuild", "setSinceBuild", "untilBuild", "getUntilBuild", "setUntilBuild", "toString", "kotlin.idea"})
        public static final class StudioRelease {
            @XmlAttribute(name="until-build")
            @Nullable
            private String untilBuild;
            @XmlAttribute(name="since-build")
            @Nullable
            private String sinceBuild;
            @XmlAttribute
            @Nullable
            private String name;
            @XmlAttribute
            @Nullable
            private String channel;
            @XmlElement(name="idea-plugin")
            @Nullable
            private IdeaPlugin[] ideaPlugin;

            @Nullable
            public final String getUntilBuild() {
                return this.untilBuild;
            }

            public final void setUntilBuild(@Nullable String string) {
                this.untilBuild = string;
            }

            @Nullable
            public final String getSinceBuild() {
                return this.sinceBuild;
            }

            public final void setSinceBuild(@Nullable String string) {
                this.sinceBuild = string;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            public final void setName(@Nullable String string) {
                this.name = string;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string) {
                this.channel = string;
            }

            @Nullable
            public final IdeaPlugin[] getIdeaPlugin() {
                return this.ideaPlugin;
            }

            public final void setIdeaPlugin(@Nullable IdeaPlugin[] ideaPluginArray) {
                this.ideaPlugin = ideaPluginArray;
            }

            @NotNull
            public String toString() {
                return "StudioRelease(untilBuild=" + this.untilBuild + ", name=" + this.name + ", ideaPlugin=" + Arrays.toString(this.ideaPlugin) + ", sinceBuild=" + this.sinceBuild + ", channel=" + this.channel + ")";
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR \u0010\u0015\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "", "()V", "channel", "", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "id", "getId", "setId", "ideaVersion", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "getIdeaVersion", "()Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "setIdeaVersion", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;)V", "sha256", "getSha256", "setSha256", "version", "getVersion", "setVersion", "toString", "kotlin.idea"})
        public static final class IdeaPlugin {
            @XmlAttribute
            @Nullable
            private String id;
            @XmlAttribute
            @Nullable
            private String sha256;
            @XmlAttribute
            @Nullable
            private String channel;
            @XmlAttribute
            @Nullable
            private String version;
            @XmlElement(name="idea-version")
            @Nullable
            private IdeaVersion ideaVersion;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }

            @Nullable
            public final String getSha256() {
                return this.sha256;
            }

            public final void setSha256(@Nullable String string) {
                this.sha256 = string;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string) {
                this.channel = string;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            public final void setVersion(@Nullable String string) {
                this.version = string;
            }

            @Nullable
            public final IdeaVersion getIdeaVersion() {
                return this.ideaVersion;
            }

            public final void setIdeaVersion(@Nullable IdeaVersion ideaVersion) {
                this.ideaVersion = ideaVersion;
            }

            @NotNull
            public String toString() {
                return "IdeaPlugin(id=" + this.id + ", sha256=" + this.sha256 + ", ideaVersion=" + this.ideaVersion + ", channel=" + this.channel + ", version=" + this.version + ")";
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0004H\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "", "()V", "sinceBuild", "", "getSinceBuild", "()Ljava/lang/String;", "setSinceBuild", "(Ljava/lang/String;)V", "untilBuild", "getUntilBuild", "setUntilBuild", "toString", "kotlin.idea"})
        public static final class IdeaVersion {
            @XmlAttribute(name="until-build")
            @Nullable
            private String untilBuild;
            @XmlAttribute(name="since-build")
            @Nullable
            private String sinceBuild;

            @Nullable
            public final String getUntilBuild() {
                return this.untilBuild;
            }

            public final void setUntilBuild(@Nullable String string) {
                this.untilBuild = string;
            }

            @Nullable
            public final String getSinceBuild() {
                return this.sinceBuild;
            }

            public final void setSinceBuild(@Nullable String string) {
                this.sinceBuild = string;
            }

            @NotNull
            public String toString() {
                return "IdeaVersion(untilBuild=" + this.untilBuild + ", sinceBuild=" + this.sinceBuild + ")";
            }
        }
    }
}

