/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CoverageProjectViewClassNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    CoverageProjectViewClassNodeDecorator(@NotNull Project project) {
        if (project == null) {
            CoverageProjectViewClassNodeDecorator.$$$reportNull$$$0(0);
        }
        super(project);
    }

    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        PsiElement element = node.getPsiElement();
        if (element == null || !element.isValid() || !(element instanceof PsiClass)) {
            return;
        }
        Project project = element.getProject();
        CoverageDataManager dataManager = this.getCoverageDataManager(project);
        JavaCoverageAnnotator javaCovAnnotator = CoverageProjectViewClassNodeDecorator.getCovAnnotator(dataManager, project);
        if (javaCovAnnotator == null) {
            return;
        }
        String qName = ((PsiClass)element).getQualifiedName();
        if (qName != null) {
            CoverageProjectViewClassNodeDecorator.appendCoverageInfo((ColoredTreeCellRenderer)cellRenderer, (String)javaCovAnnotator.getClassCoverageInformationString(qName, dataManager));
        }
    }

    public void decorate(ProjectViewNode node, PresentationData data) {
        block10: {
            PsiElement element;
            JavaCoverageAnnotator javaCovAnnotator;
            CoverageDataManager coverageDataManager;
            block9: {
                String qName;
                Project project = node.getProject();
                if (project == null) {
                    return;
                }
                coverageDataManager = this.getCoverageDataManager(project);
                javaCovAnnotator = CoverageProjectViewClassNodeDecorator.getCovAnnotator(coverageDataManager, project);
                if (javaCovAnnotator == null) {
                    return;
                }
                Object value = node.getValue();
                element = null;
                if (value instanceof PsiElement) {
                    element = (PsiElement)value;
                } else if (value instanceof SmartPsiElementPointer) {
                    element = ((SmartPsiElementPointer)value).getElement();
                } else if (value instanceof PackageElement) {
                    PackageElement packageElement = (PackageElement)value;
                    String coverageString = javaCovAnnotator.getPackageCoverageInformationString(packageElement.getPackage(), packageElement.getModule(), coverageDataManager);
                    data.setLocationString(coverageString);
                }
                if (!(element instanceof PsiClass)) break block9;
                GlobalSearchScope searchScope = coverageDataManager.getCurrentSuitesBundle().getSearchScope(project);
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (vFile == null || !searchScope.contains(vFile) || (qName = ((PsiClass)element).getQualifiedName()) == null) break block10;
                data.setLocationString(javaCovAnnotator.getClassCoverageInformationString(qName, coverageDataManager));
                break block10;
            }
            if (element instanceof PsiNamedElement && !(element instanceof PsiFile) && !(element instanceof PsiDirectory)) {
                for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
                    PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(javaCovAnnotator, (PsiNamedElement)element);
                    if (info == null) continue;
                    data.setLocationString(JavaCoverageAnnotator.getClassCoverageInformationString(info, coverageDataManager));
                    break;
                }
            }
        }
    }

    @Nullable
    private static JavaCoverageAnnotator getCovAnnotator(@Nullable CoverageDataManager dataManager, @NotNull Project project) {
        CoverageAnnotator coverageAnnotator;
        if (project == null) {
            CoverageProjectViewClassNodeDecorator.$$$reportNull$$$0(1);
        }
        if (dataManager == null) {
            return null;
        }
        CoverageSuitesBundle currentSuite = dataManager.getCurrentSuitesBundle();
        if (currentSuite != null && (coverageAnnotator = currentSuite.getAnnotator(project)) instanceof JavaCoverageAnnotator) {
            return (JavaCoverageAnnotator)coverageAnnotator;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/coverage/CoverageProjectViewClassNodeDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCovAnnotator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

