/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.idea;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.JavaClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEACoverageClassInfo
extends JavaClassInfo {
    private final ProjectData myProjectData;
    private final ClassData myClassData;
    private final Collection<ClassData> myInnerClasses;

    public IDEACoverageClassInfo(@NotNull ProjectData projectData, @NotNull String className, @Nullable ClassData classData, @NotNull Collection<ClassData> innerClasses) {
        super(className);
        this.myProjectData = projectData;
        this.myClassData = classData;
        this.myInnerClasses = innerClasses;
    }

    @NotNull
    public Collection<ClassData> getClassDataWithInternal() {
        ArrayList<ClassData> list = new ArrayList<ClassData>();
        if (this.myClassData != null) {
            list.add(this.myClassData);
        }
        list.addAll(this.myInnerClasses);
        return list;
    }

    @Override
    public Entry getLineStats() {
        int total = 0;
        int covered = 0;
        if (this.myClassData == null) {
            return null;
        }
        Object[] lines = this.myClassData.getLines();
        if (lines == null) {
            return null;
        }
        for (Object obj : lines) {
            if (obj == null) continue;
            ++total;
            LineData ld = (LineData)obj;
            if (!this.isCovered(ld.getStatus())) continue;
            ++covered;
        }
        return new Entry(total, covered);
    }

    @Override
    @Nullable
    public Entry getMethodStats() {
        int total = 0;
        int covered = 0;
        if (this.myClassData == null) {
            return null;
        }
        for (Object m : this.myClassData.getMethodSigs()) {
            ++total;
            Integer status = this.myClassData.getStatus((String)m);
            if (!this.isCovered(status)) continue;
            ++covered;
        }
        return new Entry(total, covered);
    }

    @Override
    public Entry getBlockStats() {
        int total = 0;
        int covered = 0;
        if (this.myClassData == null) {
            return null;
        }
        Object[] lines = this.myClassData.getLines();
        if (lines == null) {
            return null;
        }
        for (Object l : lines) {
            LineData line;
            BranchData branches;
            if (l == null || (branches = (line = (LineData)l).getBranchData()) == null) continue;
            total += branches.getTotalBranches();
            covered += branches.getCoveredBranches();
        }
        return new Entry(total, covered);
    }

    @Override
    public Entry getStatementStats() {
        if (!this.myProjectData.isInstructionsCoverageEnabled()) {
            return null;
        }
        ClassInstructions classInstructions = (ClassInstructions)this.myProjectData.getInstructions().get(this.getFQName());
        if (classInstructions == null) {
            return null;
        }
        if (this.myClassData == null) {
            return null;
        }
        LineData[] lines = (LineData[])this.myClassData.getLines();
        if (lines == null) {
            return null;
        }
        int total = 0;
        int covered = 0;
        LineInstructions[] instructions = classInstructions.getlines();
        for (LineData lineData : lines) {
            LineInstructions lineInstructions;
            if (lineData == null || (lineInstructions = instructions[lineData.getLineNumber()]) == null) continue;
            BranchData summary = lineInstructions.getInstructionsData(lineData);
            total += summary.getTotalBranches();
            covered += summary.getCoveredBranches();
        }
        return new Entry(total, covered);
    }

    public List<ClassInfo> getInnerClasses() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassData inner : this.myInnerClasses) {
            result.add(new IDEACoverageClassInfo(this.myProjectData, inner.getName(), inner, Collections.<ClassData>emptyList()));
        }
        return result;
    }

    private boolean isCovered(Integer status) {
        if (status == null) {
            return false;
        }
        switch ((byte)status.intValue()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }
}

