/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.util.loading.ReflectKt;
import sun.java2d.StateTrackable;
import sun.java2d.StateTracker;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0007\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0007H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"dataFieldByte", "Ljava/lang/reflect/Field;", "kotlin.jvm.PlatformType", "dataFieldInt", "theTrackableField", "imageId", "Lorg/jetbrains/projector/common/protocol/data/ImageId;", "Ljava/awt/image/BufferedImage;", "getImageId", "(Ljava/awt/image/BufferedImage;)Lorg/jetbrains/projector/common/protocol/data/ImageId;", "stateHash", "", "getStateHash", "(Ljava/awt/image/BufferedImage;)I", "toImageData", "Lorg/jetbrains/projector/common/protocol/data/ImageData;", "toPngBase64", "", "projector-server"})
public final class ProjectorImageCacherKt {
    private static final Field dataFieldByte;
    private static final Field dataFieldInt;
    private static final Field theTrackableField;

    private static final String toPngBase64(BufferedImage $this$toPngBase64) {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] imageInByte = null;
        ByteArrayOutputStream $this$toPngBase64_u24lambda_u2d0 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        ImageIO.write((RenderedImage)$this$toPngBase64, "png", $this$toPngBase64_u24lambda_u2d0);
        $this$toPngBase64_u24lambda_u2d0.flush();
        byte[] byArray = $this$toPngBase64_u24lambda_u2d0.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.toByteArray()");
        imageInByte = byArray;
        $this$toPngBase64_u24lambda_u2d0.close();
        byte[] encoded = Base64.getEncoder().encode(imageInByte);
        Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
        return new String(encoded, Charsets.UTF_8);
    }

    @NotNull
    public static final ImageData toImageData(@NotNull BufferedImage $this$toImageData) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageData, (String)"<this>");
        return new ImageData.PngBase64(ProjectorImageCacherKt.toPngBase64($this$toImageData));
    }

    @NotNull
    public static final ImageId getImageId(@NotNull BufferedImage $this$imageId) {
        ImageId imageId;
        Intrinsics.checkNotNullParameter((Object)$this$imageId, (String)"<this>");
        DataBuffer dataBuffer = $this$imageId.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            Object object = dataFieldByte.get($this$imageId.getRaster().getDataBuffer());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            byte[] pixels = (byte[])object;
            imageId = new ImageId.BufferedImageId(pixels.length, Arrays.hashCode(pixels));
        } else if (dataBuffer instanceof DataBufferInt) {
            Object object = dataFieldInt.get($this$imageId.getRaster().getDataBuffer());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
            }
            int[] pixels = (int[])object;
            imageId = new ImageId.BufferedImageId(pixels.length, Arrays.hashCode(pixels));
        } else {
            throw new IllegalStateException("Unsupported BufferedImage type".toString());
        }
        return imageId;
    }

    public static final int getStateHash(@NotNull BufferedImage $this$stateHash) {
        Intrinsics.checkNotNullParameter((Object)$this$stateHash, (String)"<this>");
        Object object = theTrackableField.get($this$stateHash.getRaster().getDataBuffer());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type sun.java2d.StateTrackable");
        }
        StateTrackable stateTrackable = (StateTrackable)object;
        StateTracker stateTracker = stateTrackable.getStateTracker();
        return System.identityHashCode(stateTracker);
    }

    static {
        Field field;
        Field $this$dataFieldByte_u24lambda_u2d1 = field = DataBufferByte.class.getDeclaredField("data");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$dataFieldByte_u24lambda_u2d1, (String)"");
        ReflectKt.unprotect($this$dataFieldByte_u24lambda_u2d1);
        dataFieldByte = field;
        Field $this$dataFieldInt_u24lambda_u2d2 = field = DataBufferInt.class.getDeclaredField("data");
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$dataFieldInt_u24lambda_u2d2, (String)"");
        ReflectKt.unprotect($this$dataFieldInt_u24lambda_u2d2);
        dataFieldInt = field;
        Field $this$theTrackableField_u24lambda_u2d3 = field = DataBuffer.class.getDeclaredField("theTrackable");
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$theTrackableField_u24lambda_u2d3, (String)"");
        ReflectKt.unprotect($this$theTrackableField_u24lambda_u2d3);
        theTrackableField = field;
    }
}

