/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

public class SwitchInstructions {
    private int myDefaultInstructions = 0;
    private int[] myInstructions;

    public SwitchInstructions(int size) {
        this.myInstructions = new int[size];
    }

    public int size() {
        return this.myInstructions.length;
    }

    public void setInstructions(int key, int instructions) {
        if (key == -1) {
            this.myDefaultInstructions = instructions;
        } else {
            if (key < 0 || key >= this.myInstructions.length) {
                return;
            }
            this.myInstructions[key] = instructions;
        }
    }

    public int getInstructions(int key) {
        if (key == -1) {
            return this.myDefaultInstructions;
        }
        if (key < 0 || key >= this.myInstructions.length) {
            return 0;
        }
        return this.myInstructions[key];
    }

    public void merge(SwitchInstructions other) {
        if (this.myInstructions.length < other.myInstructions.length) {
            int[] old = this.myInstructions;
            this.myInstructions = new int[other.myInstructions.length];
            System.arraycopy(old, 0, this.myInstructions, 0, old.length);
        }
        this.myDefaultInstructions = Math.max(this.myDefaultInstructions, other.myDefaultInstructions);
        for (int i = 0; i < Math.min(this.myInstructions.length, other.myInstructions.length); ++i) {
            this.myInstructions[i] = Math.max(this.myInstructions[i], other.myInstructions[i]);
        }
    }
}

