/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.instrumentation.MethodFilteringVisitor;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.StringsPool;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public abstract class Instrumenter
extends MethodFilteringVisitor {
    protected final ProjectData myProjectData;
    private final boolean myShouldCalculateSource;
    protected TIntObjectHashMap<LineData> myLines = new TIntObjectHashMap(4, 0.99f);
    protected int myMaxLineNumber;
    protected ClassData myClassData;
    protected boolean myProcess;

    public Instrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(classVisitor, className);
        this.myProjectData = projectData;
        this.myShouldCalculateSource = shouldCalculateSource;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myProcess = (access & 0x200) == 0;
        this.myClassData = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.getClassName()));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if (!this.shouldInstrumentMethod(access, name, desc, signature, exceptions)) {
            return mv;
        }
        this.myProcess = true;
        return this.chainFilters(mv, access, name, desc, signature, exceptions);
    }

    private MethodVisitor chainFilters(MethodVisitor root, int access, String name, String desc, String signature, String[] exceptions) {
        root = this.createMethodLineEnumerator(root, name, desc, access, signature, exceptions);
        for (MethodVisitingFilter filter : FilterUtils.createVisitingFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, this, name, desc);
            root = filter;
        }
        return root;
    }

    protected abstract MethodVisitor createMethodLineEnumerator(MethodVisitor var1, String var2, String var3, int var4, String var5, String[] var6);

    public void visitEnd() {
        if (this.myProcess) {
            this.initLineData();
            this.myLines = null;
        }
        super.visitEnd();
    }

    protected abstract void initLineData();

    protected LineData getOrCreateLineData(int line, String name, String desc) {
        LineData lineData;
        if (this.myLines == null) {
            this.myLines = new TIntObjectHashMap();
        }
        if ((lineData = this.myLines.get(line)) == null) {
            lineData = new LineData(line, StringsPool.getFromPool(name + desc));
            this.myLines.put(line, lineData);
        }
        if (line > this.myMaxLineNumber) {
            this.myMaxLineNumber = line;
        }
        return lineData;
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.getClassName())).setSource(source);
        }
        if (debug != null) {
            this.myProjectData.addLineMaps(this.getClassName(), JSR45Util.extractLineMapping(debug, this.getClassName()));
        }
    }

    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        String fqnName;
        ClassData outerClass;
        if (this.myShouldCalculateSource && (outerClass = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(fqnName = ClassNameUtil.convertToFQName(outerClassName)))).getSource() == null) {
            outerClass.setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }

    public boolean isSampling() {
        return this.myProjectData.isSampling();
    }

    public LineData getLineData(int line) {
        return this.myLines.get(line);
    }

    public ProjectData getProjectData() {
        return this.myProjectData;
    }

    public void removeLine(int line) {
        this.myLines.remove(line);
    }

    public int linesCount() {
        return this.myLines.size();
    }
}

