/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.LinesUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class NewSamplingInstrumenter
extends Instrumenter {
    private static final String LINE_HITS_FIELD_NAME = "__$lineHits$__";
    private static final String LINE_HITS_FIELD_TYPE = "[I";
    private static final String LINE_HITS_LOCAL_VARIABLE_NAME = "__$localLineHits$__";
    private final String myClassNameType;
    private final ExtraFieldInstrumenter myExtraFieldInstrumenter;

    public NewSamplingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
        this.myExtraFieldInstrumenter = new ExtraFieldSamplingInstrumenter(cr, className);
        this.myClassNameType = ClassNameUtil.convertToInternalName(className);
    }

    public MethodVisitor createMethodLineEnumerator(MethodVisitor mv, final String name, final String desc, int access, String signature, String[] exceptions) {
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, LINE_HITS_LOCAL_VARIABLE_NAME, LINE_HITS_FIELD_TYPE){

            public void visitLineNumber(int line, Label start) {
                NewSamplingInstrumenter.this.getOrCreateLineData(line, name, desc);
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, line);
                InstrumentationUtils.incrementIntArrayByIndex(this.mv);
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, NewSamplingInstrumenter.this.myClassNameType, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, NewSamplingInstrumenter.LINE_HITS_FIELD_TYPE);
                this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
                super.visitCode();
            }
        };
        return this.myExtraFieldInstrumenter.createMethodVisitor(this, mv, visitor, name);
    }

    public void visitEnd() {
        this.myExtraFieldInstrumenter.generateMembers(this);
        super.visitEnd();
    }

    protected void initLineData() {
        LineData[] lines = LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines);
        this.myClassData.initLineMask(lines);
        this.myClassData.setLines(lines);
    }

    private class ExtraFieldSamplingInstrumenter
    extends ExtraFieldInstrumenter {
        public ExtraFieldSamplingInstrumenter(ClassReader cr, String className) {
            super(cr, null, className, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, NewSamplingInstrumenter.LINE_HITS_FIELD_TYPE, true);
        }

        public void initField(MethodVisitor mv) {
            mv.visitLdcInsn(NewSamplingInstrumenter.this.getClassName());
            mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "getLineMask", "(Ljava/lang/String;)[I", false);
            mv.visitFieldInsn(179, NewSamplingInstrumenter.this.myClassNameType, NewSamplingInstrumenter.LINE_HITS_FIELD_NAME, NewSamplingInstrumenter.LINE_HITS_FIELD_TYPE);
        }
    }
}

