/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.NestedScrollPaneMouseWheelListener;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0007J \u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$H\u0007J(\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$H\u0007J\u001e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001901H\u0007J\u0010\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001bH\u0007J\u0014\u00104\u001a\u000205*\u0002062\u0006\u0010\u0017\u001a\u00020\u0014H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/adtui/common/AdtUiUtils;", "", "()V", "DEFAULT_BORDER_COLOR", "Ljava/awt/Color;", "DEFAULT_BOTTOM_BORDER", "Ljavax/swing/border/Border;", "DEFAULT_FONT", "Lcom/intellij/util/ui/JBFont;", "Lorg/jetbrains/annotations/NotNull;", "DEFAULT_FONT_COLOR", "DEFAULT_HORIZONTAL_BORDERS", "DEFAULT_LEFT_BORDER", "DEFAULT_RIGHT_BORDER", "DEFAULT_TOP_BORDER", "DEFAULT_VERTICAL_BORDERS", "EMPTY_TOOL_WINDOW_FONT", "GBC_FULL", "Ljava/awt/GridBagConstraints;", "createHorizontalSeparator", "Ljavax/swing/JComponent;", "createNestedVScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "component", "getActionKeyText", "", "getActionMask", "", "isActionKeyDown", "", "event", "Ljava/awt/event/InputEvent;", "overlayColor", "backgroundRgb", "foregroundRbg", "foregroundOpacity", "", "setTooltipCursor", "Ljava/awt/Container;", "container", "cursor", "Ljava/awt/Cursor;", "shrinkToFit", "text", "metrics", "Ljava/awt/FontMetrics;", "availableSpace", "spaceThreshold", "textFitPredicate", "Ljava/util/function/Predicate;", "unscale", "i", "showAbove", "", "Lcom/intellij/openapi/ui/popup/JBPopup;", "intellij.android.adt.ui"})
public final class AdtUiUtils {
    @JvmField
    @NotNull
    public static final JBFont DEFAULT_FONT;
    @JvmField
    @NotNull
    public static final JBFont EMPTY_TOOL_WINDOW_FONT;
    @JvmField
    @NotNull
    public static final Color DEFAULT_FONT_COLOR;
    @JvmField
    @NotNull
    public static final Color DEFAULT_BORDER_COLOR;
    @JvmField
    @NotNull
    public static final Border DEFAULT_TOP_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_LEFT_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_BOTTOM_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_RIGHT_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_HORIZONTAL_BORDERS;
    @JvmField
    @NotNull
    public static final Border DEFAULT_VERTICAL_BORDERS;
    @JvmField
    @NotNull
    public static final GridBagConstraints GBC_FULL;
    @NotNull
    public static final AdtUiUtils INSTANCE;

    @JvmStatic
    public static final void showAbove(@NotNull JBPopup $this$showAbove, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)$this$showAbove, (String)"$this$showAbove");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        RelativePoint northWest = new RelativePoint((Component)component, new Point());
        $this$showAbove.addListener(new JBPopupListener(northWest){
            final /* synthetic */ RelativePoint $northWest;

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Point point;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JBPopup jBPopup = event.asPopup();
                Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"event.asPopup()");
                JBPopup popup = jBPopup;
                Point $this$apply = point = new Point(popup.getLocationOnScreen());
                boolean bl = false;
                $this$apply.y = this.$northWest.getScreenPoint().y - popup.getSize().height;
                Point location = point;
                popup.setLocation(location);
            }
            {
                this.$northWest = $captured_local_variable$0;
            }
        });
        $this$showAbove.show(northWest);
    }

    @JvmStatic
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, float spaceThreshold) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return AdtUiUtils.shrinkToFit(text, new Predicate(availableSpace, spaceThreshold, metrics){
            final /* synthetic */ float $availableSpace;
            final /* synthetic */ float $spaceThreshold;
            final /* synthetic */ FontMetrics $metrics;

            public final boolean test(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.$availableSpace > this.$spaceThreshold && this.$availableSpace >= (float)this.$metrics.stringWidth(s);
            }
            {
                this.$availableSpace = f;
                this.$spaceThreshold = f2;
                this.$metrics = fontMetrics;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return AdtUiUtils.shrinkToFit(text, metrics, availableSpace, 0.0f);
    }

    @JvmStatic
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull Predicate<String> textFitPredicate) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(textFitPredicate, (String)"textFitPredicate");
        if (textFitPredicate.test(text)) {
            return text;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            int midLength = smallestLength + (largestLength - smallestLength) / 2;
            String string = text;
            int n = 0;
            String string2 = string.substring(n, midLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (textFitPredicate.test(string2 + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        if (bestLength > 0) {
            String string = text;
            int n = 0;
            String string3 = string.substring(n, bestLength);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string3 + "...";
        } else {
            object = "";
        }
        return object;
    }

    @JvmStatic
    public static final int unscale(int i) {
        return MathKt.roundToInt((float)((float)i / JBUIScale.scale((float)1.0f)));
    }

    @JvmStatic
    @NotNull
    public static final Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color foreground = new Color(foregroundRbg);
        return new Color(MathKt.roundToInt((float)((float)background.getRed() * (1.0f - foregroundOpacity) + (float)foreground.getRed() * foregroundOpacity)), MathKt.roundToInt((float)((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)foreground.getGreen() * foregroundOpacity)), MathKt.roundToInt((float)((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)foreground.getBlue() * foregroundOpacity)));
    }

    @JvmStatic
    public static final boolean isActionKeyDown(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return SystemInfo.isMac ? event.isMetaDown() : event.isControlDown();
    }

    @JvmStatic
    @JdkConstants.InputEventMask
    public static final int getActionMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    @JvmStatic
    @NotNull
    public static final String getActionKeyText() {
        if (SystemInfo.isMac) {
            Font labelFont = StartupUiUtil.getLabelFont();
            return labelFont != null && labelFont.canDisplayUpTo("\u2318") == -1 ? "\u2318" : "Cmd";
        }
        return "Ctrl";
    }

    @JvmStatic
    @NotNull
    public static final JComponent createHorizontalSeparator() {
        JPanel separatorWrapper = new JPanel(new TabularLayout("*", "*,Fit,*"));
        separatorWrapper.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0, 0, 4, null));
        Dimension size = new Dimension(1, 2);
        separatorWrapper.setMinimumSize(size);
        separatorWrapper.setPreferredSize(size);
        separatorWrapper.setOpaque(false);
        return separatorWrapper;
    }

    @JvmStatic
    @NotNull
    public static final JBScrollPane createNestedVScrollPane(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        NestedScrollPaneMouseWheelListener.installOn((JScrollPane)scrollPane);
        return scrollPane;
    }

    @JvmStatic
    @Nullable
    public static final Container setTooltipCursor(@NotNull Container container, @NotNull Cursor cursor) {
        Container p;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        for (p = container; p != null; p = p.getParent()) {
            if (!(p instanceof TooltipLayeredPane)) continue;
            p.setCursor(cursor);
            break;
        }
        return p;
    }

    private AdtUiUtils() {
    }

    static {
        AdtUiUtils adtUiUtils;
        INSTANCE = adtUiUtils = new AdtUiUtils();
        JBFont jBFont = JBUI.Fonts.label((float)10.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"JBUI.Fonts.label(10f)");
        DEFAULT_FONT = jBFont;
        JBFont jBFont2 = JBUI.Fonts.label((float)16.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont2, (String)"JBUI.Fonts.label(16f)");
        EMPTY_TOOL_WINDOW_FONT = jBFont2;
        Color color = JBColor.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBColor.foreground()");
        DEFAULT_FONT_COLOR = color;
        DEFAULT_BORDER_COLOR = (Color)StudioColorsKt.getBorder();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder, (String)"BorderFactory.createMatt\u2026 0, DEFAULT_BORDER_COLOR)");
        DEFAULT_TOP_BORDER = matteBorder;
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder2, (String)"BorderFactory.createMatt\u2026 0, DEFAULT_BORDER_COLOR)");
        DEFAULT_LEFT_BORDER = matteBorder2;
        MatteBorder matteBorder3 = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder3, (String)"BorderFactory.createMatt\u2026 0, DEFAULT_BORDER_COLOR)");
        DEFAULT_BOTTOM_BORDER = matteBorder3;
        MatteBorder matteBorder4 = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder4, (String)"BorderFactory.createMatt\u2026 1, DEFAULT_BORDER_COLOR)");
        DEFAULT_RIGHT_BORDER = matteBorder4;
        MatteBorder matteBorder5 = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder5, (String)"BorderFactory.createMatt\u2026 0, DEFAULT_BORDER_COLOR)");
        DEFAULT_HORIZONTAL_BORDERS = matteBorder5;
        MatteBorder matteBorder6 = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder6, (String)"BorderFactory.createMatt\u2026 1, DEFAULT_BORDER_COLOR)");
        DEFAULT_VERTICAL_BORDERS = matteBorder6;
        GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);
    }
}

