/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;

public class CommonDropDownButtonUI
extends BasicButtonUI {
    private static final int ARROW_REGION_WIDTH = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HORIZONTAL_PADDING() * 2;
    private static final int ARROW_REGION_HEIGHT = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_VERTICAL_PADDING_TOP() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_VERTICAL_PADDING_BOTTOM();
    @NotNull
    private final MouseAdapter myAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            CommonDropDownButtonUI.this.myHover = true;
            event.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(1);
            }
            CommonDropDownButtonUI.this.myHover = false;
            event.getComponent().repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButtonUI$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private boolean myHover;

    @Override
    protected void installDefaults(@NotNull AbstractButton button2) {
        if (button2 == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(0);
        }
        super.installDefaults(button2);
        LookAndFeel.installProperty(button2, "opaque", false);
        Border border = button2.getBorder();
        if (border == null || border instanceof UIResource) {
            button2.setBorder(new BorderUIResource(JBUI.Borders.empty((int)4)));
        }
    }

    @Override
    protected void installListeners(@NotNull AbstractButton button2) {
        if (button2 == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(1);
        }
        super.installListeners(button2);
        button2.addMouseListener(this.myAdapter);
    }

    @Override
    protected void uninstallListeners(@NotNull AbstractButton button2) {
        if (button2 == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(2);
        }
        super.uninstallListeners(button2);
        button2.removeMouseListener(this.myAdapter);
    }

    @Override
    public Dimension getMinimumSize(@NotNull JComponent component) {
        if (component == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(3);
        }
        return this.getPreferredSize(component);
    }

    @Override
    public Dimension getPreferredSize(@NotNull JComponent component) {
        if (component == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(4);
        }
        Dimension dim = super.getPreferredSize(component);
        CommonDropDownButton dropdown = (CommonDropDownButton)component;
        if (dropdown.getAction().getShowExpandArrow()) {
            dim = new Dimension(dim.width + ARROW_REGION_WIDTH, Math.max(dim.height, ARROW_REGION_HEIGHT));
        }
        return dim;
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent component) {
        if (graphics == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(5);
        }
        if (component == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(6);
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CommonDropDownButton button2 = (CommonDropDownButton)component;
        if (this.myHover && button2.isEnabled() || button2.isSelected()) {
            GraphicsUtilKt.paintBackground(graphics, component);
        }
        super.paint(graphics, component);
        if (button2.getAction().getShowExpandArrow()) {
            Dimension dim = component.getSize();
            int arrowWidth = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH();
            int arrowHeight = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT();
            int arrowRegionWidth = arrowWidth + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HORIZONTAL_PADDING() * 2;
            float x = (float)dim.width - (float)arrowRegionWidth / 2.0f;
            float y = (float)(dim.height - arrowHeight) / 2.0f;
            Path2D.Float triangle = new Path2D.Float();
            triangle.moveTo(x, y + (float)arrowHeight);
            triangle.lineTo(x - (float)arrowWidth / 2.0f, y);
            triangle.lineTo(x + (float)arrowWidth / 2.0f, y);
            triangle.lineTo(x, y + (float)arrowHeight);
            GraphicsUtilKt.setColorAndAlpha(g2d, StandardColors.DROPDOWN_ARROW_COLOR);
            g2d.fill(triangle);
        }
    }

    @Override
    protected void paintIcon(@NotNull Graphics graphics, @NotNull JComponent component, @NotNull Rectangle iconRect) {
        CommonDropDownButton button2;
        if (graphics == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(7);
        }
        if (component == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(8);
        }
        if (iconRect == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(9);
        }
        if ((button2 = (CommonDropDownButton)component).getAction().getShowExpandArrow()) {
            iconRect.x -= ARROW_REGION_WIDTH / 2;
        }
        super.paintIcon(graphics, component, iconRect);
    }

    @Override
    protected void paintText(@NotNull Graphics graphics, @NotNull AbstractButton component, @NotNull Rectangle textRect, @NotNull String text) {
        CommonDropDownButton button2;
        if (graphics == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(10);
        }
        if (component == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(11);
        }
        if (textRect == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(12);
        }
        if (text == null) {
            CommonDropDownButtonUI.$$$reportNull$$$0(13);
        }
        if ((button2 = (CommonDropDownButton)component).getAction().getShowExpandArrow()) {
            textRect.x -= ARROW_REGION_WIDTH / 2;
        }
        super.paintText(graphics, button2, textRect, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconRect";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRect";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButtonUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "installListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstallListeners";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimumSize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredSize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "paintIcon";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "paintText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

