/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.impl.JpsEntitySourceFactory;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelModifiableEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageOnBuilder;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.importing.ModuleModelProxyImpl$disposeModule$;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J%\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/importing/ModuleModelProxyImpl;", "Lorg/jetbrains/idea/maven/importing/ModuleModelProxy;", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;Lcom/intellij/openapi/project/Project;)V", "modules", "", "Lcom/intellij/openapi/module/Module;", "getModules", "()[Lcom/intellij/openapi/module/Module;", "versionedStorage", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "disposeModule", "", "module", "findModuleByName", "name", "", "newModule", "path", "moduleTypeId", "renameModule", "moduleName", "setModuleGroupPath", "groupPath", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)V", "intellij.maven"})
public final class ModuleModelProxyImpl
implements ModuleModelProxy {
    private final VirtualFileUrlManager virtualFileManager;
    private final VersionedEntityStorage versionedStorage;
    private final WorkspaceEntityStorageBuilder diff;
    private final Project project;

    @Override
    public void disposeModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        if (project2.isDisposed()) {
            return;
        }
        if (!(module instanceof ModuleBridge)) {
            return;
        }
        ModuleEntity moduleEntity2 = ModuleManagerBridgeImpl.Companion.findModuleEntity((WorkspaceEntityStorage)this.diff, (ModuleBridge)module);
        if (moduleEntity2 == null) {
            return;
        }
        ModuleEntity moduleEntity3 = moduleEntity2;
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)moduleEntity3.getDependencies());
        boolean $i$f$filterIsInstance = false;
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)disposeModule$$inlined$filterIsInstance$1.INSTANCE), (Function1)((Function1)new Function1<ModuleDependencyItem.Exportable.LibraryDependency, Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke(@NotNull ModuleDependencyItem.Exportable.LibraryDependency it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LibraryTableId libraryTableId = it.getLibrary().getTableId();
                if (!(libraryTableId instanceof LibraryTableId.ModuleLibraryTableId)) {
                    libraryTableId = null;
                }
                LibraryTableId.ModuleLibraryTableId moduleLibraryTableId = (LibraryTableId.ModuleLibraryTableId)libraryTableId;
                return Intrinsics.areEqual((Object)(moduleLibraryTableId != null ? moduleLibraryTableId.getModuleId() : null), (Object)((ModuleBridge)this.$module).getModuleEntityId());
            }
            {
                this.$module = module;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ModuleDependencyItem.Exportable.LibraryDependency, LibraryEntity>(this){
            final /* synthetic */ ModuleModelProxyImpl this$0;

            @Nullable
            public final LibraryEntity invoke(@NotNull ModuleDependencyItem.Exportable.LibraryDependency it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (LibraryEntity)it.getLibrary().resolve((WorkspaceEntityStorage)ModuleModelProxyImpl.access$getDiff$p(this.this$0));
            }
            {
                this.this$0 = moduleModelProxyImpl;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity it = (LibraryEntity)element$iv;
            boolean bl = false;
            this.diff.removeEntity((WorkspaceEntity)it);
        }
        this.diff.removeEntity((WorkspaceEntity)moduleEntity3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Module[] getModules() {
        Collection $this$map2Array$iv = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)this.diff.entities(ModuleEntity.class), (Function1)((Function1)new Function1<ModuleEntity, ModuleBridge>(this){
            final /* synthetic */ ModuleModelProxyImpl this$0;

            @Nullable
            public final ModuleBridge invoke(@NotNull ModuleEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ModuleManagerBridgeImpl.Companion.findModuleByEntity((WorkspaceEntityStorage)ModuleModelProxyImpl.access$getDiff$p(this.this$0), it);
            }
            {
                this.this$0 = moduleModelProxyImpl;
                super(1);
            }
        }))));
        boolean $i$f$map2Array = false;
        Module[] moduleArray = new Module[$this$map2Array$iv.size()];
        Object[] array$iv = moduleArray;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv$iv = $this$map2Array$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void it;
            void t$iv;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl2 = false;
            ModuleBridge moduleBridge = (ModuleBridge)t$iv;
            int n2 = index$iv;
            Object[] objectArray = array$iv;
            boolean bl3 = false;
            Module module = (Module)it;
            objectArray[n2] = module;
        }
        return (Module[])((Object[])moduleArray);
    }

    @Override
    @Nullable
    public Module findModuleByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ModuleEntity moduleEntity2 = (ModuleEntity)this.diff.resolve((PersistentEntityId)new ModuleId(name));
        if (moduleEntity2 == null) {
            return null;
        }
        ModuleEntity entity = moduleEntity2;
        return (Module)ModuleManagerBridgeImpl.Companion.findModuleByEntity((WorkspaceEntityStorage)this.diff, entity);
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String path, @NotNull String moduleTypeId) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)moduleTypeId, (String)"moduleTypeId");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndependentName(path)");
        String systemIndependentPath = string;
        ModulePath modulePath = new ModulePath(systemIndependentPath, null);
        String name = modulePath.getModuleName();
        String string2 = PathUtil.getParentPath((String)systemIndependentPath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getParentPath(\n\u2026   systemIndependentPath)");
        EntitySource source = JpsEntitySourceFactory.INSTANCE.createEntitySourceForModule(this.project, this.virtualFileManager.fromPath(string2), ExternalProjectSystemRegistry.getInstance().getSourceById("Maven"));
        ModuleEntity moduleEntity2 = (ModuleEntity)this.diff.addEntity(ModifiableModuleEntity.class, source, (Function1)new Function1<ModifiableModuleEntity, Unit>(name, moduleTypeId){
            final /* synthetic */ String $name;
            final /* synthetic */ String $moduleTypeId;

            public final void invoke(@NotNull ModifiableModuleEntity $this$addEntity) {
                Intrinsics.checkNotNullParameter((Object)$this$addEntity, (String)"$receiver");
                $this$addEntity.setName(this.$name);
                $this$addEntity.setType(this.$moduleTypeId);
                $this$addEntity.setDependencies(CollectionsKt.listOf((Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE));
            }
            {
                this.$name = string;
                this.$moduleTypeId = string2;
                super(1);
            }
        });
        ModuleManagerBridgeImpl moduleManager = ModuleManagerBridgeImpl.Companion.getInstance(this.project);
        ModuleBridge module = moduleManager.createModuleInstance(moduleEntity2, this.versionedStorage, (WorkspaceEntityStorageDiffBuilder)this.diff, true, null);
        this.diff.getMutableExternalMapping("intellij.modules.bridge").addMapping((WorkspaceEntity)moduleEntity2, (Object)module);
        return (Module)module;
    }

    @Override
    public void setModuleGroupPath(@NotNull Module module, @Nullable String[] groupPath) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!(module instanceof ModuleBridge)) {
            return;
        }
        ModuleEntity moduleEntity2 = ModuleManagerBridgeImpl.Companion.findModuleEntity((WorkspaceEntityStorage)this.diff, (ModuleBridge)module);
        if (moduleEntity2 == null) {
            String string = "Could not resolve module entity for " + module;
            throw new IllegalStateException(string.toString());
        }
        ModuleEntity moduleEntity3 = moduleEntity2;
        ModuleGroupPathEntity moduleGroupEntity = moduleEntity3.getGroupPath();
        List groupPathList = groupPath != null ? ArraysKt.toList((Object[])groupPath) : null;
        ModuleGroupPathEntity moduleGroupPathEntity = moduleGroupEntity;
        if (Intrinsics.areEqual((Object)(moduleGroupPathEntity != null ? moduleGroupPathEntity.getPath() : null), (Object)groupPathList) ^ true) {
            if (moduleGroupEntity == null && groupPathList != null) {
                EntitySource entitySource = moduleEntity3.getEntitySource();
                List list = groupPathList;
                ModuleEntity moduleEntity4 = moduleEntity3;
                BridgeModelModifiableEntitiesKt.addModuleGroupPathEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)this.diff), (List)list, (ModuleEntity)moduleEntity4, (EntitySource)entitySource);
            } else if (moduleGroupEntity != null || groupPathList != null) {
                if (moduleGroupEntity != null && groupPathList == null) {
                    this.diff.removeEntity((WorkspaceEntity)moduleGroupEntity);
                } else if (moduleGroupEntity != null && groupPathList != null) {
                    this.diff.modifyEntity(ModifiableModuleGroupPathEntity.class, (WorkspaceEntity)moduleGroupEntity, (Function1)new Function1<ModifiableModuleGroupPathEntity, Unit>(groupPathList){
                        final /* synthetic */ List $groupPathList;

                        public final void invoke(@NotNull ModifiableModuleGroupPathEntity $this$modifyEntity) {
                            Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                            $this$modifyEntity.setPath(this.$groupPathList);
                        }
                        {
                            this.$groupPathList = list;
                            super(1);
                        }
                    });
                } else {
                    String string = "Should not be reached";
                    throw new IllegalStateException(string.toString());
                }
            }
        }
    }

    @Override
    public void renameModule(@NotNull Module module, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        String string = "Not yet implemented";
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)string));
    }

    public ModuleModelProxyImpl(@NotNull WorkspaceEntityStorageBuilder diff, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.diff = diff;
        this.project = project2;
        Object object = this.project.getService(VirtualFileUrlManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Virtu\u2026leUrlManager::class.java)");
        this.virtualFileManager = (VirtualFileUrlManager)object;
        this.versionedStorage = (VersionedEntityStorage)new VersionedEntityStorageOnBuilder(this.diff);
    }

    public static final /* synthetic */ WorkspaceEntityStorageBuilder access$getDiff$p(ModuleModelProxyImpl $this) {
        return $this.diff;
    }
}

