/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;

public class MavenAnnotationProcessorConfigurer
extends MavenModuleConfigurer {
    public static final String PROFILE_PREFIX = "Annotation profile for ";
    public static final String MAVEN_DEFAULT_ANNOTATION_PROFILE = "Maven default annotation processors profile";
    public static final String DEFAULT_ANNOTATION_PATH_OUTPUT = "target/generated-sources/annotations";
    public static final String DEFAULT_TEST_ANNOTATION_OUTPUT = "target/generated-test-sources/test-annotations";
    public static final String MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE = "Annotation profile for maven-processor-plugin default configuration";
    public static final String DEFAULT_BSC_ANNOTATION_PATH_OUTPUT = "target/generated-sources/apt";
    public static final String DEFAULT_BSC_TEST_ANNOTATION_OUTPUT = "target/generated-sources/apt-test";

    @Override
    public void configure(@NotNull MavenProject mavenProject2, @NotNull Project project2, @NotNull Module module) {
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(1);
        }
        if (module == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(2);
        }
        WriteAction.runAndWait(() -> MavenAnnotationProcessorConfigurer.doConfigure(mavenProject2, project2, module));
    }

    private static void doConfigure(@NotNull MavenProject mavenProject2, @NotNull Project project2, @NotNull Module module) {
        String versionString;
        LanguageLevel languageLevel;
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(4);
        }
        if (module == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(5);
        }
        if (project2.isDisposed() || module.isDisposed()) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && (languageLevel = LanguageLevel.parse((String)(versionString = sdk.getVersionString()))) != null && languageLevel.isLessThan(LanguageLevel.JDK_1_6)) {
            return;
        }
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        MavenProject rootProject = (MavenProject)ObjectUtils.notNull((Object)MavenProjectsManager.getInstance(project2).findRootProject(mavenProject2), (Object)mavenProject2);
        if (MavenAnnotationProcessorConfigurer.shouldEnableAnnotationProcessors(mavenProject2)) {
            boolean isDefault;
            Object moduleProfileName;
            String testAnnotationProcessorDirectory;
            String annotationProcessorDirectory = MavenAnnotationProcessorConfigurer.getRelativeAnnotationProcessorDirectory(mavenProject2, false);
            if (annotationProcessorDirectory == null) {
                annotationProcessorDirectory = DEFAULT_ANNOTATION_PATH_OUTPUT;
            }
            if ((testAnnotationProcessorDirectory = MavenAnnotationProcessorConfigurer.getRelativeAnnotationProcessorDirectory(mavenProject2, true)) == null) {
                testAnnotationProcessorDirectory = DEFAULT_TEST_ANNOTATION_OUTPUT;
            }
            if (MavenAnnotationProcessorConfigurer.isMavenDefaultAnnotationProcessorConfiguration(annotationProcessorDirectory, testAnnotationProcessorDirectory, mavenProject2, project2)) {
                moduleProfileName = MAVEN_DEFAULT_ANNOTATION_PROFILE;
                isDefault = true;
            } else if (MavenAnnotationProcessorConfigurer.isMavenProcessorPluginDefaultConfiguration(annotationProcessorDirectory, testAnnotationProcessorDirectory, mavenProject2, project2)) {
                moduleProfileName = MAVEN_BSC_DEFAULT_ANNOTATION_PROFILE;
                isDefault = true;
            } else {
                moduleProfileName = PROFILE_PREFIX + module.getName();
                isDefault = false;
            }
            ProcessorConfigProfile moduleProfile = compilerConfiguration.findModuleProcessorProfile((String)moduleProfileName);
            if (moduleProfile == null) {
                moduleProfile = new ProcessorConfigProfileImpl((String)moduleProfileName);
                moduleProfile.setEnabled(true);
                compilerConfiguration.addModuleProcessorProfile(moduleProfile);
            }
            if (!moduleProfile.isEnabled()) {
                return;
            }
            if (MavenProjectImporter.isImportToTreeStructureEnabled(project2)) {
                moduleProfile.setOutputRelativeToContentRoot(false);
            } else {
                moduleProfile.setOutputRelativeToContentRoot(true);
            }
            moduleProfile.setObtainProcessorsFromClasspath(true);
            moduleProfile.setGeneratedSourcesDirectoryName(annotationProcessorDirectory, false);
            moduleProfile.setGeneratedSourcesDirectoryName(testAnnotationProcessorDirectory, true);
            moduleProfile.clearProcessorOptions();
            for (Map.Entry<String, String> entry : mavenProject2.getAnnotationProcessorOptions().entrySet()) {
                moduleProfile.setOption(entry.getKey(), entry.getValue());
            }
            moduleProfile.clearProcessors();
            List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
            if (processors != null) {
                for (String processor : processors) {
                    moduleProfile.addProcessor(processor);
                }
            }
            moduleProfile.addModuleName(module.getName());
            MavenAnnotationProcessorConfigurer.configureAnnotationProcessorPath(moduleProfile, mavenProject2, project2);
            MavenAnnotationProcessorConfigurer.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, moduleProfile, isDefault, module);
        } else {
            MavenAnnotationProcessorConfigurer.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration, null, false, module);
        }
    }

    private static void configureAnnotationProcessorPath(ProcessorConfigProfile profile, MavenProject mavenProject2, Project project2) {
        String annotationProcessorPath = mavenProject2.getAnnotationProcessorPath(project2);
        if (StringUtil.isNotEmpty((String)annotationProcessorPath)) {
            profile.setObtainProcessorsFromClasspath(false);
            profile.setProcessorPath(annotationProcessorPath);
        }
    }

    private static void cleanAndMergeModuleProfiles(@NotNull MavenProject rootProject, @NotNull CompilerConfigurationImpl compilerConfiguration, @Nullable ProcessorConfigProfile moduleProfile, boolean isDefault, @NotNull Module module) {
        if (rootProject == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(6);
        }
        if (compilerConfiguration == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(7);
        }
        if (module == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(8);
        }
        ArrayList profiles2 = new ArrayList(compilerConfiguration.getModuleProcessorProfiles());
        for (ProcessorConfigProfile p : profiles2) {
            if (p != moduleProfile) {
                p.removeModuleName(module.getName());
                if (p.getModuleNames().isEmpty() && p.getName().startsWith(PROFILE_PREFIX)) {
                    compilerConfiguration.removeModuleProcessorProfile(p);
                }
            }
            if (isDefault || moduleProfile == null || !MavenAnnotationProcessorConfigurer.isSimilarProfiles(p, moduleProfile)) continue;
            moduleProfile.setEnabled(p.isEnabled());
            String mavenProjectRootProfileName = PROFILE_PREFIX + rootProject.getDisplayName();
            ProcessorConfigProfile mergedProfile = compilerConfiguration.findModuleProcessorProfile(mavenProjectRootProfileName);
            if (mergedProfile == null) {
                mergedProfile = new ProcessorConfigProfileImpl(moduleProfile);
                mergedProfile.setName(mavenProjectRootProfileName);
                compilerConfiguration.addModuleProcessorProfile(mergedProfile);
                mergedProfile.addModuleNames((Collection)p.getModuleNames());
                p.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(p);
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
                continue;
            }
            if (p != mergedProfile && !MavenAnnotationProcessorConfigurer.isSimilarProfiles(mergedProfile, moduleProfile)) continue;
            if (moduleProfile != mergedProfile) {
                mergedProfile.addModuleNames((Collection)moduleProfile.getModuleNames());
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
            }
            if (p == mergedProfile) continue;
            mergedProfile.addModuleNames((Collection)p.getModuleNames());
            p.clearModuleNames();
            compilerConfiguration.removeModuleProcessorProfile(p);
        }
    }

    private static boolean isSimilarProfiles(@Nullable ProcessorConfigProfile profile1, @Nullable ProcessorConfigProfile profile2) {
        if (profile1 == null || profile2 == null) {
            return false;
        }
        ProcessorConfigProfileImpl p1 = new ProcessorConfigProfileImpl(profile1);
        p1.setName("tmp");
        p1.setEnabled(true);
        p1.clearModuleNames();
        ProcessorConfigProfileImpl p2 = new ProcessorConfigProfileImpl(profile2);
        p2.setName("tmp");
        p2.setEnabled(true);
        p2.clearModuleNames();
        return p1.equals((Object)p2);
    }

    private static boolean isMavenDefaultAnnotationProcessorConfiguration(@NotNull String annotationProcessorDirectory, @NotNull String testAnnotationProcessorDirectory, @NotNull MavenProject mavenProject2, @NotNull Project project2) {
        if (annotationProcessorDirectory == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(9);
        }
        if (testAnnotationProcessorDirectory == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(10);
        }
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(12);
        }
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        return ContainerUtil.isEmpty(processors) && options.isEmpty() && StringUtil.isEmpty((String)mavenProject2.getAnnotationProcessorPath(project2)) && DEFAULT_ANNOTATION_PATH_OUTPUT.equals(annotationProcessorDirectory.replace('\\', '/')) && DEFAULT_TEST_ANNOTATION_OUTPUT.equals(testAnnotationProcessorDirectory.replace('\\', '/'));
    }

    private static boolean isMavenProcessorPluginDefaultConfiguration(@NotNull String annotationProcessorDirectory, @NotNull String testAnnotationProcessorDirectory, @NotNull MavenProject mavenProject2, @NotNull Project project2) {
        if (annotationProcessorDirectory == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(13);
        }
        if (testAnnotationProcessorDirectory == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(14);
        }
        if (mavenProject2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            MavenAnnotationProcessorConfigurer.$$$reportNull$$$0(16);
        }
        Map<String, String> options = mavenProject2.getAnnotationProcessorOptions();
        List<String> processors = mavenProject2.getDeclaredAnnotationProcessors();
        return ContainerUtil.isEmpty(processors) && options.isEmpty() && StringUtil.isEmpty((String)mavenProject2.getAnnotationProcessorPath(project2)) && DEFAULT_BSC_ANNOTATION_PATH_OUTPUT.equals(annotationProcessorDirectory.replace('\\', '/')) && DEFAULT_BSC_TEST_ANNOTATION_OUTPUT.equals(testAnnotationProcessorDirectory.replace('\\', '/'));
    }

    @Nullable
    private static String getRelativeAnnotationProcessorDirectory(MavenProject mavenProject2, boolean isTest) {
        String annotationProcessorDirectory = mavenProject2.getAnnotationProcessorDirectory(isTest);
        Path annotationProcessorDirectoryFile = Path.of(annotationProcessorDirectory, new String[0]);
        if (!annotationProcessorDirectoryFile.isAbsolute()) {
            return annotationProcessorDirectory;
        }
        String absoluteProjectDirectory = mavenProject2.getDirectory();
        try {
            return Path.of(absoluteProjectDirectory, new String[0]).relativize(annotationProcessorDirectoryFile).toString();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean shouldEnableAnnotationProcessors(MavenProject mavenProject2) {
        if ("pom".equals(mavenProject2.getPackaging())) {
            return false;
        }
        return mavenProject2.getProcMode() != MavenProject.ProcMode.NONE || mavenProject2.findPlugin("org.bsc.maven", "maven-processor-plugin") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerConfiguration";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationProcessorDirectory";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testAnnotationProcessorDirectory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/configurers/MavenAnnotationProcessorConfigurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doConfigure";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanAndMergeModuleProfiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isMavenDefaultAnnotationProcessorConfiguration";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isMavenProcessorPluginDefaultConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

