/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.reposearch.DependencySearchService;

@ApiStatus.Internal
public class MavenIndices
implements Disposable {
    public static final String LOCAL_REPOSITORY_ID = "local";
    private static final Object ourDirectoryLock = new Object();
    private final MavenIndexerWrapper myIndexer;
    private final File myIndicesDir;
    private final MavenSearchIndex.IndexListener myListener;
    @NotNull
    private volatile MavenIndexHolder myIndexHolder = new MavenIndexHolder(Collections.emptyList(), null);
    private volatile boolean indicesInit;
    private volatile boolean isDisposed;
    private final ReentrantLock updateIndicesLock = new ReentrantLock();

    public MavenIndices(MavenIndexerWrapper indexer, File indicesDir, MavenSearchIndex.IndexListener listener2) {
        this.myIndexer = indexer;
        this.myIndicesDir = indicesDir;
        this.myListener = listener2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateIndicesList(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndices.$$$reportNull$$$0(0);
        }
        if (this.isDisposed) {
            return;
        }
        this.updateIndicesLock.lock();
        try {
            Map<String, Set<String>> remoteRepositoryIdsByUrl = MavenIndexUtils.getRemoteRepositoryIdsByUrl(project2);
            MavenIndexUtils.RepositoryInfo localRepository = MavenIndexUtils.getLocalRepository(project2);
            if (localRepository == null || project2.isDisposed()) {
                return;
            }
            if (this.myIndexHolder.isEquals(remoteRepositoryIdsByUrl.keySet(), localRepository.url)) {
                return;
            }
            MavenLog.LOG.debug("start update indices " + this.myIndexHolder);
            MavenIndex localIndex = this.myIndexHolder.getLocalIndex();
            List<MavenIndex> remoteIndices = this.myIndexHolder.getRemoteIndices();
            if (this.isDisposed) {
                return;
            }
            RepositoryDiffContext context = new RepositoryDiffContext(this.myIndexer, this.myListener, this.myIndicesDir);
            RepositoryDiff<MavenIndex> localDiff = MavenIndices.getLocalDiff(localRepository, context, localIndex);
            RepositoryDiff<List<MavenIndex>> remoteDiff = MavenIndices.getRemoteDiff(remoteRepositoryIdsByUrl, remoteIndices, context);
            this.myIndexHolder = new MavenIndexHolder((List)remoteDiff.newIndices, (MavenIndex)localDiff.newIndices);
            MavenLog.LOG.debug("new indices " + this.myIndexHolder);
            if (this.isDisposed) {
                MavenIndices.closeIndices(this.myIndexHolder.getIndices());
            }
            this.indicesInit = true;
            MavenIndices.closeIndices(MavenIndices.getOldIndices(localDiff, remoteDiff));
            MavenIndices.updateDependencySearchProviders(project2);
        }
        catch (AlreadyDisposedException e) {
            this.myIndexHolder = new MavenIndexHolder(Collections.emptyList(), null);
        }
        finally {
            this.updateIndicesLock.unlock();
        }
    }

    public boolean isIndicesInit() {
        return this.indicesInit;
    }

    public boolean isNotInit() {
        return !this.indicesInit;
    }

    private static List<MavenIndex> getOldIndices(@NotNull RepositoryDiff<MavenIndex> localDiff, @NotNull RepositoryDiff<List<MavenIndex>> remoteDiff) {
        if (localDiff == null) {
            MavenIndices.$$$reportNull$$$0(1);
        }
        if (remoteDiff == null) {
            MavenIndices.$$$reportNull$$$0(2);
        }
        ArrayList<MavenIndex> oldIndices = new ArrayList<MavenIndex>((Collection)remoteDiff.oldIndices);
        if (localDiff.oldIndices != null) {
            oldIndices.add((MavenIndex)localDiff.oldIndices);
        }
        return oldIndices;
    }

    @NotNull
    private static List<MavenIndexUtils.IndexPropertyHolder> readCurrentIndexFileProperty(@NotNull File indicesDir) {
        Object[] indices;
        if (indicesDir == null) {
            MavenIndices.$$$reportNull$$$0(3);
        }
        if ((indices = indicesDir.listFiles()) == null) {
            List<MavenIndexUtils.IndexPropertyHolder> list = Collections.emptyList();
            if (list == null) {
                MavenIndices.$$$reportNull$$$0(4);
            }
            return list;
        }
        Arrays.sort(indices);
        ArrayList<MavenIndexUtils.IndexPropertyHolder> result = new ArrayList<MavenIndexUtils.IndexPropertyHolder>();
        for (Object each : indices) {
            if (!((File)each).isDirectory()) continue;
            try {
                MavenIndexUtils.IndexPropertyHolder propertyHolder = MavenIndexUtils.readIndexProperty((File)each);
                result.add(propertyHolder);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        ArrayList<MavenIndexUtils.IndexPropertyHolder> arrayList = result;
        if (arrayList == null) {
            MavenIndices.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public List<MavenIndex> getIndices() {
        return this.myIndexHolder.getIndices();
    }

    @NotNull
    public MavenIndexHolder getIndexHolder() {
        MavenIndexHolder mavenIndexHolder = this.myIndexHolder;
        if (mavenIndexHolder == null) {
            MavenIndices.$$$reportNull$$$0(6);
        }
        return mavenIndexHolder;
    }

    @NotNull
    private static File createNewIndexDir(File parent) {
        return MavenIndices.createNewDir(parent, "Index", 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static File createNewDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            int i = 0;
            while (true) {
                boolean createSuccessFull;
                if (i >= max) {
                    throw new RuntimeException("No available dir found");
                }
                String name = prefix + i;
                File f = new File(parent, name);
                if (!f.exists() && (createSuccessFull = f.mkdirs())) {
                    File file = f;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (file == null) {
                        MavenIndices.$$$reportNull$$$0(7);
                    }
                    return file;
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this.isDisposed = true;
        MavenIndices.closeIndices(this.myIndexHolder.getIndices());
    }

    private static void closeIndices(@NotNull List<MavenIndex> indices) {
        if (indices == null) {
            MavenIndices.$$$reportNull$$$0(8);
        }
        for (MavenIndex each : indices) {
            try {
                each.finalClose(false);
            }
            catch (Exception e) {
                MavenLog.LOG.error("indices dispose error", (Throwable)e);
            }
        }
    }

    public static void updateOrRepair(@NotNull MavenSearchIndex index, boolean fullUpdate, @Nullable MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        if (index == null) {
            MavenIndices.$$$reportNull$$$0(9);
        }
        index.updateOrRepair(fullUpdate, settings, progress);
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<MavenIndex> getLocalDiff(@NotNull MavenIndexUtils.RepositoryInfo localRepo, @NotNull RepositoryDiffContext context, @Nullable MavenIndex currentLocalIndex) {
        if (localRepo == null) {
            MavenIndices.$$$reportNull$$$0(10);
        }
        if (context == null) {
            MavenIndices.$$$reportNull$$$0(11);
        }
        if (currentLocalIndex != null && FileUtil.pathsEqual((String)localRepo.url, (String)currentLocalIndex.getRepositoryPathOrUrl())) {
            return new RepositoryDiff<Object>(currentLocalIndex, null);
        }
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders = MavenIndices.readCurrentIndexFileProperty(context.indicesDir);
        context.indexPropertyHolders = indexPropertyHolders;
        MavenIndex index = indexPropertyHolders.stream().filter(iph -> iph.kind == MavenSearchIndex.Kind.LOCAL && FileUtil.pathsEqual((String)iph.repositoryPathOrUrl, (String)localRepo.url)).findFirst().map(iph -> MavenIndices.createMavenIndex(iph, context)).orElseGet(() -> {
            MavenIndexUtils.IndexPropertyHolder propertyHolder = new MavenIndexUtils.IndexPropertyHolder(MavenIndices.createNewIndexDir(context.indicesDir), MavenSearchIndex.Kind.LOCAL, Collections.singleton(LOCAL_REPOSITORY_ID), localRepo.url);
            return MavenIndices.createMavenIndex(propertyHolder, context);
        });
        if (index == null) {
            return new RepositoryDiff<Object>(currentLocalIndex, null);
        }
        return new RepositoryDiff<MavenIndex>(index, currentLocalIndex);
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<List<MavenIndex>> getRemoteDiff(@NotNull Map<String, Set<String>> remoteRepositoryIdsByUrl, @NotNull List<MavenIndex> currentRemoteIndex, @NotNull RepositoryDiffContext context) {
        Map currentRemoteIndicesByUrls;
        if (remoteRepositoryIdsByUrl == null) {
            MavenIndices.$$$reportNull$$$0(12);
        }
        if (currentRemoteIndex == null) {
            MavenIndices.$$$reportNull$$$0(13);
        }
        if (context == null) {
            MavenIndices.$$$reportNull$$$0(14);
        }
        if ((currentRemoteIndicesByUrls = currentRemoteIndex.stream().collect(Collectors.toMap(i -> i.getRepositoryPathOrUrl(), Function.identity()))).keySet().equals(remoteRepositoryIdsByUrl.keySet())) {
            return new RepositoryDiff<List<MavenIndex>>(currentRemoteIndex, Collections.emptyList());
        }
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders = context.indexPropertyHolders;
        indexPropertyHolders = indexPropertyHolders != null ? indexPropertyHolders : MavenIndices.readCurrentIndexFileProperty(context.indicesDir);
        Map propertyHolderMapByUrl = indexPropertyHolders.stream().filter(iph -> iph.kind == MavenSearchIndex.Kind.REMOTE).collect(Collectors.toMap(iph -> iph.repositoryPathOrUrl, Function.identity(), (i1, i2) -> i1));
        List oldIndices = ContainerUtil.filter(currentRemoteIndex, i -> !remoteRepositoryIdsByUrl.containsKey(i.getRepositoryPathOrUrl()));
        List newMavenIndices = remoteRepositoryIdsByUrl.entrySet().stream().map(e -> MavenIndices.createMavenIndex((MavenIndex)currentRemoteIndicesByUrls.get(e.getKey()), (MavenIndexUtils.IndexPropertyHolder)propertyHolderMapByUrl.get(e.getKey()), e, context)).filter(i -> i != null).collect(Collectors.toList());
        return new RepositoryDiff<List<MavenIndex>>(newMavenIndices, oldIndices);
    }

    private static MavenIndex createMavenIndex(@Nullable MavenIndex index, @Nullable MavenIndexUtils.IndexPropertyHolder propertyHolder, @NotNull Map.Entry<String, Set<String>> remoteEntry, @NotNull RepositoryDiffContext context) {
        if (remoteEntry == null) {
            MavenIndices.$$$reportNull$$$0(15);
        }
        if (context == null) {
            MavenIndices.$$$reportNull$$$0(16);
        }
        if (index != null) {
            return index;
        }
        if (propertyHolder != null) {
            index = MavenIndices.createMavenIndex(propertyHolder, context);
        }
        if (index != null) {
            return index;
        }
        propertyHolder = new MavenIndexUtils.IndexPropertyHolder(MavenIndices.createNewIndexDir(context.indicesDir), MavenSearchIndex.Kind.REMOTE, remoteEntry.getValue(), remoteEntry.getKey());
        return MavenIndices.createMavenIndex(propertyHolder, context);
    }

    private static void updateDependencySearchProviders(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndices.$$$reportNull$$$0(17);
        }
        try {
            DependencySearchService.getInstance((Project)project2).updateProviders();
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    @Nullable
    private static MavenIndex createMavenIndex(@NotNull MavenIndexUtils.IndexPropertyHolder propertyHolder, @NotNull RepositoryDiffContext context) {
        if (propertyHolder == null) {
            MavenIndices.$$$reportNull$$$0(18);
        }
        if (context == null) {
            MavenIndices.$$$reportNull$$$0(19);
        }
        try {
            return new MavenIndex(context.indexer, propertyHolder, context.listener);
        }
        catch (Exception e) {
            FileUtil.delete((File)propertyHolder.dir);
            MavenLog.LOG.warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDiff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDiff";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicesDir";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepo";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositoryIdsByUrl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRemoteIndex";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteEntry";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readCurrentIndexFileProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIndicesList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOldIndices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readCurrentIndexFileProperty";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "closeIndices";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateOrRepair";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalDiff";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDiff";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createMavenIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencySearchProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RepositoryDiffContext {
        @NotNull
        final MavenIndexerWrapper indexer;
        @NotNull
        final MavenSearchIndex.IndexListener listener;
        @NotNull
        final File indicesDir;
        @Nullable
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders;

        RepositoryDiffContext(@NotNull MavenIndexerWrapper indexer, @NotNull MavenSearchIndex.IndexListener listener2, @NotNull File dir2) {
            if (indexer == null) {
                RepositoryDiffContext.$$$reportNull$$$0(0);
            }
            if (dir2 == null) {
                RepositoryDiffContext.$$$reportNull$$$0(1);
            }
            if (listener2 == null) {
                RepositoryDiffContext.$$$reportNull$$$0(2);
            }
            this.indexer = indexer;
            this.listener = listener2;
            this.indicesDir = dir2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndices$RepositoryDiffContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RepositoryDiff<T> {
        final T newIndices;
        final T oldIndices;

        private RepositoryDiff(T newIndices, T oldIndices) {
            this.newIndices = newIndices;
            this.oldIndices = oldIndices;
        }
    }
}

