/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenWrapperDownloader;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsProcessorReadingTask
implements MavenProjectsProcessorTask {
    private final boolean myForce;
    private final MavenProjectsTree myTree;
    private final MavenGeneralSettings mySettings;
    private final List<VirtualFile> myFilesToUpdate;
    private final List<VirtualFile> myFilesToDelete;
    @Nullable
    private final Runnable myOnCompletion;

    public MavenProjectsProcessorReadingTask(boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, @Nullable Runnable onCompletion) {
        this(null, null, force, tree, settings, onCompletion);
    }

    public MavenProjectsProcessorReadingTask(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, @Nullable Runnable onCompletion) {
        this.myForce = force;
        this.myTree = tree;
        this.mySettings = settings;
        this.myFilesToUpdate = filesToUpdate;
        this.myFilesToDelete = filesToDelete;
        this.myOnCompletion = onCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console2, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        try {
            if (this.myFilesToUpdate == null) {
                this.checkOrInstallMavenWrapper(project2);
                this.myTree.updateAll(this.myForce, this.mySettings, indicator);
            } else {
                this.myTree.delete(this.myFilesToDelete, this.mySettings, indicator);
                this.myTree.update(this.myFilesToUpdate, this.myForce, this.mySettings, indicator);
            }
            this.mySettings.updateFromMavenConfig(this.myTree.getRootProjectsFiles());
        }
        finally {
            if (this.myOnCompletion != null) {
                this.myOnCompletion.run();
            }
        }
    }

    private void checkOrInstallMavenWrapper(Project project2) {
        if (this.myFilesToUpdate == null && this.myTree.getExistingManagedFiles().size() == 1) {
            Path baseDir = MavenUtil.getBaseDir(this.myTree.getExistingManagedFiles().get(0));
            if (MavenUtil.isWrapper(this.mySettings)) {
                MavenWrapperDownloader.checkOrInstallForSync(project2, baseDir.toString());
            }
        }
    }
}

