/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.problem;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.problem.SarifFileProblem;
import org.jetbrains.qodana.problem.SarifFileProblemsProvider;
import org.jetbrains.qodana.problem.SarifProblemKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\nH\u0016J\u000e\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0016J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006."}, d2={"Lorg/jetbrains/qodana/problem/SarifProblem;", "", "project", "Lcom/intellij/openapi/project/Project;", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "location", "Lcom/jetbrains/qodana/sarif/model/Location;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/qodana/sarif/model/Result;Lcom/jetbrains/qodana/sarif/model/Location;)V", "charLength", "", "getCharLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "column", "getColumn", "description", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDescription", "()Ljava/lang/String;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "line", "getLine", "getProject", "()Lcom/intellij/openapi/project/Project;", "relativePathToFile", "getRelativePathToFile", "equals", "", "other", "getTextRangeInDocument", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "hashCode", "isRelevantToFile", "targetFile", "toFileProblem", "Lorg/jetbrains/qodana/problem/SarifFileProblem;", "provider", "Lorg/jetbrains/qodana/problem/SarifFileProblemsProvider;", "Companion", "intellij.qodana"})
public final class SarifProblem {
    @Nullable
    private final Integer line;
    @Nullable
    private final Integer column;
    @Nullable
    private final Integer charLength;
    @NotNull
    private final String relativePathToFile;
    @NotNull
    private final String description;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Integer getLine() {
        return this.line;
    }

    @Nullable
    public final Integer getColumn() {
        return this.column;
    }

    @Nullable
    public final Integer getCharLength() {
        return this.charLength;
    }

    @NotNull
    public final String getRelativePathToFile() {
        return this.relativePathToFile;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final VirtualFile getFile() {
        return SarifProblemKt.access$findRelativeVirtualFile(this.project, this.relativePathToFile);
    }

    public final boolean isRelevantToFile(@NotNull VirtualFile targetFile) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile2 == null) {
            return false;
        }
        Object it = virtualFile = virtualFile2;
        boolean bl = false;
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
        Object object = string;
        Path path = Paths.get((String)object, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        Path projectPath = path;
        String string2 = targetFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetFile.path");
        it = string2;
        Object object2 = Paths.get((String)it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(path)");
        Path targetFilePath = object2;
        Path targetRelativeFilePath = projectPath.relativize(targetFilePath);
        object2 = this.relativePathToFile;
        object = Paths.get((String)object2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(path)");
        return Intrinsics.areEqual((Object)targetRelativeFilePath, (Object)object);
    }

    @Nullable
    public final SarifFileProblem toFileProblem(@NotNull SarifFileProblemsProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return SarifFileProblem.Companion.fromSarifProblem(this, provider);
    }

    @Nullable
    public final TextRange getTextRangeInDocument(@NotNull Document document) {
        Integer n;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                Integer n2 = this.charLength;
                if (n2 == null) {
                    return null;
                }
                n2.intValue();
                n = this.line;
                if (n == null) break block6;
                Integer n3 = n;
                int line = ((Number)n3).intValue();
                boolean bl = false;
                Integer n4 = line < document.getLineCount() ? Integer.valueOf(document.getLineStartOffset(line)) : null;
                n = n4;
                if (n4 != null) break block7;
            }
            return null;
        }
        int lineStartOffset = n;
        Integer n5 = this.column;
        if (n5 == null) {
            return null;
        }
        int offsetInsideLine = n5;
        int offset = lineStartOffset + offsetInsideLine;
        if (offset > document.getLineEndOffset(this.line.intValue()) || offset + this.charLength > document.getTextLength()) {
            return null;
        }
        return new TextRange(offset, offset + this.charLength);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.qodana.problem.SarifProblem");
        }
        SarifProblem cfr_ignored_0 = (SarifProblem)object2;
        return Intrinsics.areEqual((Object)this.relativePathToFile, (Object)((SarifProblem)other).relativePathToFile) && Intrinsics.areEqual((Object)this.line, (Object)((SarifProblem)other).line) && Intrinsics.areEqual((Object)this.column, (Object)((SarifProblem)other).column) && Intrinsics.areEqual((Object)this.charLength, (Object)((SarifProblem)other).charLength) && Intrinsics.areEqual((Object)this.description, (Object)((SarifProblem)other).description);
    }

    public int hashCode() {
        int result = this.relativePathToFile.hashCode();
        Integer n = this.line;
        Integer n2 = n;
        result = 31 * result + (n2 == null ? 0 : ((Object)n2).hashCode());
        n2 = n = this.column;
        result = 31 * result + (n2 == null ? 0 : ((Object)n2).hashCode());
        n2 = n = this.charLength;
        result = 31 * result + (n2 == null ? 0 : ((Object)n2).hashCode());
        result = 31 * result + this.description.hashCode();
        return result;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private SarifProblem(Project project, Result result, Location location) {
        this.project = project;
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        Intrinsics.checkNotNullExpressionValue((Object)physicalLocation, (String)"location.physicalLocation");
        Region region = physicalLocation.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region, (String)"location.physicalLocation.region");
        Integer n = region.getStartLine();
        this.line = n != null ? Integer.valueOf(n - 1) : null;
        PhysicalLocation physicalLocation2 = location.getPhysicalLocation();
        Intrinsics.checkNotNullExpressionValue((Object)physicalLocation2, (String)"location.physicalLocation");
        Region region2 = physicalLocation2.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region2, (String)"location.physicalLocation.region");
        Integer n2 = region2.getStartColumn();
        this.column = n2 != null ? Integer.valueOf(n2 - 1) : null;
        PhysicalLocation physicalLocation3 = location.getPhysicalLocation();
        Intrinsics.checkNotNullExpressionValue((Object)physicalLocation3, (String)"location.physicalLocation");
        Region region3 = physicalLocation3.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region3, (String)"location.physicalLocation.region");
        this.charLength = region3.getCharLength();
        PhysicalLocation physicalLocation4 = location.getPhysicalLocation();
        String string = physicalLocation4 != null && (physicalLocation4 = physicalLocation4.getArtifactLocation()) != null ? physicalLocation4.getUri() : null;
        Intrinsics.checkNotNull((Object)string);
        this.relativePathToFile = string;
        this.description = SarifProblemKt.access$buildDescription(result);
    }

    public /* synthetic */ SarifProblem(Project project, Result result, Location location, DefaultConstructorMarker $constructor_marker) {
        this(project, result, location);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/problem/SarifProblem$Companion;", "", "()V", "fromReport", "", "Lorg/jetbrains/qodana/problem/SarifProblem;", "project", "Lcom/intellij/openapi/project/Project;", "report", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "fromResultWithLocation", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "location", "Lcom/jetbrains/qodana/sarif/model/Location;", "intellij.qodana"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SarifProblem> fromReport(@NotNull Project project, @NotNull SarifReport report) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            Object e = report.getRuns().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"report.runs[0]");
            List list = ((Run)e).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"report.runs[0].results");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list2;
                Result result = (Result)element$iv$iv;
                boolean bl = false;
                Object object = result;
                if (object != null && (object = object.getLocations()) != null && (object = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SarifProblem sarifProblem;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Location location = (Location)element$iv$iv2;
                        boolean bl3 = false;
                        SarifProblem sarifProblem2 = Companion.fromResultWithLocation(project, result, location);
                        if (sarifProblem2 == null) continue;
                        SarifProblem it$iv$iv = sarifProblem = sarifProblem2;
                        boolean bl4 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final SarifProblem fromResultWithLocation(@NotNull Project project, @NotNull Result result, @NotNull Location location) {
            block3: {
                block2: {
                    PhysicalLocation physicalLocation;
                    PhysicalLocation physicalLocation2;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    if (result.getBaselineState() == Result.BaselineState.ABSENT || ((physicalLocation2 = location.getPhysicalLocation()) != null && (physicalLocation2 = physicalLocation2.getArtifactLocation()) != null ? physicalLocation2.getUri() : null) == null || Intrinsics.areEqual((Object)((physicalLocation = location.getPhysicalLocation()) != null && (physicalLocation = physicalLocation.getArtifactLocation()) != null ? physicalLocation.getUriBaseId() : null), (Object)"SRCROOT") ^ true) break block2;
                    PhysicalLocation physicalLocation3 = location.getPhysicalLocation();
                    if ((physicalLocation3 != null ? physicalLocation3.getRegion() : null) != null) break block3;
                }
                return null;
            }
            return new SarifProblem(project, result, location, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

