/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.ReportProcessor;
import org.jetbrains.qodana.report.ReportValidator;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0003\n\u000b\fB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator;", "Lorg/jetbrains/qodana/report/ReportProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "failMessagesProvider", "Lorg/jetbrains/qodana/report/ReportValidator$FailMessagesProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/report/ReportValidator$FailMessagesProvider;)V", "processReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "report", "Companion", "FailMessagesProvider", "ValidationError", "intellij.qodana"})
public final class ReportValidator
implements ReportProcessor {
    private final Project project;
    private final FailMessagesProvider failMessagesProvider;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public SarifReport processReport(@NotNull SarifReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        ValidationError validationError = ReportValidator.Companion.getValidationError(report);
        if (validationError == null) {
            return report;
        }
        ValidationError validationError2 = validationError;
        if (this.failMessagesProvider == null) {
            return null;
        }
        Notification notification = new Notification("Qodana", QodanaBundle.message("notification.title.cant.parse.report", new Object[0]), this.failMessagesProvider.getFailedValidationMessage(validationError2), NotificationType.WARNING);
        notification.addAction((AnAction)NotificationAction.createSimple((String)QodanaBundle.message("notification.action.about.qodana.sarif.format", new Object[0]), (Runnable)processReport.1.INSTANCE));
        notification.notify(this.project);
        return null;
    }

    public ReportValidator(@Nullable Project project, @Nullable FailMessagesProvider failMessagesProvider) {
        this.project = project;
        this.failMessagesProvider = failMessagesProvider;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "", "(Ljava/lang/String;I)V", "NO_RUNS", "EMPTY_RUNS", "NO_RESULTS", "intellij.qodana"})
    public static final class ValidationError
    extends Enum<ValidationError> {
        public static final /* enum */ ValidationError NO_RUNS;
        public static final /* enum */ ValidationError EMPTY_RUNS;
        public static final /* enum */ ValidationError NO_RESULTS;
        private static final /* synthetic */ ValidationError[] $VALUES;

        static {
            ValidationError[] validationErrorArray = new ValidationError[3];
            ValidationError[] validationErrorArray2 = validationErrorArray;
            validationErrorArray[0] = NO_RUNS = new ValidationError();
            validationErrorArray[1] = EMPTY_RUNS = new ValidationError();
            validationErrorArray[2] = NO_RESULTS = new ValidationError();
            $VALUES = validationErrorArray;
        }

        public static ValidationError[] values() {
            return (ValidationError[])$VALUES.clone();
        }

        public static ValidationError valueOf(String string) {
            return Enum.valueOf(ValidationError.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$FailMessagesProvider;", "", "getFailedValidationMessage", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "validationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "intellij.qodana"})
    public static interface FailMessagesProvider {
        @NotNull
        public String getFailedValidationMessage(@NotNull ValidationError var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$Companion;", "", "()V", "getValidationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "report", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "intellij.qodana"})
    public static final class Companion {
        private final ValidationError getValidationError(SarifReport report) {
            if (report.getRuns() == null) {
                return ValidationError.NO_RUNS;
            }
            if (report.getRuns().isEmpty()) {
                return ValidationError.EMPTY_RUNS;
            }
            Object e = report.getRuns().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"report.runs[0]");
            if (((Run)e).getResults() == null) {
                return ValidationError.NO_RESULTS;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

