/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import java.io.File;
import junit.framework.ComparisonFailure;

public class FileComparisonFailure
extends ComparisonFailure {
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private final String myActualFilePath;

    public FileComparisonFailure(String message, String expected, String actual, String expectedFilePath) {
        this(message, expected, actual, expectedFilePath, null);
    }

    public FileComparisonFailure(String message, String expected, String actual, String expectedFilePath, String actualFilePath) {
        super(message, expected, actual);
        if (expected == null) {
            throw new NullPointerException("'expected' must not be null");
        }
        if (actual == null) {
            throw new NullPointerException("'actual' must not be null");
        }
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = expectedFilePath;
        if (expectedFilePath != null && !new File(expectedFilePath).isFile()) {
            throw new NullPointerException("'expectedFilePath' should point to the existing file or be null");
        }
        this.myActualFilePath = actualFilePath;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }
}

