/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.collaboration.api.ServerPath;
import com.intellij.collaboration.hosting.GitHostingUrlUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubParseException;

@Tag(value="server")
public final class GithubServerPath
implements ServerPath {
    public static final String DEFAULT_HOST = "github.com";
    public static final GithubServerPath DEFAULT_SERVER = new GithubServerPath("github.com");
    private static final String API_PREFIX = "api.";
    private static final String API_SUFFIX = "/api";
    private static final String ENTERPRISE_API_V3_SUFFIX = "/v3";
    private static final String GRAPHQL_SUFFIX = "/graphql";
    @Attribute(value="useHttp")
    @Nullable
    private final Boolean myUseHttp;
    @Attribute(value="host")
    @NotNull
    private final String myHost;
    @Attribute(value="port")
    @Nullable
    private final Integer myPort;
    @Attribute(value="suffix")
    @Nullable
    private final String mySuffix;
    private static final Pattern URL_REGEX = Pattern.compile("^(https?://)?([^/?:]+)(:(\\d+))?((/[^/?#]+)*)?/?", 2);

    public GithubServerPath() {
        this(null, "", null, null);
    }

    public GithubServerPath(@NonNls @NotNull String host) {
        if (host == null) {
            GithubServerPath.$$$reportNull$$$0(0);
        }
        this(null, host, null, null);
    }

    public GithubServerPath(@Nullable Boolean useHttp, @NonNls @NotNull String host, @Nullable Integer port, @NonNls @Nullable String suffix) {
        if (host == null) {
            GithubServerPath.$$$reportNull$$$0(1);
        }
        this.myUseHttp = useHttp;
        this.myHost = StringUtil.toLowerCase((String)host);
        this.myPort = port;
        this.mySuffix = suffix;
    }

    @NotNull
    public String getSchema() {
        return this.myUseHttp == null || this.myUseHttp == false ? "https" : "http";
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Integer getPort() {
        return this.myPort;
    }

    @Nullable
    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean matches(@NotNull String gitRemoteUrl) {
        URI uri;
        if (gitRemoteUrl == null) {
            GithubServerPath.$$$reportNull$$$0(3);
        }
        if ((uri = GitHostingUrlUtil.getUriFromRemoteUrl((String)gitRemoteUrl)) == null) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (!this.myHost.equalsIgnoreCase(host)) {
            return false;
        }
        if (this.mySuffix != null) {
            String path = uri.getPath();
            if (path == null) {
                return false;
            }
            return StringUtil.startsWithIgnoreCase((String)path, (String)this.mySuffix);
        }
        return true;
    }

    @NotNull
    public static GithubServerPath from(@NotNull String uri) throws GithubParseException {
        Integer port;
        Matcher matcher;
        if (uri == null) {
            GithubServerPath.$$$reportNull$$$0(4);
        }
        if (!(matcher = URL_REGEX.matcher(uri)).matches()) {
            throw new GithubParseException("Not a valid URL");
        }
        String schema = matcher.group(1);
        Boolean httpSchema = schema == null || schema.isEmpty() ? null : Boolean.valueOf(schema.equalsIgnoreCase("http://"));
        String host = matcher.group(2);
        if (host == null) {
            throw new GithubParseException("Empty host");
        }
        String portGroup = matcher.group(4);
        if (portGroup == null) {
            port = null;
        } else {
            try {
                port = Integer.parseInt(portGroup);
            }
            catch (NumberFormatException e) {
                throw new GithubParseException("Invalid port format");
            }
        }
        String path = StringUtil.nullize((String)matcher.group(5));
        return new GithubServerPath(httpSchema, host, port, path);
    }

    @NotNull
    public String toUrl() {
        String string = this.getSchemaUrlPart() + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String toUrl(boolean showSchema) {
        StringBuilder builder = new StringBuilder();
        if (showSchema) {
            builder.append(this.getSchemaUrlPart());
        }
        builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        String string = builder.toString();
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String toApiUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.isGithubDotCom()) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix));
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(API_SUFFIX).append(ENTERPRISE_API_V3_SUFFIX);
        }
        String string = builder.toString();
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String toGraphQLUrl() {
        StringBuilder builder = new StringBuilder(this.getSchemaUrlPart());
        if (this.isGithubDotCom()) {
            builder.append(API_PREFIX).append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(GRAPHQL_SUFFIX);
        } else {
            builder.append(this.myHost).append(this.getPortUrlPart()).append(StringUtil.notNullize((String)this.mySuffix)).append(API_SUFFIX).append(GRAPHQL_SUFFIX);
        }
        String string = builder.toString();
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isGithubDotCom() {
        return this.myHost.equalsIgnoreCase(DEFAULT_HOST);
    }

    @NlsSafe
    @NotNull
    public String toString() {
        String schema = this.myUseHttp != null ? this.getSchemaUrlPart() : "";
        String string = schema + this.myHost + this.getPortUrlPart() + StringUtil.notNullize((String)this.mySuffix);
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String getPortUrlPart() {
        return this.myPort != null ? ":" + this.myPort.toString() : "";
    }

    @NotNull
    private String getSchemaUrlPart() {
        String string = this.getSchema() + "://";
        if (string == null) {
            GithubServerPath.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean ignoreProtocol) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubServerPath)) {
            return false;
        }
        GithubServerPath path = (GithubServerPath)o;
        return (ignoreProtocol || Objects.equals(this.myUseHttp, path.myUseHttp)) && Objects.equals(this.myHost, path.myHost) && Objects.equals(this.myPort, path.myPort) && Objects.equals(this.mySuffix, path.mySuffix);
    }

    public int hashCode() {
        return Objects.hash(this.myHost, this.myPort, this.mySuffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/GithubServerPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemoteUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/GithubServerPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toApiUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toGraphQLUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaUrlPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

