/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.collaboration.auth.AccountManager;
import com.intellij.collaboration.auth.PersistentDefaultAccountHolder;
import com.intellij.collaboration.auth.ui.AccountsDetailsProvider;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.auth.ui.AccountsPanelFactory;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsDetailsProvider;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsHost;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsListModel;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubSettingsConfigurable;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.vcs.github"})
public final class GithubSettingsConfigurable
extends BoundConfigurable {
    private final Project project;

    @NotNull
    public DialogPanel createPanel() {
        ProgressIndicatorsProvider progressIndicatorsProvider;
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        GithubProjectDefaultAccountHolder defaultAccountHolder = (GithubProjectDefaultAccountHolder)((Object)object);
        $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)object2);
        GithubSettings settings = GithubSettings.getInstance();
        ProgressIndicatorsProvider it = progressIndicatorsProvider = new ProgressIndicatorsProvider();
        boolean bl = false;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)it));
        ProgressIndicatorsProvider indicatorsProvider = progressIndicatorsProvider;
        GHAccountsListModel accountsModel = new GHAccountsListModel(this.project);
        GHAccountsDetailsProvider detailsProvider = new GHAccountsDetailsProvider(indicatorsProvider, accountManager, accountsModel);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, accountManager, defaultAccountHolder, accountsModel, detailsProvider, settings){
            final /* synthetic */ GithubSettingsConfigurable this$0;
            final /* synthetic */ GHAccountManager $accountManager;
            final /* synthetic */ GithubProjectDefaultAccountHolder $defaultAccountHolder;
            final /* synthetic */ GHAccountsListModel $accountsModel;
            final /* synthetic */ GHAccountsDetailsProvider $detailsProvider;
            final /* synthetic */ GithubSettings $settings;

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$receiver");
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Cell cell2;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        AccountManager accountManager = (AccountManager)this.this$0.$accountManager;
                        PersistentDefaultAccountHolder persistentDefaultAccountHolder = this.this$0.$defaultAccountHolder;
                        AccountsListModel.WithDefault withDefault = this.this$0.$accountsModel;
                        AccountsDetailsProvider accountsDetailsProvider = (AccountsDetailsProvider)this.this$0.$detailsProvider;
                        Disposable disposable = GithubSettingsConfigurable.access$getDisposable$p(this.this$0.this$0);
                        Intrinsics.checkNotNull((Object)disposable);
                        Icon icon = GithubIcons.DefaultAvatar;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.DefaultAvatar");
                        Cell it = cell2 = AccountsPanelFactory.INSTANCE.accountsPanel($this$row, accountManager, persistentDefaultAccountHolder, withDefault, accountsDetailsProvider, disposable, true, icon).horizontalAlign(HorizontalAlign.FILL).verticalAlign(VerticalAlign.FILL);
                        boolean bl = false;
                        DataManager.registerDataProvider((JComponent)it.getComponent(), (DataProvider)new DataProvider(this){
                            final /* synthetic */ createPanel.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            @Nullable
                            public final Object getData(@NotNull String key) {
                                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                                return GHAccountsHost.Companion.getKEY().is(key) ? this.this$0.this$0.$accountsModel : null;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null).resizableRow();
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        String string = GithubBundle.message("settings.clone.ssh", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"settings.clone.ssh\")");
                        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>(this.this$0.$settings){

                            public final boolean invoke() {
                                return ((GithubSettings)this.receiver).isCloneGitUsingSsh();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.this$0.$settings){

                            public final void invoke(boolean p1) {
                                ((GithubSettings)this.receiver).setCloneGitUsingSsh(p1);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
                String string = GithubBundle.message("settings.timeout", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"settings.timeout\")");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        int n = 0;
                        TextFieldKt.bindIntText((Cell)TextFieldKt.columns((Cell)Row.DefaultImpls.intTextField$default((Row)$this$row, (IntRange)new IntRange(n, 60), null, (int)2, null), (int)2), (Function0)((Function0)new Function0<Integer>(this){
                            final /* synthetic */ createPanel.3 this$0;

                            public final int invoke() {
                                GithubSettings githubSettings = this.this$0.this$0.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"settings");
                                return githubSettings.getConnectionTimeout() / 1000;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }), (Function1)((Function1)new Function1<Integer, Unit>(this){
                            final /* synthetic */ createPanel.3 this$0;

                            public final void invoke(int it) {
                                GithubSettings githubSettings = this.this$0.this$0.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"settings");
                                githubSettings.setConnectionTimeout(it * 1000);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })).gap(RightGap.SMALL);
                        String string = GithubBundle.message("settings.timeout.seconds", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"settings.timeout.seconds\")");
                        $this$row.label(string);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = githubSettingsConfigurable;
                this.$accountManager = gHAccountManager;
                this.$defaultAccountHolder = githubProjectDefaultAccountHolder;
                this.$accountsModel = gHAccountsListModel;
                this.$detailsProvider = gHAccountsDetailsProvider;
                this.$settings = githubSettings;
                super(1);
            }
        }));
    }

    public GithubSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super("GitHub", "settings.github");
        this.project = project;
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(GithubSettingsConfigurable $this) {
        return $this.getDisposable();
    }
}

