/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging2;

import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u001a\u001b\u0010\u000b\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u001a\u001b\u0010\f\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u001a7\u0010\r\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0002\u0010\u0011\u001a-\u0010\u0012\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u00022\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\u001a\u001b\u0010\u0018\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u00a8\u0006\u0019"}, d2={"getClassForLogging", "Ljava/lang/Class;", "T", "", "javaClass", "cdebug", "", "Lorg/jitsi/utils/logging2/Logger;", "msg", "Lkotlin/Function0;", "", "cerror", "cinfo", "createChildLogger", "parentLogger", "childContext", "", "(Ljava/lang/Object;Lorg/jitsi/utils/logging2/Logger;Ljava/util/Map;)Lorg/jitsi/utils/logging2/Logger;", "createLogger", "minLogLevel", "Ljava/util/logging/Level;", "logContext", "Lorg/jitsi/utils/logging2/LogContext;", "(Ljava/lang/Object;Ljava/util/logging/Level;Lorg/jitsi/utils/logging2/LogContext;)Lorg/jitsi/utils/logging2/Logger;", "cwarn", "jitsi-utils"})
public final class LoggerExtensionsKt {
    @NotNull
    public static final <T> Logger createLogger(@NotNull T $this$createLogger, @NotNull Level minLogLevel, @NotNull LogContext logContext) {
        Intrinsics.checkParameterIsNotNull($this$createLogger, (String)"$this$createLogger");
        Intrinsics.checkParameterIsNotNull((Object)minLogLevel, (String)"minLogLevel");
        Intrinsics.checkParameterIsNotNull((Object)logContext, (String)"logContext");
        return new LoggerImpl(LoggerExtensionsKt.getClassForLogging($this$createLogger.getClass()).getName(), minLogLevel, logContext);
    }

    public static /* synthetic */ Logger createLogger$default(Object object, Level level, LogContext logContext, int n, Object object2) {
        if ((n & 1) != 0) {
            Level level2 = Level.ALL;
            Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.ALL");
            level = level2;
        }
        if ((n & 2) != 0) {
            LogContext logContext2 = LogContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)logContext2, (String)"LogContext.EMPTY");
            logContext = logContext2;
        }
        return LoggerExtensionsKt.createLogger(object, level, logContext);
    }

    @NotNull
    public static final <T> Logger createChildLogger(@NotNull T $this$createChildLogger, @NotNull Logger parentLogger, @NotNull Map<String, String> childContext) {
        Intrinsics.checkParameterIsNotNull($this$createChildLogger, (String)"$this$createChildLogger");
        Intrinsics.checkParameterIsNotNull((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkParameterIsNotNull(childContext, (String)"childContext");
        Logger logger = parentLogger.createChildLogger(LoggerExtensionsKt.getClassForLogging($this$createChildLogger.getClass()).getName(), childContext);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"parentLogger.createChild\u2026lass).name, childContext)");
        return logger;
    }

    public static /* synthetic */ Logger createChildLogger$default(Object object, Logger logger, Map map, int n, Object object2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return LoggerExtensionsKt.createChildLogger(object, logger, map);
    }

    @NotNull
    public static final <T> Class<?> getClassForLogging(@NotNull Class<T> javaClass) {
        Class<Object> clazz;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull(javaClass, (String)"javaClass");
                clazz = javaClass.getEnclosingClass();
                if (clazz == null) break block2;
                Class<?> clazz2 = clazz;
                boolean bl = false;
                boolean bl2 = false;
                Class<?> it = clazz2;
                boolean bl3 = false;
                KClass kClass = KClasses.getCompanionObject((KClass)JvmClassMappingKt.getKotlinClass(it));
                clazz = Intrinsics.areEqual((Object)(kClass != null ? JvmClassMappingKt.getJavaClass((KClass)kClass) : null), javaClass) ? clazz2 : null;
                if (clazz != null) break block3;
            }
            clazz = javaClass;
        }
        return clazz;
    }

    public static final void cinfo(@NotNull Logger $this$cinfo, @NotNull Function0<String> msg) {
        int $i$f$cinfo = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$cinfo, (String)"$this$cinfo");
        Intrinsics.checkParameterIsNotNull(msg, (String)"msg");
        if ($this$cinfo.isInfoEnabled()) {
            $this$cinfo.info(msg.invoke());
        }
    }

    public static final void cdebug(@NotNull Logger $this$cdebug, @NotNull Function0<String> msg) {
        int $i$f$cdebug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$cdebug, (String)"$this$cdebug");
        Intrinsics.checkParameterIsNotNull(msg, (String)"msg");
        if ($this$cdebug.isDebugEnabled()) {
            $this$cdebug.debug(msg.invoke());
        }
    }

    public static final void cwarn(@NotNull Logger $this$cwarn, @NotNull Function0<String> msg) {
        int $i$f$cwarn = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$cwarn, (String)"$this$cwarn");
        Intrinsics.checkParameterIsNotNull(msg, (String)"msg");
        if ($this$cwarn.isWarnEnabled()) {
            $this$cwarn.warn(msg.invoke());
        }
    }

    public static final void cerror(@NotNull Logger $this$cerror, @NotNull Function0<String> msg) {
        int $i$f$cerror = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$cerror, (String)"$this$cerror");
        Intrinsics.checkParameterIsNotNull(msg, (String)"msg");
        $this$cerror.error(msg.invoke());
    }
}

