/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyRangeTypeCheckInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyRangeTypeCheckInspection.$$$reportNull$$$0(0);
        }
        GrRangeExpression range = (GrRangeExpression)location;
        PsiType type2 = range.getType();
        final ArrayList<GroovyFix> fixes = new ArrayList<GroovyFix>(3);
        if (type2 instanceof GrRangeType) {
            PsiType iterationType = ((GrRangeType)type2).getIterationType();
            if (!(iterationType instanceof PsiClassType)) {
                return null;
            }
            final PsiClass psiClass = ((PsiClassType)iterationType).resolve();
            if (!(psiClass instanceof GrTypeDefinition)) {
                return null;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] compareTos = ResolveUtil.getMethodCandidates(iterationType, "compareTo", (PsiElement)range, iterationType);
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, nexts) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddMethodFix("next", (GrTypeDefinition)psiClass));
            }
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, previouses) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddMethodFix("previous", (GrTypeDefinition)psiClass));
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable") || GroovyRangeTypeCheckInspection.countImplementations(psiClass, compareTos) == 0) {
                fixes.add(GroovyQuickFixFactory.getInstance().createAddClassToExtendsFix((GrTypeDefinition)psiClass, "java.lang.Comparable"));
            }
            return new GroovyFix(){

                @Override
                protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (GroovyFix fix : fixes) {
                        fix.applyFix(project, descriptor);
                    }
                }

                @NotNull
                public String getName() {
                    String string = GroovyBundle.message("fix.class", psiClass.getName());
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                @Nls
                @NotNull
                public String getFamilyName() {
                    String string = GroovyBundle.message("intention.family.name.fix.range.class", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "doFix";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return null;
    }

    private static int countImplementations(PsiClass clazz, GroovyResolveResult[] methods) {
        if (clazz.isInterface()) {
            return methods.length;
        }
        int result2 = 0;
        for (GroovyResolveResult method : methods) {
            PsiElement el = method.getElement();
            if (el instanceof PsiMethod && !((PsiMethod)el).hasModifierProperty("abstract")) {
                ++result2;
                continue;
            }
            if (!(el instanceof PsiField)) continue;
            ++result2;
        }
        return result2;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        switch (args.length) {
            case 1: {
                return GroovyBundle.message("type.doesnt.implement.comparable", args);
            }
            case 2: {
                return GroovyBundle.message("type.doesnt.contain.method", args);
            }
        }
        throw new IncorrectOperationException("incorrect args:" + Arrays.toString(args));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection", "buildFix"));
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        @NlsSafe
        private static final String CALL_NEXT = "next()";
        @NlsSafe
        private static final String CALL_PREVIOUS = "previous()";

        private MyVisitor() {
        }

        @Override
        public void visitRangeExpression(@NotNull GrRangeExpression range) {
            if (range == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super.visitRangeExpression(range);
            PsiType type2 = range.getType();
            if (!(type2 instanceof GrRangeType)) {
                return;
            }
            PsiType iterationType = ((GrRangeType)type2).getIterationType();
            if (iterationType == null) {
                return;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, PsiType.EMPTY_ARRAY);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, PsiType.EMPTY_ARRAY);
            if (nexts.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), CALL_NEXT);
            }
            if (previouses.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), CALL_PREVIOUS);
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable")) {
                this.registerError((PsiElement)range, iterationType.getPresentableText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$MyVisitor", "visitRangeExpression"));
        }
    }
}

