/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyEmptyStatementBodyInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrIfStatement) {
            return GroovyBundle.message("inspection.message.ref.statement.has.empty.branch", new Object[0]);
        }
        return GroovyBundle.message("inspection.message.ref.statement.has.empty.body", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitForStatement(@NotNull GrForStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitForStatement(statement);
            GrStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!Visitor.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && Visitor.isEmpty(thenBranch)) {
                this.registerStatementError(statement, statement);
                return;
            }
            GrStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && Visitor.isEmpty(elseBranch)) {
                this.registerStatementError(statement, statement);
            }
        }

        private static boolean isEmpty(GroovyPsiElement body) {
            if (!(body instanceof GrBlockStatement)) {
                return false;
            }
            GrBlockStatement block = (GrBlockStatement)body;
            GrOpenBlock openBlock = block.getBlock();
            PsiElement brace = openBlock.getLBrace();
            if (brace == null) {
                return false;
            }
            PsiElement nextNonWhitespace = PsiUtil.skipWhitespaces(brace.getNextSibling(), true);
            return nextNonWhitespace == openBlock.getRBrace();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyEmptyStatementBodyInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

