/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class RemoveUnusedGrParameterFix
implements IntentionAction {
    private final String myName;

    public RemoveUnusedGrParameterFix(GrParameter parameter) {
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("remove.parameter.0", this.myName);
        if (string == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("remove.unused.parameter", new Object[0]);
        if (string == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement at;
        GrParameter parameter;
        if (project == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(2);
        }
        return (parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)(at = file.findElementAt(editor.getCaretModel().getOffset())), GrParameter.class)) != null && this.myName.equals(parameter.getName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement at;
        GrParameter parameter;
        if (project == null) {
            RemoveUnusedGrParameterFix.$$$reportNull$$$0(3);
        }
        if ((parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)(at = file.findElementAt(editor.getCaretModel().getOffset())), GrParameter.class)) == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parameter.getContainingFile())) {
            return;
        }
        GrMethod method = (GrMethod)parameter.getDeclarationScope();
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(parameter.getProject(), RemoveUnusedGrParameterFix.createChangeInfo(method, parameter));
        processor.run();
    }

    private static GrChangeInfoImpl createChangeInfo(GrMethod method, GrParameter parameter) {
        ArrayList<GrParameterInfo> params = new ArrayList<GrParameterInfo>();
        int i = 0;
        for (GrParameter p : method.getParameterList().getParameters()) {
            if (p != parameter) {
                params.add(new GrParameterInfo(p, i));
            }
            ++i;
        }
        GrTypeElement typeElement = method.getReturnTypeElementGroovy();
        CanonicalTypes.Type wrapper = typeElement != null ? CanonicalTypes.createTypeWrapper((PsiType)method.getReturnType()) : null;
        return new GrChangeInfoImpl(method, null, wrapper, method.getName(), params, null, false);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

