/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter$WhenMappings;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ParameterCastFix;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.ApplicabilityResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ErasedArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0014J*\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00182\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0015J\b\u0010%\u001a\u00020&H\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0004J(\u0010,\u001a\u00020(2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020-0\u001c2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0014J(\u0010.\u001a\u00020&2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u001aj\u0002`$H\u0002J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u00020&H\u0004J\b\u00101\u001a\u00020(H\u0014R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "getReference", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "getSink", "()Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "buildCastFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ExpressionArgument;", "expectedType", "Lcom/intellij/psi/PsiType;", "buildCastFixes", "", "results", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "result", "buildFixes", "getInapplicableMethodMessage", "containingType", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlightAmbiguousMethod", "", "highlightApplicable", "", "highlightCannotApplyError", "invokedText", "typesString", "highlightClosureInvocation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "highlightInapplicableMethod", "highlightMethodApplicability", "highlightUnknownArgs", "shouldHighlightInapplicable", "intellij.groovy.psi"})
public abstract class CallReferenceHighlighter {
    @NotNull
    private final GroovyCallReference reference;
    @NotNull
    private final HighlightSink sink;

    @NotNull
    protected String getAmbiguousMethodMessage() {
        String string = GroovyBundle.message("method.call.is.ambiguous", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"method.call.is.ambiguous\")");
        return string;
    }

    @Nls
    @NotNull
    protected String getInapplicableMethodMessage(@NotNull GroovyMethodResult result2, @NotNull PsiType containingType, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)containingType, (String)"containingType");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        String string = containingType.getInternalCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingType.internalCanonicalText");
        String typeText = string;
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        Object[] objectArray = new Object[3];
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"result.element");
        objectArray[0] = psiMethod.getName();
        objectArray[1] = typeText;
        objectArray[2] = argumentsString2;
        String string2 = GroovyBundle.message("cannot.apply.method1", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GroovyBundle.message(\"ca\u2026ypeText, argumentsString)");
        return string2;
    }

    @NotNull
    protected abstract PsiElement getHighlightElement();

    protected final void highlightCannotApplyError(@NotNull String invokedText, @NotNull String typesString) {
        Intrinsics.checkNotNullParameter((Object)invokedText, (String)"invokedText");
        Intrinsics.checkNotNullParameter((Object)typesString, (String)"typesString");
        this.sink.registerError(this.getHighlightElement(), GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString), new LocalQuickFix[0]);
    }

    protected final void highlightUnknownArgs() {
        this.sink.registerProblem(this.getHighlightElement(), ProblemHighlightType.WEAK_WARNING, GroovyBundle.message("cannot.infer.argument.types", new Object[0]), new LocalQuickFix[0]);
    }

    protected final void highlightAmbiguousMethod() {
        this.sink.registerError(this.getHighlightElement(), this.getAmbiguousMethodMessage(), new LocalQuickFix[0]);
    }

    private final void highlightInapplicableMethod(Collection<? extends GroovyMethodResult> results, List<? extends Argument> arguments2) {
        PsiClass psiClass;
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)CollectionsKt.firstOrNull((Iterable)results);
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"result.element");
        PsiMethod method = psiMethod;
        if (method instanceof GrGdkMethod) {
            PsiMethod psiMethod2 = ((GrGdkMethod)method).getStaticMethod();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"method.staticMethod");
            psiClass = psiMethod2.getContainingClass();
        } else {
            psiClass = method.getContainingClass();
        }
        PsiClass containingClass = psiClass;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        PsiElement highlightElement = this.getHighlightElement();
        String argumentsString2 = HighlightingKt.argumentsString(arguments2);
        if (containingClass == null) {
            this.highlightCannotApplyError(methodName, argumentsString2);
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiClassType psiClassType = factory.createType(containingClass, result2.getSubstitutor());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"factory.createType(conta\u2026lass, result.substitutor)");
        PsiClassType containingType = psiClassType;
        Collection collection = CollectionsKt.plus((Collection)this.buildCastFixes(results), (Iterable)this.buildFixes());
        Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"LocalQuickFix.EMPTY_ARRAY");
        LocalQuickFix[] fixes = (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
        String message = this.getInapplicableMethodMessage(result2, (PsiType)containingType, arguments2);
        this.sink.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, Arrays.copyOf(fixes, fixes.length));
    }

    protected boolean shouldHighlightInapplicable() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean highlightMethodApplicability() {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            CallReferenceHighlighter callReferenceHighlighter;
            CallReferenceHighlighter $this$run = callReferenceHighlighter = this;
            boolean bl = false;
            $this$run.highlightUnknownArgs();
            return true;
        }
        List<Argument> userArguments = list;
        Collection<? extends GroovyResolveResult> collection2 = this.reference.resolve(false);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"reference.resolve(false)");
        Collection<? extends GroovyResolveResult> results = collection2;
        if (results.isEmpty()) {
            return false;
        }
        Iterable bl = results;
        boolean $i$f$filterIsInstance = false;
        void var6_10 = $this$filterIsInstance$iv;
        Collection collection3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GroovyMethodResult)) continue;
            collection3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)collection3;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        Collection collection4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroovyMethodResult it = (GroovyMethodResult)element$iv$iv;
            boolean bl2 = false;
            if (!(!it.isInvokedOnProperty())) continue;
            collection4.add(element$iv$iv);
        }
        List methodResults = (List)collection4;
        if (methodResults.isEmpty()) {
            return this.highlightClosureInvocation(results, userArguments);
        }
        Iterable $this$mapNotNull$iv = methodResults;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean bl3 = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator bl2 = $this$forEach$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            Pair pair;
            Pair pair2;
            Pair pair3;
            Object t;
            Object element$iv$iv = t = bl2.next();
            boolean bl4 = false;
            GroovyMethodResult result2 = (GroovyMethodResult)element$iv$iv;
            boolean bl5 = false;
            Object object = result2.getCandidate();
            if (object != null && (object = object.getArgumentMapping()) != null) {
                Object object2;
                Object mapping2 = object2 = object;
                boolean bl6 = false;
                PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"result.substitutor");
                pair3 = new Pair((Object)result2, (Object)mapping2.highlightingApplicabilities(psiSubstitutor));
            } else {
                pair3 = pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair = pair2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resultApplicabilities = (List)destination$iv$iv;
        Iterable $this$map$iv = resultApplicabilities;
        boolean bl8 = false;
        destination$iv$iv = $this$map$iv;
        Collection collection5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = collection5;
            boolean bl9 = false;
            Applicability applicability = ((ApplicabilityResult)pair.getSecond()).getApplicability();
            collection.add(applicability);
        }
        Applicability applicability = Applicability.totalApplicability((List)collection5);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicability), (String)"totalApplicability(resul\u2026cond.applicability\n    })");
        Applicability totalApplicability = applicability;
        switch (CallReferenceHighlighter$WhenMappings.$EnumSwitchMapping$0[totalApplicability.ordinal()]) {
            case 1: {
                void $this$mapNotNullTo$iv$iv;
                if (!this.shouldHighlightInapplicable()) {
                    return false;
                }
                GroovyMethodResult singleResult = (GroovyMethodResult)CollectionsKt.singleOrNull((List)methodResults);
                if (singleResult != null) {
                    Iterable iterable2 = userArguments;
                    boolean $i$f$map = false;
                    Iterable iterable3 = iterable2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object e : iterable3) {
                        void p1;
                        Argument bl9 = (Argument)e;
                        collection = destination$iv$iv2;
                        boolean bl10 = false;
                        ErasedArgument erasedArgument = new ErasedArgument((Argument)p1);
                        collection.add(erasedArgument);
                    }
                    if (GroovyApplicabilityProvider.checkProviders((List)destination$iv$iv2, singleResult.getElement()) == Applicability.applicable) {
                        return false;
                    }
                }
                Iterable $this$mapNotNull$iv2 = resultApplicabilities;
                boolean bl11 = false;
                Iterable destination$iv$iv2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void var13_52 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = var13_52.iterator();
                while (iterator2.hasNext()) {
                    GroovyMethodResult groovyMethodResult;
                    GroovyMethodResult groovyMethodResult2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl12 = false;
                    Pair $dstr$result$applicabilityResult = (Pair)element$iv$iv;
                    boolean bl13 = false;
                    GroovyMethodResult groovyMethodResult3 = (GroovyMethodResult)$dstr$result$applicabilityResult.component1();
                    ApplicabilityResult applicabilityResult = (ApplicabilityResult)$dstr$result$applicabilityResult.component2();
                    GroovyMethodResult groovyMethodResult4 = groovyMethodResult2 = applicabilityResult.getApplicability() == Applicability.inapplicable ? groovyMethodResult3 : null;
                    if (groovyMethodResult2 == null) continue;
                    GroovyMethodResult it$iv$iv = groovyMethodResult = groovyMethodResult2;
                    boolean bl14 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Collection collection6 = (List)destination$iv$iv3;
                this.highlightInapplicableMethod(collection6, userArguments);
                return true;
            }
            case 2: {
                if (methodResults.size() != 1) {
                    Argument it;
                    Iterable $this$any$iv = userArguments;
                    boolean bl15 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator3 = $this$any$iv.iterator();
                    do {
                        if (!iterator3.hasNext()) return false;
                        Object t = iterator3.next();
                        it = (Argument)t;
                        boolean bl16 = false;
                    } while (!(it.getType() == null));
                    boolean bl17 = true;
                    if (!bl17) return false;
                }
                this.highlightUnknownArgs();
                return true;
            }
            case 3: {
                if (resultApplicabilities.size() <= 1) return this.highlightApplicable((GroovyMethodResult)((Pair)CollectionsKt.single((List)resultApplicabilities)).getFirst());
                this.highlightAmbiguousMethod();
                return true;
            }
        }
        return false;
    }

    protected boolean highlightClosureInvocation(@NotNull Collection<? extends GroovyResolveResult> results, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        return false;
    }

    protected boolean highlightApplicable(@NotNull GroovyMethodResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(Collection<? extends GroovyMethodResult> results) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = results;
        CallReferenceHighlighter callReferenceHighlighter = this;
        boolean $i$f$flatMap = false;
        void var5_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GroovyMethodResult p1 = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = callReferenceHighlighter.buildCastFixes(p1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(GroovyMethodResult result2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        void $this$filterTo$iv$iv;
        ArgumentMapping<PsiCallParameter> argumentMapping2;
        ArgumentMapping<PsiCallParameter> mapping2;
        block9: {
            block8: {
                GroovyMethodCandidate groovyMethodCandidate = result2.getCandidate();
                if (groovyMethodCandidate == null) {
                    return CollectionsKt.emptyList();
                }
                Intrinsics.checkNotNullExpressionValue((Object)groovyMethodCandidate, (String)"result.candidate ?: return emptyList()");
                GroovyMethodCandidate candidate = groovyMethodCandidate;
                ArgumentMapping<PsiCallParameter> argumentMapping3 = candidate.getArgumentMapping();
                if (argumentMapping3 == null) {
                    return CollectionsKt.emptyList();
                }
                mapping2 = argumentMapping3;
                argumentMapping2 = candidate.getArgumentMapping();
                if (argumentMapping2 == null) break block8;
                PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"result.substitutor");
                if ((argumentMapping2 = argumentMapping2.highlightingApplicabilities(psiSubstitutor)) != null) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ArgumentMapping<PsiCallParameter> applicabilities = argumentMapping2;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> $this$filter$iv = applicabilities.getArgumentApplicabilities();
        boolean $i$f$filter = false;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            Map.Entry $dstr$_u24__u24$data = element$iv$iv;
            boolean bl = false;
            object = $dstr$_u24__u24$data;
            ApplicabilityResult.ArgumentApplicability data = (ApplicabilityResult.ArgumentApplicability)object.getValue();
            if (!(data.getApplicability() == Applicability.inapplicable)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set notApplicableArguments = destination$iv$iv.keySet();
        PsiElement psiElement = this.reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reference.element");
        PsiElement callElement = psiElement;
        PsiSubstitutor substitutor2 = GroovyInferenceSessionBuilderKt.buildTopLevelSession(callElement, false, SetsKt.setOf((Object)new Function1<GrExpression, Boolean>(notApplicableArguments){
            final /* synthetic */ Set $notApplicableArguments;

            public final boolean invoke(@NotNull GrExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$notApplicableArguments.contains(new ExpressionArgument(it));
            }
            {
                this.$notApplicableArguments = set;
                super(1);
            }
        })).inferSubst();
        Iterable $this$filterIsInstance$iv = notApplicableArguments;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$filterTo22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExpressionArgument)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            LocalQuickFix localQuickFix;
            LocalQuickFix localQuickFix2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            ExpressionArgument argument = (ExpressionArgument)element$iv$iv;
            boolean bl2 = false;
            PsiType fixType = substitutor2.substitute(mapping2.expectedType(argument));
            LocalQuickFix localQuickFix3 = localQuickFix2 = fixType != null ? this.buildCastFix(argument, fixType) : null;
            if (localQuickFix2 == null) continue;
            LocalQuickFix it$iv$iv = localQuickFix = localQuickFix2;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Nullable
    protected LocalQuickFix buildCastFix(@NotNull ExpressionArgument argument, @NotNull PsiType expectedType) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        int position = arguments2.indexOf(argument);
        if (position < 0) {
            return null;
        }
        return new ParameterCastFix(argument.getExpression(), position, expectedType);
    }

    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected final GroovyCallReference getReference() {
        return this.reference;
    }

    @NotNull
    protected final HighlightSink getSink() {
        return this.sink;
    }

    public CallReferenceHighlighter(@NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.reference = reference;
        this.sink = sink;
    }
}

