/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.jarFinder;

import com.intellij.jarFinder.FindJarFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyFindJarFix
extends FindJarFix<GrReferenceElement> {
    public GroovyFindJarFix(GrReferenceElement ref) {
        super((PsiElement)ref);
    }

    protected Collection<String> getFqns(@NotNull GrReferenceElement ref) {
        GrImportStatement[] importList;
        GrImportStatement importStatement;
        if (ref == null) {
            GroovyFindJarFix.$$$reportNull$$$0(0);
        }
        if ((importStatement = (GrImportStatement)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), GrImportStatement.class)) != null) {
            String fqn = importStatement.getImportFqn();
            return fqn == null ? Collections.emptyList() : Collections.singleton(fqn);
        }
        if (ref.getQualifier() != null) {
            return Collections.emptyList();
        }
        String className = ref.getReferenceName();
        if (className == null) {
            return Collections.emptyList();
        }
        PsiFile file = ref.getContainingFile().getOriginalFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptyList();
        }
        for (GrImportStatement imp : importList = ((GroovyFile)file).getImportStatements()) {
            if (!className.equals(imp.getImportedName())) continue;
            String fqn = imp.getImportFqn();
            return fqn == null ? Collections.emptyList() : Collections.singleton(fqn);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/jarFinder/GroovyFindJarFix", "getFqns"));
    }
}

