/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class PackageParserUtils {
    public static Revision getRevisionProperty(Properties props, String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        Revision rev = null;
        if (revStr != null) {
            try {
                rev = Revision.parseRevision((String)revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rev;
    }

    public static String getProperty(Properties props, String propKey, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    public static List<Path> parseSkinFolder(Path skinRootFolder) {
        if (CancellableFileIo.isDirectory((Path)skinRootFolder, (LinkOption[])new LinkOption[0])) {
            try {
                return CancellableFileIo.list((Path)skinRootFolder).filter(x$0 -> CancellableFileIo.isDirectory((Path)x$0, (LinkOption[])new LinkOption[0])).filter(dir -> CancellableFileIo.isRegularFile((Path)dir.resolve("layout"), (LinkOption[])new LinkOption[0])).sorted().collect(Collectors.toList());
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

