/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0003J$\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00032\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0%H\u0002J\b\u0010&\u001a\u00020#H\u0016J\u0011\u0010'\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0003J\b\u0010*\u001a\u00020\u0003H\u0016J \u0010+\u001a\u00020\u0016*\u00020,2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0-H\u0002J6\u0010.\u001a\u00020\u0016*\u00020,2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0%2\u0006\u00100\u001a\u00020\u001dH\u0002J.\u00101\u001a\u00020\u0016*\u00020,2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0%H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\fj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0018\u0010\u0010\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "", "packageFqName", "", "(Ljava/lang/String;)V", "metadataParts", "", "getMetadataParts", "()Ljava/util/Set;", "getPackageFqName", "()Ljava/lang/String;", "packageParts", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "parts", "getParts", "className", "getClassName", "(Ljava/lang/String;)Ljava/lang/String;", "packageName", "getPackageName", "addMetadataPart", "", "shortName", "addPart", "partInternalName", "facadeInternalName", "addTo", "builder", "Lorg/jetbrains/kotlin/metadata/jvm/JvmModuleProtoBuf$Module$Builder;", "equals", "", "other", "getMultifileFacadeName", "getMultifileFacadeShortNameId", "", "facadeNameToId", "", "hashCode", "plusAssign", "removePart", "internalName", "toString", "writeMultifileFacadeNames", "Lorg/jetbrains/kotlin/metadata/jvm/JvmModuleProtoBuf$PackageParts$Builder;", "", "writePartsOutsidePackage", "", "packageTableBuilder", "writePartsWithinPackage", "metadata.jvm"})
public final class PackageParts {
    @NotNull
    private final String packageFqName;
    @NotNull
    private final LinkedHashMap<String, String> packageParts;
    @NotNull
    private final Set<String> metadataParts;

    public PackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        this.packageFqName = packageFqName;
        this.packageParts = new LinkedHashMap();
        this.metadataParts = new LinkedHashSet();
    }

    @NotNull
    public final String getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final Set<String> getParts() {
        Set<String> set = this.packageParts.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"packageParts.keys");
        return set;
    }

    @NotNull
    public final Set<String> getMetadataParts() {
        return this.metadataParts;
    }

    public final void addPart(@NotNull String partInternalName, @Nullable String facadeInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        ((Map)this.packageParts).put(partInternalName, facadeInternalName);
    }

    public final void removePart(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        this.packageParts.remove(internalName);
    }

    public final void addMetadataPart(@NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        TypeIntrinsics.asMutableSet(this.metadataParts).add(shortName);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTo(@NotNull JvmModuleProtoBuf.Module.Builder builder) {
        JvmModuleProtoBuf.PackageParts.Builder $this$addTo_u24lambda_u2d1;
        JvmModuleProtoBuf.Module.Builder builder2;
        JvmModuleProtoBuf.PackageParts.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!((Collection)this.getParts()).isEmpty()) {
            JvmModuleProtoBuf.PackageParts.Builder builder4 = builder3 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            boolean bl = false;
            $this$addTo_u24lambda_u2d1.setPackageFqName(this.packageFqName);
            String string2 = $this$addTo_u24lambda_u2d1.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqName");
            String packageInternalName = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
            Iterable $this$partition$iv = this.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String partInternalName = (String)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)this.getPackageName(partInternalName), (Object)packageInternalName)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List partsWithinPackage = (List)pair.component1();
            List partsOutsidePackage = (List)pair.component2();
            Map facadeNameToId = new LinkedHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)$this$addTo_u24lambda_u2d1, (String)"");
            this.writePartsWithinPackage($this$addTo_u24lambda_u2d1, partsWithinPackage, facadeNameToId);
            this.writePartsOutsidePackage($this$addTo_u24lambda_u2d1, partsOutsidePackage, facadeNameToId, builder);
            this.writeMultifileFacadeNames($this$addTo_u24lambda_u2d1, facadeNameToId);
            builder2.addPackageParts(builder3);
        }
        if (!((Collection)this.metadataParts).isEmpty()) {
            void $this$addTo_u24lambda_u2d2;
            $this$addTo_u24lambda_u2d1 = builder3 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            boolean bl = false;
            $this$addTo_u24lambda_u2d2.setPackageFqName(this.packageFqName);
            $this$addTo_u24lambda_u2d2.addAllShortClassName(CollectionsKt.sorted((Iterable)this.metadataParts));
            builder2.addMetadataParts(builder3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsWithinPackage(JvmModuleProtoBuf.PackageParts.Builder $this$writePartsWithinPackage, List<String> parts, Map<String, Integer> facadeNameToId) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = parts;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = this.getMultifileFacadeName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv, (Comparator)ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder()))).entrySet()) {
            String facadeInternalName = (String)entry.getKey();
            List partInternalNames = (List)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)partInternalNames, (String)"partInternalNames");
            for (String partInternalName : CollectionsKt.sorted((Iterable)partInternalNames)) {
                $this$writePartsWithinPackage.addShortClassName(this.getClassName(partInternalName));
                if (facadeInternalName == null) continue;
                $this$writePartsWithinPackage.addMultifileFacadeShortNameId(this.getMultifileFacadeShortNameId(facadeInternalName, facadeNameToId));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsOutsidePackage(JvmModuleProtoBuf.PackageParts.Builder $this$writePartsOutsidePackage, List<String> parts, Map<String, Integer> facadeNameToId, JvmModuleProtoBuf.Module.Builder packageTableBuilder) {
        void $this$groupByTo$iv$iv;
        List packageIds = new ArrayList();
        Iterable $this$groupBy$iv = parts;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object entry2 : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)entry2;
            boolean bl = false;
            String key$iv$iv = this.getPackageName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(entry2);
        }
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv)).entrySet()) {
            void $this$groupByTo$iv$iv2;
            String packageInternalName = (String)entry.getKey();
            List partsInPackage = (List)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)packageInternalName, (String)"packageInternalName");
            String packageFqName = StringsKt.replace$default((String)packageInternalName, (char)'/', (char)'.', (boolean)false, (int)4, null);
            if (!packageTableBuilder.getJvmPackageNameList().contains(packageFqName)) {
                packageTableBuilder.addJvmPackageName(packageFqName);
            }
            int packageId = packageTableBuilder.getJvmPackageNameList().indexOf(packageFqName);
            Intrinsics.checkNotNullExpressionValue((Object)partsInPackage, (String)"partsInPackage");
            Iterable iterable2 = partsInPackage;
            boolean $i$f$groupBy2 = false;
            Iterable bl = iterable2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                String key$iv$iv = this.getMultifileFacadeName(it);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry entry2 : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv2, (Comparator)ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder()))).entrySet()) {
                String facadeInternalName = (String)entry2.getKey();
                List partInternalNames = (List)entry2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)partInternalNames, (String)"partInternalNames");
                for (String partInternalName : CollectionsKt.sorted((Iterable)partInternalNames)) {
                    $this$writePartsOutsidePackage.addClassWithJvmPackageNameShortName(this.getClassName(partInternalName));
                    if (facadeInternalName != null) {
                        $this$writePartsOutsidePackage.addClassWithJvmPackageNameMultifileFacadeShortNameId(this.getMultifileFacadeShortNameId(facadeInternalName, facadeNameToId));
                    }
                    packageIds.add(packageId);
                }
            }
        }
        while (packageIds.size() > 1 && ((Number)packageIds.get(packageIds.size() - 1)).intValue() == ((Number)packageIds.get(packageIds.size() - 2)).intValue()) {
            packageIds.remove(packageIds.size() - 1);
        }
        $this$writePartsOutsidePackage.addAllClassWithJvmPackageNamePackageId(packageIds);
    }

    /*
     * WARNING - void declaration
     */
    private final int getMultifileFacadeShortNameId(String facadeInternalName, Map<String, Integer> facadeNameToId) {
        Object object;
        void $this$getOrPut$iv;
        int n = 1;
        Map<String, Integer> map = facadeNameToId;
        String key$iv = this.getClassName(facadeInternalName);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            int n2 = n;
            boolean bl = false;
            Integer n3 = facadeNameToId.size();
            n = n2;
            Integer answer$iv = n3;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return n + ((Number)object).intValue();
    }

    private final void writeMultifileFacadeNames(JvmModuleProtoBuf.PackageParts.Builder $this$writeMultifileFacadeNames, Map<String, Integer> facadeNameToId) {
        Iterable $this$sortedBy$iv = CollectionsKt.zip((Iterable)facadeNameToId.values(), (Iterable)facadeNameToId.keySet());
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair p0 = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Number)p0.getFirst()).intValue());
                p0 = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Number)p0.getFirst()).intValue()));
            }
        })) {
            boolean bl;
            int facadeId = ((Number)pair.component1()).intValue();
            String facadeName = (String)pair.component2();
            boolean bl2 = bl = facadeId == $this$writeMultifileFacadeNames.getMultifileFacadeShortNameCount();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Multifile facades are loaded incorrectly: " + facadeNameToId;
                throw new AssertionError((Object)string2);
            }
            $this$writeMultifileFacadeNames.addMultifileFacadeShortName(facadeName);
        }
    }

    private final String getPackageName(String $this$packageName) {
        return StringsKt.substringBeforeLast((String)$this$packageName, (char)'/', (String)"");
    }

    private final String getClassName(String $this$className) {
        return StringsKt.substringAfterLast$default((String)$this$className, (char)'/', null, (int)2, null);
    }

    @Nullable
    public final String getMultifileFacadeName(@NotNull String partInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        return this.packageParts.get(partInternalName);
    }

    public final void plusAssign(@NotNull PackageParts other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (Map.Entry entry : ((Map)other.packageParts).entrySet()) {
            String partInternalName = (String)entry.getKey();
            String facadeInternalName = (String)entry.getValue();
            this.addPart(partInternalName, facadeInternalName);
        }
        Iterable $this$forEach$iv = other.metadataParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            this.addMetadataPart(p0);
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PackageParts && Intrinsics.areEqual((Object)((PackageParts)other).packageFqName, (Object)this.packageFqName) && Intrinsics.areEqual(((PackageParts)other).packageParts, this.packageParts) && Intrinsics.areEqual(((PackageParts)other).metadataParts, this.metadataParts);
    }

    public int hashCode() {
        return (this.packageFqName.hashCode() * 31 + this.packageParts.hashCode()) * 31 + ((Object)this.metadataParts).hashCode();
    }

    @NotNull
    public String toString() {
        return SetsKt.plus(this.getParts(), (Iterable)this.metadataParts).toString();
    }
}

