/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0003\u0014\u0015\u0016B#\b\u0004\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "K", "V", "Ljava/io/Closeable;", "indexName", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "(Lcom/intellij/util/indexing/ID;I)V", "getChunkId", "()I", "index", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "getIndex", "()Lcom/intellij/util/indexing/UpdatableIndex;", "getIndexName", "()Lcom/intellij/util/indexing/ID;", "close", "", "Companion", "Empty", "Impl", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Impl;", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Empty;", "intellij.indexing.shared"})
@ApiStatus.Internal
public abstract class SharedIndex<K, V>
implements Closeable {
    @NotNull
    private final ID<K, V> indexName;
    private final int chunkId;
    private static final ConcurrentHashMap<Integer, StorageLockContext> sharedIndexLock;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract UpdatableIndex<K, V, FileContent, ?> getIndex();

    @Override
    public void close() {
        this.getIndex().dispose();
    }

    @NotNull
    public final ID<K, V> getIndexName() {
        return this.indexName;
    }

    public final int getChunkId() {
        return this.chunkId;
    }

    private SharedIndex(ID<K, V> indexName, int chunkId) {
        this.indexName = indexName;
        this.chunkId = chunkId;
    }

    static {
        Companion = new Companion(null);
        sharedIndexLock = new ConcurrentHashMap();
    }

    public /* synthetic */ SharedIndex(ID indexName, int chunkId, DefaultConstructorMarker $constructor_marker) {
        this(indexName, chunkId);
    }

    @JvmStatic
    public static final <T> T withReadWriteStorageLock(int chunkId, @NotNull Function0<? extends T> operation) {
        return Companion.withReadWriteStorageLock(chunkId, operation);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Impl;", "K", "V", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "chunkRoot", "Ljava/nio/file/Path;", "indexId", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "originalExtension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "hashIndex", "Lcom/intellij/indexing/shared/platform/impl/FileContentHashIndex;", "chunkVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "(Ljava/nio/file/Path;Lcom/intellij/util/indexing/ID;ILcom/intellij/util/indexing/FileBasedIndexExtension;Lcom/intellij/indexing/shared/platform/impl/FileContentHashIndex;Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;)V", "chunkPath", "index", "Lcom/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex;", "getIndex", "()Lcom/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex;", "intellij.indexing.shared"})
    public static final class Impl<K, V>
    extends SharedIndex<K, V> {
        private final Path chunkPath;
        @NotNull
        private final HashBasedMapReduceIndex<K, V> index;
        private final FileBasedIndexExtension<K, V> originalExtension;
        private final FileContentHashIndex hashIndex;
        private final SharedIndexInfrastructureVersion chunkVersion;

        @NotNull
        public HashBasedMapReduceIndex<K, V> getIndex() {
            return this.index;
        }

        public Impl(@NotNull Path chunkRoot, @NotNull ID<K, V> indexId2, int chunkId, @NotNull FileBasedIndexExtension<K, V> originalExtension, @NotNull FileContentHashIndex hashIndex, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
            Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
            Intrinsics.checkNotNullParameter(indexId2, (String)"indexId");
            Intrinsics.checkNotNullParameter(originalExtension, (String)"originalExtension");
            Intrinsics.checkNotNullParameter((Object)((Object)hashIndex), (String)"hashIndex");
            Intrinsics.checkNotNullParameter((Object)((Object)chunkVersion), (String)"chunkVersion");
            super(indexId2, chunkId, null);
            this.originalExtension = originalExtension;
            this.hashIndex = hashIndex;
            this.chunkVersion = chunkVersion;
            Path path = SharedIndexExtension.getSharedIndexDir(chunkRoot, indexId2);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getSharedIndexDir(chunkRoot, indexId)");
            this.chunkPath = path;
            this.index = (HashBasedMapReduceIndex)((Object)Companion.withReadWriteStorageLock(chunkId, (Function0)new Function0<HashBasedMapReduceIndex<K, V>>(this, chunkId){
                final /* synthetic */ Impl this$0;
                final /* synthetic */ int $chunkId;

                @NotNull
                public final HashBasedMapReduceIndex<K, V> invoke() {
                    return new HashBasedMapReduceIndex<K, V>(Impl.access$getChunkPath$p(this.this$0), SharedIndexExtension.findExtensionAndOpen(Impl.access$getOriginalExtension$p(this.this$0), Impl.access$getChunkPath$p(this.this$0), true, Impl.access$getChunkVersion$p(this.this$0)), Impl.access$getHashIndex$p(this.this$0).getHashIdToFileIdsFunction(this.$chunkId), new LongSupplier(this){
                        final /* synthetic */ index.1 this$0;

                        public final long getAsLong() {
                            return Impl.access$getHashIndex$p(this.this$0.this$0).getModificationStamp();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = impl;
                    this.$chunkId = n;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ Path access$getChunkPath$p(Impl $this) {
            return $this.chunkPath;
        }

        public static final /* synthetic */ FileBasedIndexExtension access$getOriginalExtension$p(Impl $this) {
            return $this.originalExtension;
        }

        public static final /* synthetic */ SharedIndexInfrastructureVersion access$getChunkVersion$p(Impl $this) {
            return $this.chunkVersion;
        }

        public static final /* synthetic */ FileContentHashIndex access$getHashIndex$p(Impl $this) {
            return $this.hashIndex;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR,\u0010\t\u001a\u001a\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Empty;", "K", "V", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "indexName", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "(Lcom/intellij/util/indexing/ID;I)V", "index", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "Lcom/intellij/util/indexing/UpdatableIndex$EmptyData;", "getIndex", "()Lcom/intellij/util/indexing/UpdatableIndex;", "intellij.indexing.shared"})
    public static final class Empty<K, V>
    extends SharedIndex<K, V> {
        @Override
        @NotNull
        public UpdatableIndex<K, V, FileContent, UpdatableIndex.EmptyData> getIndex() {
            EmptyIndex emptyIndex = EmptyIndex.getInstance();
            Intrinsics.checkNotNullExpressionValue(emptyIndex, (String)"EmptyIndex.getInstance()");
            return emptyIndex;
        }

        public Empty(@NotNull ID<K, V> indexName, int chunkId) {
            Intrinsics.checkNotNullParameter(indexName, (String)"indexName");
            super(indexName, chunkId, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0007\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Companion;", "", "()V", "sharedIndexLock", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/io/StorageLockContext;", "withReadWriteStorageLock", "T", "chunkId", "operation", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.indexing.shared"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T withReadWriteStorageLock(int chunkId, @NotNull Function0<? extends T> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            if (PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() != null) {
                throw (Throwable)((Object)new AssertionError((Object)"reentrant storage lock option set-up"));
            }
            try {
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(sharedIndexLock.computeIfAbsent(chunkId, withReadWriteStorageLock.1.INSTANCE));
                Object object = operation.invoke();
                return (T)object;
            }
            finally {
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

