/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.datastore.service.CpuService;
import com.android.tools.datastore.service.EnergyService;
import com.android.tools.datastore.service.EventService;
import com.android.tools.datastore.service.MemoryService;
import com.android.tools.datastore.service.NetworkService;
import com.android.tools.datastore.service.ProfilerService;
import com.android.tools.datastore.service.TransportService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerDbStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStoreService
implements DataStoreTable.DataStoreTableErrorCallback {
    private static final long REPORT_INITIAL_DELAY = TimeUnit.MINUTES.toMillis(15L);
    private static final long REPORT_PERIOD = TimeUnit.HOURS.toMillis(1L);
    public static final long DATASTORE_RESERVED_STREAM_ID = -1L;
    @NotNull
    private final LogService myLogService;
    private final String myDatastoreDirectory;
    private final Map<BackingNamespace, DataStoreDatabase> myDatabases;
    private final ServerBuilder myServerBuilder;
    private final Server myServer;
    private final List<ServicePassThrough> myServices;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private Consumer<Throwable> myNoPiiExceptionHandler;
    private TransportService myTransportService;
    private final ServerInterceptor myInterceptor;
    private final Map<Long, DataStoreClient> myConnectedClients;
    private final Timer myReportTimer;

    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(DataStoreService.class.getCanonicalName());
    }

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        if (serviceName == null) {
            DataStoreService.$$$reportNull$$$0(0);
        }
        if (datastoreDirectory == null) {
            DataStoreService.$$$reportNull$$$0(1);
        }
        if (fetchExecutor == null) {
            DataStoreService.$$$reportNull$$$0(2);
        }
        if (logService == null) {
            DataStoreService.$$$reportNull$$$0(3);
        }
        this(serviceName, datastoreDirectory, fetchExecutor, logService, null);
    }

    @VisibleForTesting
    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService, @Nullable ServerInterceptor interceptor) {
        if (serviceName == null) {
            DataStoreService.$$$reportNull$$$0(4);
        }
        if (datastoreDirectory == null) {
            DataStoreService.$$$reportNull$$$0(5);
        }
        if (fetchExecutor == null) {
            DataStoreService.$$$reportNull$$$0(6);
        }
        if (logService == null) {
            DataStoreService.$$$reportNull$$$0(7);
        }
        this.myDatabases = new HashMap<BackingNamespace, DataStoreDatabase>();
        this.myServices = new ArrayList<ServicePassThrough>();
        this.myConnectedClients = new HashMap<Long, DataStoreClient>();
        this.myLogService = logService;
        this.myFetchExecutor = fetchExecutor;
        this.myInterceptor = interceptor;
        this.myDatastoreDirectory = datastoreDirectory;
        this.myServerBuilder = InProcessServerBuilder.forName((String)serviceName).directExecutor();
        this.setNoPiiExceptionHandler(null);
        this.createPollers();
        this.myServer = this.myServerBuilder.build();
        try {
            this.myServer.start();
        }
        catch (IOException ex) {
            this.getLogger().error(ex.getMessage());
        }
        this.myReportTimer = new Timer("DataStoreReportTimer");
        this.myReportTimer.schedule((TimerTask)new ReportTimerTask(), REPORT_INITIAL_DELAY, REPORT_PERIOD);
        DataStoreTable.addDataStoreErrorCallback(this);
    }

    public void setNoPiiExceptionHandler(@Nullable Consumer<Throwable> noPiiExceptionHandler) {
        this.myNoPiiExceptionHandler = noPiiExceptionHandler == null ? t -> this.getLogger().error((Throwable)t) : noPiiExceptionHandler;
    }

    @VisibleForTesting
    public Map<BackingNamespace, DataStoreDatabase> getDatabases() {
        return this.myDatabases;
    }

    public void createPollers() {
        UnifiedEventsTable unifiedTable = new UnifiedEventsTable();
        this.myTransportService = new TransportService(this, unifiedTable, this.myFetchExecutor, (Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get() == false);
        this.registerService(this.myTransportService);
        this.registerService(new ProfilerService(this, this.myLogService));
        this.registerService(new EventService(this, this.myFetchExecutor));
        this.registerService(new CpuService(this, this.myFetchExecutor, this.myLogService));
        this.registerService(new MemoryService(this, unifiedTable, this.myFetchExecutor, this.myLogService));
        this.registerService(new NetworkService(this, this.myFetchExecutor));
        this.registerService(new EnergyService(this, this.myFetchExecutor, this.myLogService));
    }

    @VisibleForTesting
    @NotNull
    public DataStoreDatabase createDatabase(@NotNull String dbPath, @NotNull DataStoreDatabase.Characteristic characteristic, Consumer<Throwable> noPiiExceptionHandler) {
        if (dbPath == null) {
            DataStoreService.$$$reportNull$$$0(8);
        }
        if (characteristic == null) {
            DataStoreService.$$$reportNull$$$0(9);
        }
        return new DataStoreDatabase(dbPath, characteristic, this.myLogService, noPiiExceptionHandler);
    }

    void registerService(@NotNull ServicePassThrough service) {
        if (service == null) {
            DataStoreService.$$$reportNull$$$0(10);
        }
        this.myServices.add(service);
        List<BackingNamespace> namespaces = service.getBackingNamespaces();
        namespaces.forEach(namespace -> {
            assert (!namespace.myNamespace.isEmpty());
            DataStoreDatabase db = this.myDatabases.computeIfAbsent((BackingNamespace)namespace, backingNamespace -> this.createDatabase(this.myDatastoreDirectory + backingNamespace.myNamespace, backingNamespace.myCharacteristic, this.myNoPiiExceptionHandler));
            service.setBackingStore((BackingNamespace)namespace, db.getConnection());
        });
        if (this.myInterceptor != null) {
            this.myServerBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)service.bindService(), (ServerInterceptor[])new ServerInterceptor[]{this.myInterceptor}));
        } else {
            this.myServerBuilder.addService(service.bindService());
        }
    }

    public void connect(@NotNull Common.Stream stream, @NotNull ManagedChannel channel) {
        if (stream == null) {
            DataStoreService.$$$reportNull$$$0(11);
        }
        if (channel == null) {
            DataStoreService.$$$reportNull$$$0(12);
        }
        assert (stream.getStreamId() != 0L);
        long streamId = stream.getStreamId();
        if (!this.myConnectedClients.containsKey(streamId)) {
            this.myConnectedClients.put(streamId, new DataStoreClient(channel));
            this.myTransportService.connectToChannel(stream, (Channel)channel);
        }
    }

    public void disconnect(long streamId) {
        if (this.myConnectedClients.containsKey(streamId)) {
            DataStoreClient client = this.myConnectedClients.remove(streamId);
            client.getChannel().shutdown();
            this.myTransportService.disconnectFromChannel((Channel)client.getChannel());
        }
    }

    public void shutdown() {
        this.myReportTimer.cancel();
        this.myServer.shutdownNow();
        for (DataStoreClient client : this.myConnectedClients.values()) {
            client.getChannel().shutdownNow();
        }
        this.myConnectedClients.clear();
        this.myDatabases.forEach((name, db) -> db.disconnect());
        DataStoreTable.removeDataStoreErrorCallback(this);
    }

    @VisibleForTesting
    List<ServicePassThrough> getRegisteredServices() {
        return this.myServices;
    }

    public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getCpuClient() : null;
    }

    public EnergyServiceGrpc.EnergyServiceBlockingStub getEnergyClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getEnergyClient() : null;
    }

    public EventServiceGrpc.EventServiceBlockingStub getEventClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getEventClient() : null;
    }

    public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getNetworkClient() : null;
    }

    public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getMemoryClient() : null;
    }

    public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getProfilerClient() : null;
    }

    public TransportServiceGrpc.TransportServiceBlockingStub getTransportClient(long streamId) {
        return this.myConnectedClients.containsKey(streamId) ? this.myConnectedClients.get(streamId).getTransportClient() : null;
    }

    @Override
    public void onDataStoreError(Throwable t) {
        this.myNoPiiExceptionHandler.accept(t);
    }

    @NotNull
    public LogService getLogService() {
        LogService logService = this.myLogService;
        if (logService == null) {
            DataStoreService.$$$reportNull$$$0(13);
        }
        return logService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datastoreDirectory";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchExecutor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "characteristic";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/DataStoreService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/DataStoreService";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDatabase";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ReportTimerTask
    extends TimerTask {
        private long myStartTime = System.nanoTime();

        private ReportTimerTask() {
        }

        @Override
        public void run() {
            AndroidProfilerDbStats.Builder dbStats = AndroidProfilerDbStats.newBuilder();
            dbStats.setAgeSec((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.myStartTime));
            this.collectReport(dbStats);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER_DB_STATS).setAndroidProfilerDbStats(dbStats);
            UsageTracker.log((AndroidStudioEvent.Builder)event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void collectReport(AndroidProfilerDbStats.Builder dbStats) {
            try {
                File dbFile = new File(DataStoreService.this.myDatastoreDirectory, BackingNamespace.DEFAULT_SHARED_NAMESPACE.myNamespace);
                dbStats.setTotalDiskMb((int)(dbFile.length() / 1024L / 1024L));
                for (DataStoreDatabase db : DataStoreService.this.myDatabases.values()) {
                    Statement tableStatement = db.getConnection().createStatement();
                    try {
                        ResultSet tableResults = tableStatement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                        try {
                            while (tableResults.next()) {
                                String tableName = tableResults.getString(1);
                                Statement sizeStatement = db.getConnection().createStatement();
                                try {
                                    ResultSet sizeResult = sizeStatement.executeQuery(String.format("SELECT COUNT(*) FROM %s", tableName));
                                    try {
                                        int tableSize = sizeResult.getInt(1);
                                        dbStats.addTablesBuilder().setName(tableName).setNumRecords(tableSize).build();
                                    }
                                    finally {
                                        if (sizeResult == null) continue;
                                        sizeResult.close();
                                    }
                                }
                                finally {
                                    if (sizeStatement == null) continue;
                                    sizeStatement.close();
                                }
                            }
                        }
                        finally {
                            if (tableResults == null) continue;
                            tableResults.close();
                        }
                    }
                    finally {
                        if (tableStatement == null) continue;
                        tableStatement.close();
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class DataStoreClient {
        @NotNull
        private final ManagedChannel myChannel;
        @NotNull
        private final TransportServiceGrpc.TransportServiceBlockingStub myTransportClient;
        @Nullable
        private ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerClient;
        @Nullable
        private CpuServiceGrpc.CpuServiceBlockingStub myCpuClient;
        @Nullable
        private EnergyServiceGrpc.EnergyServiceBlockingStub myEnergyClient;
        @Nullable
        private EventServiceGrpc.EventServiceBlockingStub myEventClient;
        @Nullable
        private MemoryServiceGrpc.MemoryServiceBlockingStub myMemoryClient;
        @Nullable
        private NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkClient;

        public DataStoreClient(@NotNull ManagedChannel channel) {
            if (channel == null) {
                DataStoreClient.$$$reportNull$$$0(0);
            }
            this.myChannel = channel;
            this.myTransportClient = TransportServiceGrpc.newBlockingStub((Channel)channel);
            if (!((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()) {
                this.myProfilerClient = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
                this.myCpuClient = CpuServiceGrpc.newBlockingStub((Channel)channel);
                this.myEnergyClient = EnergyServiceGrpc.newBlockingStub((Channel)channel);
                this.myEventClient = EventServiceGrpc.newBlockingStub((Channel)channel);
                this.myMemoryClient = MemoryServiceGrpc.newBlockingStub((Channel)channel);
                this.myNetworkClient = NetworkServiceGrpc.newBlockingStub((Channel)channel);
            }
        }

        @NotNull
        public ManagedChannel getChannel() {
            ManagedChannel managedChannel = this.myChannel;
            if (managedChannel == null) {
                DataStoreClient.$$$reportNull$$$0(1);
            }
            return managedChannel;
        }

        @NotNull
        public TransportServiceGrpc.TransportServiceBlockingStub getTransportClient() {
            TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub = this.myTransportClient;
            if (transportServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(2);
            }
            return transportServiceBlockingStub;
        }

        @Nullable
        public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient() {
            return this.myProfilerClient;
        }

        @Nullable
        public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
            return this.myCpuClient;
        }

        @Nullable
        public EnergyServiceGrpc.EnergyServiceBlockingStub getEnergyClient() {
            return this.myEnergyClient;
        }

        @Nullable
        public EventServiceGrpc.EventServiceBlockingStub getEventClient() {
            return this.myEventClient;
        }

        @Nullable
        public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient() {
            return this.myMemoryClient;
        }

        @Nullable
        public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient() {
            return this.myNetworkClient;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "channel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/DataStoreService$DataStoreClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/DataStoreService$DataStoreClient";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChannel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTransportClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BackingNamespace {
        public static final BackingNamespace DEFAULT_SHARED_NAMESPACE = new BackingNamespace("default.sql", DataStoreDatabase.Characteristic.DURABLE);
        @NotNull
        public final String myNamespace;
        @NotNull
        public final DataStoreDatabase.Characteristic myCharacteristic;

        public BackingNamespace(@NotNull String namespace, @NotNull DataStoreDatabase.Characteristic characteristic) {
            if (namespace == null) {
                BackingNamespace.$$$reportNull$$$0(0);
            }
            if (characteristic == null) {
                BackingNamespace.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myCharacteristic = characteristic;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.myNamespace, this.myCharacteristic});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackingNamespace)) {
                return false;
            }
            BackingNamespace other = (BackingNamespace)obj;
            return this.myNamespace.equals(other.myNamespace) && this.myCharacteristic == other.myCharacteristic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "characteristic";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/datastore/DataStoreService$BackingNamespace";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

