/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterAccumulator;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureNode
implements HNode<CaptureNode> {
    private long myStartGlobal;
    private long myEndGlobal;
    private long myStartThread;
    private long myEndThread;
    @NotNull
    protected final List<CaptureNode> myChildren;
    @NotNull
    private ClockType myClockType;
    private CaptureNode myParent;
    @NotNull
    private FilterType myFilterType;
    private int myDepth;
    @NotNull
    private final CaptureNodeModel myData;
    @Nullable
    private AspectModel<Aspect> myAspectModel;

    public CaptureNode(@NotNull CaptureNodeModel model) {
        if (model == null) {
            CaptureNode.$$$reportNull$$$0(0);
        }
        this.myAspectModel = null;
        this.myChildren = new ArrayList<CaptureNode>();
        this.myClockType = ClockType.GLOBAL;
        this.myFilterType = FilterType.MATCH;
        this.myDepth = 0;
        this.myData = model;
    }

    public void addChild(CaptureNode node) {
        this.myChildren.add(node);
        node.myParent = this;
    }

    @NotNull
    public List<CaptureNode> getChildren() {
        List<CaptureNode> list = this.myChildren;
        if (list == null) {
            CaptureNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public CaptureNodeModel getData() {
        CaptureNodeModel captureNodeModel = this.myData;
        if (captureNodeModel == null) {
            CaptureNode.$$$reportNull$$$0(2);
        }
        return captureNodeModel;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    @NotNull
    public CaptureNode getChildAt(int index) {
        CaptureNode captureNode = this.myChildren.get(index);
        if (captureNode == null) {
            CaptureNode.$$$reportNull$$$0(3);
        }
        return captureNode;
    }

    @Nullable
    public CaptureNode getParent() {
        return this.myParent;
    }

    @NotNull
    public CaptureNode findRootNode() {
        CaptureNode rootNode = this;
        while (rootNode.getParent() != null) {
            rootNode = rootNode.getParent();
        }
        CaptureNode captureNode = rootNode;
        if (captureNode == null) {
            CaptureNode.$$$reportNull$$$0(4);
        }
        return captureNode;
    }

    public long getStart() {
        return this.myClockType == ClockType.THREAD ? this.myStartThread : this.myStartGlobal;
    }

    public long getEnd() {
        return this.myClockType == ClockType.THREAD ? this.myEndThread : this.myEndGlobal;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public void setStartGlobal(long startGlobal) {
        this.myStartGlobal = startGlobal;
    }

    public long getStartGlobal() {
        return this.myStartGlobal;
    }

    public void setEndGlobal(long endGlobal) {
        this.myEndGlobal = endGlobal;
    }

    public long getEndGlobal() {
        return this.myEndGlobal;
    }

    public void setStartThread(long startThread) {
        this.myStartThread = startThread;
    }

    public long getStartThread() {
        return this.myStartThread;
    }

    public void setEndThread(long endThread) {
        this.myEndThread = endThread;
    }

    public long getEndThread() {
        return this.myEndThread;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CaptureNode.$$$reportNull$$$0(5);
        }
        this.myClockType = clockType;
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        if (this.myAspectModel == null) {
            this.myAspectModel = new AspectModel();
        }
        AspectModel<Aspect> aspectModel = this.myAspectModel;
        if (aspectModel == null) {
            CaptureNode.$$$reportNull$$$0(6);
        }
        return aspectModel;
    }

    public double threadGlobalRatio() {
        long durationThread = this.myEndThread - this.myStartThread;
        long durationGlobal = this.myEndGlobal - this.myStartGlobal;
        return (double)durationThread / (double)durationGlobal;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CaptureNode.$$$reportNull$$$0(7);
        }
        return clockType;
    }

    public void setDepth(int depth) {
        this.myDepth = depth;
    }

    @NotNull
    public List<CaptureNode> getTopKNodes(int k, @NotNull Predicate<CaptureNode> filter, @NotNull Comparator<CaptureNode> comparator) {
        if (filter == null) {
            CaptureNode.$$$reportNull$$$0(8);
        }
        if (comparator == null) {
            CaptureNode.$$$reportNull$$$0(9);
        }
        PriorityQueue<CaptureNode> candidates = new PriorityQueue<CaptureNode>(k + 1, comparator);
        this.getDescendantsStream().filter(filter).forEach(node -> {
            candidates.offer((CaptureNode)node);
            if (candidates.size() > k) {
                candidates.poll();
            }
        });
        ArrayList<CaptureNode> result = new ArrayList<CaptureNode>(candidates);
        Collections.sort(result, comparator.reversed());
        ArrayList<CaptureNode> arrayList = result;
        if (arrayList == null) {
            CaptureNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public Stream<CaptureNode> getDescendantsStream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(CaptureNode::getDescendantsStream));
    }

    @NotNull
    public FilterResult applyFilter(@NotNull Filter filter) {
        if (filter == null) {
            CaptureNode.$$$reportNull$$$0(11);
        }
        FilterAccumulator accumulator = new FilterAccumulator(!filter.isEmpty());
        this.computeFilter(filter, false, accumulator);
        if (this.myAspectModel != null) {
            this.myAspectModel.changed((Enum)Aspect.FILTER_APPLIED);
        }
        FilterResult filterResult = accumulator.toFilterResult();
        if (filterResult == null) {
            CaptureNode.$$$reportNull$$$0(12);
        }
        return filterResult;
    }

    private void computeFilter(@NotNull Filter filter, boolean matches, @NotNull FilterAccumulator accumulator) {
        if (filter == null) {
            CaptureNode.$$$reportNull$$$0(13);
        }
        if (accumulator == null) {
            CaptureNode.$$$reportNull$$$0(14);
        }
        boolean nodeExactMatch = filter.matches(this.getData().getFullName());
        boolean bl = matches = matches || nodeExactMatch;
        if (nodeExactMatch) {
            accumulator.increaseMatchCount();
        }
        accumulator.increaseTotalCount();
        boolean allChildrenUnmatch = true;
        for (CaptureNode child : this.getChildren()) {
            child.computeFilter(filter, matches, accumulator);
            if (child.isUnmatched()) continue;
            allChildrenUnmatch = false;
        }
        if (!matches && allChildrenUnmatch) {
            this.setFilterType(FilterType.UNMATCH);
        } else if (nodeExactMatch && !filter.isEmpty()) {
            this.setFilterType(FilterType.EXACT_MATCH);
        } else {
            this.setFilterType(FilterType.MATCH);
        }
    }

    @NotNull
    public FilterType getFilterType() {
        FilterType filterType = this.myFilterType;
        if (filterType == null) {
            CaptureNode.$$$reportNull$$$0(15);
        }
        return filterType;
    }

    public void setFilterType(@NotNull FilterType type) {
        if (type == null) {
            CaptureNode.$$$reportNull$$$0(16);
        }
        this.myFilterType = type;
    }

    public boolean isUnmatched() {
        return this.getFilterType() == FilterType.UNMATCH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CaptureNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CaptureNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspectModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopKNodes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyFilter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTopKNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeFilter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setFilterType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        FILTER_APPLIED;

    }

    public static enum FilterType {
        EXACT_MATCH,
        MATCH,
        UNMATCH;

    }
}

