/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.JavaMethodHChartColors;
import com.android.tools.profilers.cpu.capturedetails.NativeModelHChartColors;
import com.android.tools.profilers.cpu.capturedetails.SingleNameModelHChartColors;
import com.android.tools.profilers.cpu.capturedetails.SystemTraceNodeModelHChartColors;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class CaptureNodeHRenderer
implements HRenderer<CaptureNode> {
    private static final int MARGIN_PX = 3;
    @NotNull
    private CaptureDetails.Type myType;
    @NotNull
    private TextFitsPredicate myTextFitsPredicate;

    @VisibleForTesting
    CaptureNodeHRenderer(@NotNull CaptureDetails.Type type, @NotNull TextFitsPredicate textFitPredicate) {
        if (type == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(0);
        }
        if (textFitPredicate == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(1);
        }
        if (type != CaptureDetails.Type.CALL_CHART && type != CaptureDetails.Type.FLAME_CHART) {
            throw new IllegalStateException("Chart type not supported and can't be rendered.");
        }
        this.myType = type;
        this.myTextFitsPredicate = textFitPredicate;
    }

    @VisibleForTesting
    public CaptureNodeHRenderer() {
        this(CaptureDetails.Type.CALL_CHART);
    }

    public CaptureNodeHRenderer(@NotNull CaptureDetails.Type type) {
        if (type == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(2);
        }
        this(type, (text, metrics, width, height) -> (float)metrics.stringWidth(text) <= width && (float)metrics.getHeight() <= height);
    }

    private Color getFillColor(CaptureNode node, boolean isFocused, boolean isDeselected) {
        CaptureNodeModel nodeModel = node.getData();
        if (nodeModel instanceof JavaMethodModel) {
            return JavaMethodHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched(), isFocused, isDeselected);
        }
        if (nodeModel instanceof NativeNodeModel) {
            return NativeModelHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched(), isFocused, isDeselected);
        }
        if (nodeModel instanceof SystemTraceNodeModel) {
            return SystemTraceNodeModelHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched(), isFocused, isDeselected);
        }
        if (nodeModel instanceof SingleNameModel) {
            return SingleNameModelHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched(), isFocused, isDeselected);
        }
        throw new IllegalStateException("Node type not supported.");
    }

    private Color getIdleCpuColor(CaptureNode node, boolean isFocused, boolean isDeselected) {
        CaptureNodeModel nodeModel = node.getData();
        if (nodeModel instanceof SystemTraceNodeModel) {
            return SystemTraceNodeModelHChartColors.getIdleCpuColor(nodeModel, this.myType, node.isUnmatched(), isFocused, isDeselected);
        }
        return this.getFillColor(node, isFocused, isDeselected);
    }

    private Color getTextColor(CaptureNode node, boolean isDeselected) {
        CaptureNodeModel nodeModel = node.getData();
        if (nodeModel instanceof SystemTraceNodeModel) {
            return SystemTraceNodeModelHChartColors.getTextColor(nodeModel, this.myType, isDeselected);
        }
        return DataVisualizationColors.DEFAULT_DARK_TEXT_COLOR;
    }

    @NotNull
    static Color toUnmatchColor(@NotNull Color color) {
        if (color == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(3);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
    }

    public void render(@NotNull Graphics2D g, @NotNull CaptureNode node, @NotNull Rectangle2D fullDrawingArea, @NotNull Rectangle2D drawingArea, boolean isFocused, boolean isDeselected) {
        Font font;
        if (g == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(4);
        }
        if (node == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(5);
        }
        if (fullDrawingArea == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(6);
        }
        if (drawingArea == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(7);
        }
        CaptureNode captureNode = node;
        CaptureNodeModel nodeModel = node.getData();
        Color nodeColor = this.getFillColor(captureNode, isFocused, isDeselected);
        Color idleColor = this.getIdleCpuColor(captureNode, isFocused, isDeselected);
        g.setPaint(nodeColor);
        g.fill(drawingArea);
        double clockLength = node.getEnd() - node.getStart();
        double threadLength = node.getEndThread() - node.getStartThread();
        if (nodeModel instanceof SystemTraceNodeModel && threadLength > 0.0 && clockLength - threadLength > 0.0) {
            double ratio = 1.0 - threadLength / clockLength;
            double idleTimeWidth = ratio * fullDrawingArea.getWidth();
            double startPosition = fullDrawingArea.getX() + fullDrawingArea.getWidth() - idleTimeWidth;
            double clamppedStart = Math.min(drawingArea.getWidth() + drawingArea.getX(), Math.max(0.0, startPosition));
            double clampedWidth = Math.max(0.0, drawingArea.getX() + drawingArea.getWidth() - clamppedStart);
            g.setPaint(idleColor);
            g.fill(new Rectangle2D.Double(clamppedStart, fullDrawingArea.getY(), clampedWidth, fullDrawingArea.getHeight()));
        }
        Font restoreFont = font = g.getFont();
        Color textColor = this.getTextColor(node, isDeselected);
        if (captureNode.getFilterType() == CaptureNode.FilterType.MATCH) {
            g.setPaint(textColor);
        } else if (captureNode.getFilterType() == CaptureNode.FilterType.UNMATCH) {
            g.setPaint(CaptureNodeHRenderer.toUnmatchColor(textColor));
        } else {
            g.setPaint(textColor);
            font = font.deriveFont(1);
            g.setFont(font);
        }
        FontMetrics fontMetrics = g.getFontMetrics(font);
        float availableWidth = (float)drawingArea.getWidth() - 6.0f;
        float availableHeight = (float)drawingArea.getHeight();
        if (availableWidth > 1.0f) {
            String text = CaptureNodeHRenderer.generateFittingText(node.getData(), s -> this.myTextFitsPredicate.test((String)s, fontMetrics, availableWidth, availableHeight));
            float textPositionX = 3.0f + (float)drawingArea.getX();
            float textPositionY = (float)(drawingArea.getY() + (double)fontMetrics.getAscent());
            g.drawString(text, textPositionX, textPositionY);
        }
        g.setFont(restoreFont);
    }

    private static String generateFittingText(CaptureNodeModel model, Predicate<String> textFitsPredicate) {
        String classOrNamespace = "";
        String separator = "";
        if (model instanceof CppFunctionModel) {
            classOrNamespace = ((CppFunctionModel)model).getClassOrNamespace();
            separator = "::";
        } else if (model instanceof JavaMethodModel) {
            classOrNamespace = ((JavaMethodModel)model).getClassName();
            separator = ".";
        }
        if (!separator.isEmpty() && !classOrNamespace.isEmpty()) {
            String[] classElements = classOrNamespace.split(separator.equals(".") ? "\\." : separator);
            for (int abbreviationCount = 0; abbreviationCount <= classElements.length; ++abbreviationCount) {
                StringBuilder textBuilder = new StringBuilder();
                for (int i = 0; i < classElements.length; ++i) {
                    if (i < abbreviationCount && !classElements[i].isEmpty()) {
                        textBuilder.append(classElements[i].charAt(0));
                    } else {
                        textBuilder.append(classElements[i]);
                    }
                    textBuilder.append(separator);
                }
                textBuilder.append(model.getName());
                String text = textBuilder.toString();
                if (!textFitsPredicate.test(text)) continue;
                return text;
            }
        }
        return AdtUiUtils.shrinkToFit((String)model.getName(), textFitsPredicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFitPredicate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullDrawingArea";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingArea";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureNodeHRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "toUnmatchColor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TextFitsPredicate {
        public boolean test(String var1, FontMetrics var2, float var3, float var4);
    }
}

