/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class CpuTraceTreeSorter
implements ColumnTreeBuilder.TreeSorter<DefaultMutableTreeNode> {
    @NotNull
    private JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private CpuTreeModel myModel;
    private Comparator<DefaultMutableTreeNode> myComparator;

    public CpuTraceTreeSorter(@NotNull JTree tree) {
        if (tree == null) {
            CpuTraceTreeSorter.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    public void setModel(CpuTreeModel model, Comparator<DefaultMutableTreeNode> sorting) {
        this.myModel = model;
        if (this.myModel != null) {
            this.myRoot = (DefaultMutableTreeNode)model.getRoot();
            this.sort(sorting, SortOrder.UNSORTED);
            this.myTree.invalidate();
        }
    }

    public void sort(Comparator<DefaultMutableTreeNode> comparator, SortOrder order) {
        this.myComparator = new MatchedNodeFirstComparator(comparator);
        this.sort();
    }

    private void sortTree(@NotNull DefaultMutableTreeNode parent) {
        if (parent == null) {
            CpuTraceTreeSorter.$$$reportNull$$$0(1);
        }
        if (parent.isLeaf()) {
            return;
        }
        int childCount = parent.getChildCount();
        ArrayList<DefaultMutableTreeNode> children2 = new ArrayList<DefaultMutableTreeNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children2.add((DefaultMutableTreeNode)parent.getChildAt(i));
        }
        children2.sort(this.myComparator);
        parent.removeAllChildren();
        for (DefaultMutableTreeNode node : children2) {
            this.sortTree(node);
            parent.add(node);
        }
    }

    public void sort() {
        if (this.myModel != null && this.myRoot != null) {
            TreePath selectionPath = this.myTree.getSelectionPath();
            this.sortTree(this.myRoot);
            this.myTree.setSelectionPath(selectionPath);
            this.myTree.scrollPathToVisible(selectionPath);
            this.myModel.reload();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CpuTraceTreeSorter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sortTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MatchedNodeFirstComparator
    implements Comparator<DefaultMutableTreeNode> {
        @NotNull
        private Comparator<DefaultMutableTreeNode> myComparator;

        MatchedNodeFirstComparator(@NotNull Comparator<DefaultMutableTreeNode> comparator) {
            if (comparator == null) {
                MatchedNodeFirstComparator.$$$reportNull$$$0(0);
            }
            this.myComparator = comparator;
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
            return cmp == 0 ? this.myComparator.compare(a, b) : cmp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/android/tools/profilers/cpu/capturedetails/CpuTraceTreeSorter$MatchedNodeFirstComparator", "<init>"));
        }
    }
}

