/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.nodemodel;

import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/cpu/nodemodel/SystemTraceNodeFactory;", "", "()V", "ID_GROUP", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "canonicalMap", "", "", "Lcom/android/tools/profilers/cpu/nodemodel/SystemTraceNodeFactory$CanonicalNodeId;", "nodeMap", "Lcom/android/tools/profilers/cpu/nodemodel/SystemTraceNodeModel;", "computeCanonicalId", "name", "getNode", "CanonicalNodeId", "intellij.android.profilers"})
public final class SystemTraceNodeFactory {
    private final Map<String, CanonicalNodeId> canonicalMap = new LinkedHashMap();
    private final Map<CanonicalNodeId, SystemTraceNodeModel> nodeMap = new LinkedHashMap();
    private final Pattern ID_GROUP = Pattern.compile("^([A-Za-z\\s]*)(\\d+)");

    @NotNull
    public final SystemTraceNodeModel getNode(@NotNull String name) {
        Object object;
        CanonicalNodeId canonicalNodeId;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<Object, Object> $this$getOrPut$iv = this.canonicalMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            CanonicalNodeId answer$iv = this.computeCanonicalId(name);
            $this$getOrPut$iv.put(name, answer$iv);
            canonicalNodeId = answer$iv;
        } else {
            canonicalNodeId = value$iv;
        }
        CanonicalNodeId canonicalId = canonicalNodeId;
        $this$getOrPut$iv = this.nodeMap;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(canonicalId);
        if (value$iv == null) {
            boolean bl = false;
            SystemTraceNodeModel answer$iv = new SystemTraceNodeModel(canonicalId.getId(), canonicalId.getName());
            $this$getOrPut$iv.put(canonicalId, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SystemTraceNodeModel)object;
    }

    private final CanonicalNodeId computeCanonicalId(String name) {
        Matcher matches = this.ID_GROUP.matcher(name);
        if (matches.matches() && Intrinsics.areEqual((Object)matches.group(0), (Object)name)) {
            String string = matches.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matches.group(1)");
            return new CanonicalNodeId(string, matches.group(1) + "###");
        }
        return new CanonicalNodeId(name, name);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/cpu/nodemodel/SystemTraceNodeFactory$CanonicalNodeId;", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.profilers"})
    private static final class CanonicalNodeId {
        @NotNull
        private final String id;
        @NotNull
        private final String name;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public CanonicalNodeId(@NotNull String id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final CanonicalNodeId copy(@NotNull String id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new CanonicalNodeId(id, name);
        }

        public static /* synthetic */ CanonicalNodeId copy$default(CanonicalNodeId canonicalNodeId, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = canonicalNodeId.id;
            }
            if ((n & 2) != 0) {
                string2 = canonicalNodeId.name;
            }
            return canonicalNodeId.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CanonicalNodeId(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CanonicalNodeId)) break block3;
                    CanonicalNodeId canonicalNodeId = (CanonicalNodeId)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)canonicalNodeId.id) || !Intrinsics.areEqual((Object)this.name, (Object)canonicalNodeId.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

