/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.CachedFunction;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassifierSet
implements MemoryObject {
    @Nullable
    private String myName;
    @Nullable
    private Supplier<String> myNameSupplier;
    @NotNull
    protected final Set<InstanceObject> mySnapshotInstances;
    @NotNull
    protected final Set<InstanceObject> myDeltaInstances;
    @Nullable
    protected Classifier myClassifier;
    private int myObjectSetCount;
    private int myFilteredObjectSetCount;
    private int mySnapshotObjectCount;
    private int myDeltaAllocations;
    private int myDeltaDeallocations;
    private long myDeltaAllocationsSize;
    private long myDeltaDeallocationsSize;
    private long myTotalNativeSize;
    private long myTotalShallowSize;
    private long myTotalRetainedSize;
    private long myDeltaShallowSize;
    private int myInstancesWithStackInfoCount;
    protected int myFilterMatchCount;
    private final CachedFunction<CaptureObjectInstanceFilter, Integer> myInstanceFilterMatchCounter;
    protected boolean myIsFiltered;
    protected boolean myIsMatched;
    protected boolean myNeedsRefiltering;

    public ClassifierSet(@NotNull String name) {
        if (name == null) {
            ClassifierSet.$$$reportNull$$$0(0);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myDeltaAllocationsSize = 0L;
        this.myDeltaDeallocationsSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myDeltaShallowSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myInstanceFilterMatchCounter = new CachedFunction(this::countInstanceFilterMatch, new IdentityHashMap());
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        if (nameSupplier == null) {
            ClassifierSet.$$$reportNull$$$0(1);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myDeltaAllocationsSize = 0L;
        this.myDeltaDeallocationsSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myDeltaShallowSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myInstanceFilterMatchCounter = new CachedFunction(this::countInstanceFilterMatch, new IdentityHashMap());
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        String string = this.myName;
        if (string == null) {
            ClassifierSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    public final boolean isEmpty() {
        return this.mySnapshotObjectCount == 0 && this.myDeltaAllocations == 0 && this.myDeltaDeallocations == 0;
    }

    public final int getTotalObjectCount() {
        return this.mySnapshotObjectCount + this.myDeltaAllocations - this.myDeltaDeallocations;
    }

    public final int getTotalObjectSetCount() {
        return this.myObjectSetCount;
    }

    public final int getFilteredObjectSetCount() {
        return this.myFilteredObjectSetCount;
    }

    public final int getDeltaAllocationCount() {
        return this.myDeltaAllocations;
    }

    public final int getDeltaDeallocationCount() {
        return this.myDeltaDeallocations;
    }

    public final long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public final long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public final long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public final long getDeltaShallowSize() {
        return this.myDeltaShallowSize;
    }

    public final int getFilterMatchCount() {
        return this.myFilterMatchCount;
    }

    public final long getAllocationSize() {
        return this.myDeltaAllocationsSize;
    }

    public final long getDeallocationSize() {
        return this.myDeltaDeallocationsSize;
    }

    public final long getTotalRemainingSize() {
        return this.getAllocationSize() - this.getDeallocationSize();
    }

    public final int getInstanceFilterMatchCount(CaptureObjectInstanceFilter filter) {
        return this.myInstanceFilterMatchCounter.invoke(filter);
    }

    public void addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(3);
        }
        this.changeSnapshotInstanceObject(instanceObject, SetOperation.ADD);
    }

    public void removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(4);
        }
        this.changeSnapshotInstanceObject(instanceObject, SetOperation.REMOVE);
    }

    private boolean changeSnapshotInstanceObject(@NotNull InstanceObject instanceObject, @NotNull SetOperation op) {
        boolean changed;
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(5);
        }
        if (op == null) {
            ClassifierSet.$$$reportNull$$$0(6);
        }
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, op == SetOperation.ADD);
            changed = classifierSet != null && classifierSet.changeSnapshotInstanceObject(instanceObject, op);
        } else {
            changed = op == SetOperation.ADD != this.mySnapshotInstances.contains(instanceObject);
            op.action.accept(this.mySnapshotInstances, instanceObject);
        }
        if (changed) {
            this.mySnapshotObjectCount += op.countChange;
            this.myTotalNativeSize += (long)op.countChange * ClassifierSet.validOrZero(instanceObject.getNativeSize());
            this.myTotalShallowSize += (long)op.countChange * ClassifierSet.validOrZero(instanceObject.getShallowSize());
            this.myTotalRetainedSize += (long)op.countChange * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
            if (!instanceObject.isCallStackEmpty()) {
                this.myInstancesWithStackInfoCount += op.countChange;
            }
            this.myInstanceFilterMatchCounter.invalidate();
            this.myNeedsRefiltering = true;
        }
        return changed;
    }

    public boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(7);
        }
        return this.changeDeltaInstanceInformation((InstanceObject)instanceObject, (boolean)true, (SetOperation)SetOperation.ADD).instanceChanged;
    }

    public boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(8);
        }
        return this.changeDeltaInstanceInformation((InstanceObject)instanceObject, (boolean)false, (SetOperation)SetOperation.ADD).instanceChanged;
    }

    public boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(9);
        }
        return this.changeDeltaInstanceInformation((InstanceObject)instanceObject, (boolean)true, (SetOperation)SetOperation.REMOVE).instanceChanged;
    }

    public boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(10);
        }
        return this.changeDeltaInstanceInformation((InstanceObject)instanceObject, (boolean)false, (SetOperation)SetOperation.REMOVE).instanceChanged;
    }

    private DeltaChange changeDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation, @NotNull SetOperation op) {
        DeltaChange change;
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(11);
        }
        if (op == null) {
            ClassifierSet.$$$reportNull$$$0(12);
        }
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, op == SetOperation.ADD);
            change = classifierSet != null ? classifierSet.changeDeltaInstanceInformation(instanceObject, isAllocation, op) : DeltaChange.UNCHANGED;
        } else if (!(op != SetOperation.ADD && instanceObject.hasTimeData() || op == SetOperation.ADD == this.myDeltaInstances.contains(instanceObject))) {
            op.action.accept(this.myDeltaInstances, instanceObject);
            change = DeltaChange.INSTANCE_ADDED_OR_REMOVED;
        } else {
            change = DeltaChange.INSTANCE_MODIFIED;
        }
        if (change.countsChanged) {
            if (isAllocation) {
                this.myDeltaAllocations += op.countChange * instanceObject.getInstanceCount();
                this.myDeltaAllocationsSize += (long)(op.countChange * instanceObject.getShallowSize());
            } else {
                this.myDeltaDeallocations += op.countChange * instanceObject.getInstanceCount();
                this.myDeltaDeallocationsSize += (long)(op.countChange * instanceObject.getShallowSize());
            }
            int factor = op.countChange * (isAllocation ? 1 : -1);
            long deltaNativeSize = (long)factor * ClassifierSet.validOrZero(instanceObject.getNativeSize());
            long deltaShallowSize = (long)factor * ClassifierSet.validOrZero(instanceObject.getShallowSize());
            long deltaRetainedSize = (long)factor * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
            this.myTotalNativeSize += deltaNativeSize;
            this.myDeltaShallowSize += deltaShallowSize;
            this.myTotalShallowSize += deltaShallowSize;
            this.myTotalRetainedSize += deltaRetainedSize;
            if (change.instanceChanged && !instanceObject.isCallStackEmpty()) {
                this.myInstancesWithStackInfoCount += op.countChange;
                this.myNeedsRefiltering = true;
            }
            if (change.instanceChanged) {
                this.myInstanceFilterMatchCounter.invalidate();
            }
        }
        return change;
    }

    public void clearClassifierSets() {
        this.mySnapshotInstances.clear();
        this.myDeltaInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myDeltaShallowSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.myFilterMatchCount = 0;
    }

    public int getInstancesCount() {
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> Stream.concat(me.mySnapshotInstances.stream(), me.myDeltaInstances.stream()).distinct());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getDeltaInstanceStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> me.myDeltaInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getSnapshotInstanceStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> me.mySnapshotInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(15);
        }
        return stream;
    }

    public Stream<InstanceObject> getFilterMatches() {
        return this.getStreamOf(me -> me.getIsMatched() ? me.getInstancesStream() : Stream.empty());
    }

    private Stream<InstanceObject> getStreamOf(Function<ClassifierSet, Stream<InstanceObject>> extractor) {
        return this.myClassifier == null ? extractor.apply(this) : Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(sub -> sub.getStreamOf(extractor)), extractor.apply(this));
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        List<ClassifierSet> list = this.myClassifier.getFilteredClassifierSets();
        if (list == null) {
            ClassifierSet.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        if (target == null) {
            ClassifierSet.$$$reportNull$$$0(17);
        }
        boolean instancesContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
        if (instancesContainsTarget && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            boolean stillContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
            if (instancesContainsTarget && stillContainsTarget) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public ClassifierSet findClassifierSet(@NotNull Predicate<ClassifierSet> pred) {
        if (pred == null) {
            ClassifierSet.$$$reportNull$$$0(18);
        }
        if (pred.test(this)) {
            return this;
        }
        if (this.myClassifier != null) {
            return this.getChildrenClassifierSets().stream().map(s -> s.findClassifierSet(pred)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public boolean isSupersetOf(Set<InstanceObject> targetSet) {
        Set<InstanceObject> clone = Collections.newSetFromMap(new IdentityHashMap());
        clone.addAll(targetSet);
        this.filterOutInstances(clone);
        return clone.isEmpty();
    }

    private void filterOutInstances(Set<InstanceObject> remainders) {
        remainders.removeAll(this.myDeltaInstances);
        remainders.removeAll(this.mySnapshotInstances);
        if (this.myClassifier != null && !remainders.isEmpty()) {
            for (ClassifierSet child : this.myClassifier.getAllClassifierSets()) {
                child.filterOutInstances(remainders);
                if (!remainders.isEmpty()) continue;
                return;
            }
        }
    }

    public boolean immediateInstancesOverlapWith(Set<InstanceObject> targetSet) {
        return ClassifierSet.overlaps(this.myDeltaInstances, targetSet) || ClassifierSet.overlaps(this.mySnapshotInstances, targetSet);
    }

    public boolean overlapsWith(Set<InstanceObject> targetSet) {
        return this.immediateInstancesOverlapWith(targetSet) || this.myClassifier != null && this.myClassifier.getAllClassifierSets().stream().anyMatch(c -> c.overlapsWith(targetSet));
    }

    private static boolean overlaps(Set<InstanceObject> set1, Set<InstanceObject> set2) {
        Set<InstanceObject> iter = set1.size() < set2.size() ? set1 : set2;
        Set<InstanceObject> test = iter == set1 ? set2 : set1;
        return iter.stream().anyMatch(test::contains);
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.mySnapshotInstances, this.myDeltaInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public boolean getIsFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    public boolean getIsMatched() {
        return this.myIsMatched;
    }

    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(19);
        }
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsFiltered = true;
        this.ensurePartition();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = this.myClassifier.getAllClassifierSets().size();
        this.myFilteredObjectSetCount = 0;
        this.myIsMatched = this.matches(filter);
        int n = this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        assert (this.myClassifier != null);
        for (ClassifierSet classifierSet : this.myClassifier.getAllClassifierSets()) {
            classifierSet.applyFilter(filter, hasMatchedAncestor || this.myIsMatched, filterChanged);
            this.myObjectSetCount += classifierSet.myObjectSetCount;
            if (classifierSet.getIsFiltered()) continue;
            this.myIsFiltered = false;
            this.mySnapshotObjectCount += classifierSet.mySnapshotObjectCount;
            this.myDeltaAllocations += classifierSet.myDeltaAllocations;
            this.myDeltaDeallocations += classifierSet.myDeltaDeallocations;
            this.myTotalShallowSize += classifierSet.myTotalShallowSize;
            this.myTotalNativeSize += classifierSet.myTotalNativeSize;
            this.myTotalRetainedSize += classifierSet.myTotalRetainedSize;
            this.myDeltaShallowSize += classifierSet.myDeltaShallowSize;
            this.myInstancesWithStackInfoCount += classifierSet.myInstancesWithStackInfoCount;
            this.myFilterMatchCount += classifierSet.myFilterMatchCount;
            ++this.myFilteredObjectSetCount;
        }
        this.myNeedsRefiltering = false;
    }

    protected boolean matches(@NotNull Filter filter) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(20);
        }
        return filter.matches(this.getName());
    }

    private int countInstanceFilterMatch(CaptureObjectInstanceFilter filter) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            return this.myClassifier.getAllClassifierSets().stream().mapToInt(s -> s.getInstanceFilterMatchCount(filter)).sum();
        }
        int total = 0;
        for (InstanceObject inst : this.myDeltaInstances) {
            if (!((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        for (InstanceObject inst : this.mySnapshotInstances) {
            if (this.myDeltaInstances.contains(inst) || !((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        return total;
    }

    private static long validOrZero(long value) {
        return value == -1L ? 0L : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSupplier";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/ClassifierSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceObject";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pred";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/ClassifierSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesStream";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeltaInstanceStream";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshotInstanceStream";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenClassifierSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSnapshotInstanceObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSnapshotInstanceObject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeSnapshotInstanceObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDeltaInstanceObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "freeDeltaInstanceObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAddedDeltaInstanceObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFreedDeltaInstanceObject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "changeDeltaInstanceInformation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClassifierSet";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClassifierSet";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SetOperation {
        ADD(Set::add, 1),
        REMOVE(Set::remove, -1);

        public final BiConsumer<Set<InstanceObject>, InstanceObject> action;
        public final int countChange;

        private SetOperation(BiConsumer<Set<InstanceObject>, InstanceObject> action, int countChange) {
            this.action = action;
            this.countChange = countChange;
        }
    }

    private static enum DeltaChange {
        UNCHANGED(false, false),
        INSTANCE_MODIFIED(true, false),
        INSTANCE_ADDED_OR_REMOVED(true, true);

        public final boolean countsChanged;
        public final boolean instanceChanged;

        private DeltaChange(boolean countsChanged, boolean instanceChanged) {
            this.countsChanged = countsChanged;
            this.instanceChanged = instanceChanged;
        }
    }
}

