/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeAllocationMethodSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NativeFunctionClassifier
extends Classifier {
    @NotNull
    private final Map<Memory.AllocationStack.StackFrame, NativeCallStackSet> myFunctions = new LinkedHashMap<Memory.AllocationStack.StackFrame, NativeCallStackSet>();
    @NotNull
    private final Map<String, NativeAllocationMethodSet> myAllocations = new LinkedHashMap<String, NativeAllocationMethodSet>();
    private final int myDepth;

    NativeFunctionClassifier(int depth) {
        this.myDepth = depth;
    }

    @Override
    @Nullable
    public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
        Memory.AllocationStack.StackFrame function;
        if (instance == null) {
            NativeFunctionClassifier.$$$reportNull$$$0(0);
        }
        if ((function = this.getFrameAtCurrentDepth(instance)) != null) {
            NativeCallStackSet methodSet = this.myFunctions.get(function);
            if (methodSet == null && createIfAbsent) {
                methodSet = new NativeCallStackSet(function, this.myDepth + 1);
                this.myFunctions.put(function, methodSet);
            }
            return methodSet;
        }
        String name = instance.getClassEntry().getClassName();
        NativeAllocationMethodSet allocation = this.myAllocations.get(name);
        if (allocation == null && createIfAbsent) {
            allocation = new NativeAllocationMethodSet(name);
            this.myAllocations.put(name, allocation);
        }
        return allocation;
    }

    @Nullable
    private Memory.AllocationStack.StackFrame getFrameAtCurrentDepth(@NotNull InstanceObject instance) {
        if (instance == null) {
            NativeFunctionClassifier.$$$reportNull$$$0(1);
        }
        int stackDepth = instance.getCallStackDepth();
        Memory.AllocationStack stack = instance.getAllocationCallStack();
        if (stackDepth <= 0 || this.myDepth >= stackDepth || stack == null) {
            return null;
        }
        int frameIndex = stackDepth - this.myDepth - 1;
        Memory.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
        Memory.AllocationStack.StackFrame stackFrame = fullStack.getFrames(frameIndex);
        return stackFrame;
    }

    @Override
    @NotNull
    public List<ClassifierSet> getFilteredClassifierSets() {
        List<ClassifierSet> list = Stream.concat(this.myFunctions.values().stream(), this.myAllocations.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
        if (list == null) {
            NativeFunctionClassifier.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<ClassifierSet> getAllClassifierSets() {
        List<ClassifierSet> list = Stream.concat(this.myFunctions.values().stream(), this.myAllocations.values().stream()).collect(Collectors.toList());
        if (list == null) {
            NativeFunctionClassifier.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/NativeFunctionClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/NativeFunctionClassifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredClassifierSets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassifierSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassifierSet";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFrameAtCurrentDepth";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

