/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto.traceprocessor;

import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModel$Builder$WhenMappings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0002\"#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "Ljava/io/Serializable;", "builder", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "(Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;)V", "androidFrameLayers", "", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "cpuCores", "Lcom/android/tools/profilers/cpu/systemtrace/CpuCoreModel;", "danglingThreads", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "endCaptureTimestamp", "", "processMap", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "startCaptureTimestamp", "getAndroidFrameLayers", "getCaptureEndTimestampUs", "getCaptureStartTimestampUs", "getCpuCores", "getDanglingThread", "tid", "getProcessById", "id", "getProcesses", "getSystemTraceTechnology", "Lcom/android/tools/profiler/proto/Cpu$CpuTraceType;", "isCapturePossibleCorrupted", "", "Builder", "Companion", "intellij.android.profilers"})
public final class TraceProcessorModel
implements SystemTraceModelAdapter,
Serializable {
    private final Map<Integer, ProcessModel> processMap;
    private final List<CpuCoreModel> cpuCores;
    private final List<TraceProcessor.AndroidFrameEventsResult.Layer> androidFrameLayers;
    private final Map<Integer, ThreadModel> danglingThreads;
    private final long startCaptureTimestamp;
    private final long endCaptureTimestamp;
    private static final long serialVersionUID;
    @NotNull
    public static final Companion Companion;

    @Override
    public long getCaptureStartTimestampUs() {
        return this.startCaptureTimestamp;
    }

    @Override
    public long getCaptureEndTimestampUs() {
        return this.endCaptureTimestamp;
    }

    @Override
    @Nullable
    public ProcessModel getProcessById(int id) {
        return this.processMap.get(id);
    }

    @Override
    @NotNull
    public List<ProcessModel> getProcesses() {
        return CollectionsKt.toList((Iterable)this.processMap.values());
    }

    @Override
    @Nullable
    public ThreadModel getDanglingThread(int tid) {
        return this.danglingThreads.get(tid);
    }

    @Override
    @NotNull
    public List<CpuCoreModel> getCpuCores() {
        return this.cpuCores;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceType getSystemTraceTechnology() {
        return Cpu.CpuTraceType.PERFETTO;
    }

    @Override
    public boolean isCapturePossibleCorrupted() {
        return false;
    }

    @Override
    @NotNull
    public List<TraceProcessor.AndroidFrameEventsResult.Layer> getAndroidFrameLayers() {
        return this.androidFrameLayers;
    }

    /*
     * WARNING - void declaration
     */
    public TraceProcessorModel(@NotNull Builder builder) {
        void $this$mapTo$iv$iv;
        void it;
        Object updatedThreadMap;
        Serializable serializable;
        CounterModel entry;
        Object object;
        Collection<Object> collection;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.danglingThreads = builder.getDanglingThreads$intellij_android_profilers();
        this.startCaptureTimestamp = builder.getStartCaptureTimestamp$intellij_android_profilers();
        this.endCaptureTimestamp = builder.getEndCaptureTimestamp$intellij_android_profilers();
        Map processMapBuilder = new LinkedHashMap();
        for (ProcessModel processModel : builder.getProcessById$intellij_android_profilers().values()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$mapValuesTo$iv$iv;
            Map<Integer, ThreadModel> $this$mapValues$iv = processModel.getThreadById();
            boolean $i$f$mapValues232 = false;
            Map<Integer, ThreadModel> iterator = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                collection = k;
                object = map2;
                boolean bl2 = false;
                serializable = ThreadModel.copy$default((ThreadModel)entry.getValue(), 0, 0, null, builder.getThreadToEventsMap$intellij_android_profilers().getOrDefault(entry.getKey(), CollectionsKt.emptyList()), builder.getThreadToScheduling$intellij_android_profilers().getOrDefault(entry.getKey(), CollectionsKt.emptyList()), 7, null);
                object.put(collection, serializable);
            }
            updatedThreadMap = MapsKt.toSortedMap((Map)destination$iv$iv);
            Iterable $i$f$mapValues232 = builder.getProcessToCounters$intellij_android_profilers().getOrDefault(processModel.getId(), CollectionsKt.emptyList());
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Object element$iv$iv$iv;
                element$iv$iv$iv = (CounterModel)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                collection = TuplesKt.to((Object)it.getName(), (Object)it);
                object.add(collection);
            }
            Map counterMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            processMapBuilder.put(processModel.getId(), ProcessModel.copy$default(processModel, 0, null, (Map)updatedThreadMap, counterMap, 3, null));
        }
        this.processMap = MapsKt.toSortedMap((Map)processMapBuilder);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)builder.getCpuCoresCount$intellij_android_profilers());
        object = this;
        boolean $i$f$map = false;
        updatedThreadMap = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            void it2;
            int item$iv$iv;
            int destination$iv$iv2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $i$f$associateByTo = builder.getCoreToCpuCounters$intellij_android_profilers().getOrDefault((int)it2, CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            it = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void counterModel;
                entry = (CounterModel)item$iv$iv2;
                Collection collection2 = destination$iv$iv3;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)counterModel.getName(), (Object)counterModel);
                collection2.add(pair);
            }
            Map cpuCountersMap = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            serializable = new CpuCoreModel((int)it2, builder.getCoreToScheduling$intellij_android_profilers().getOrDefault((int)it2, CollectionsKt.emptyList()), cpuCountersMap);
            collection.add(serializable);
        }
        collection = (List)destination$iv$iv;
        ((TraceProcessorModel)object).cpuCores = collection;
        this.androidFrameLayers = builder.getAndroidFrameLayers$intellij_android_profilers();
    }

    static {
        Companion = new Companion(null);
        serialVersionUID = -2228053132990163476L;
    }

    public static final long getSerialVersionUID() {
        Companion companion = Companion;
        return serialVersionUID;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020.2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020AJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u001bH\u0002JP\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020)0I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001b0K2\u0018\u0010L\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000b0I2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020)0IH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u001a\u0010%\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001fR&\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000eR&\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u000e\u00a8\u0006N"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "", "()V", "androidFrameLayers", "", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "getAndroidFrameLayers$intellij_android_profilers", "()Ljava/util/List;", "coreToCpuCounters", "", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "getCoreToCpuCounters$intellij_android_profilers", "()Ljava/util/Map;", "coreToScheduling", "Lcom/android/tools/profilers/cpu/systemtrace/SchedulingEventModel;", "getCoreToScheduling$intellij_android_profilers", "cpuCoresCount", "getCpuCoresCount$intellij_android_profilers", "()I", "setCpuCoresCount$intellij_android_profilers", "(I)V", "danglingThreads", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "getDanglingThreads$intellij_android_profilers", "endCaptureTimestamp", "", "getEndCaptureTimestamp$intellij_android_profilers", "()J", "setEndCaptureTimestamp$intellij_android_profilers", "(J)V", "processById", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "getProcessById$intellij_android_profilers", "processToCounters", "getProcessToCounters$intellij_android_profilers", "startCaptureTimestamp", "getStartCaptureTimestamp$intellij_android_profilers", "setStartCaptureTimestamp$intellij_android_profilers", "threadToEventsMap", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "getThreadToEventsMap$intellij_android_profilers", "threadToScheduling", "getThreadToScheduling$intellij_android_profilers", "addAndroidFrameEvents", "", "frameEventsResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult;", "addCpuCounters", "result", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$CpuCoreCountersResult;", "addProcessCounters", "counters", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessCountersResult;", "addProcessMetadata", "processMetadataResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessMetadataResult;", "addSchedulingEvents", "schedEvents", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult;", "addTraceEvents", "traceEventsResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$TraceEventsResult;", "build", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "convertSchedulingState", "Lcom/android/tools/profilers/cpu/ThreadState;", "state", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult$SchedulingEvent$SchedulingState;", "convertToUs", "tsNanos", "reconstructTraceTree", "", "rootIds", "", "eventToChildrenIds", "eventPerId", "intellij.android.profilers"})
    public static final class Builder {
        private long startCaptureTimestamp = Long.MAX_VALUE;
        private long endCaptureTimestamp = Long.MIN_VALUE;
        private int cpuCoresCount;
        @NotNull
        private final Map<Integer, ProcessModel> processById = new LinkedHashMap();
        @NotNull
        private final Map<Integer, ThreadModel> danglingThreads = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<TraceEventModel>> threadToEventsMap = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> threadToScheduling = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> coreToScheduling = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<CounterModel>> coreToCpuCounters = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<CounterModel>> processToCounters = new LinkedHashMap();
        @NotNull
        private final List<TraceProcessor.AndroidFrameEventsResult.Layer> androidFrameLayers = new ArrayList();

        public final long getStartCaptureTimestamp$intellij_android_profilers() {
            return this.startCaptureTimestamp;
        }

        public final void setStartCaptureTimestamp$intellij_android_profilers(long l) {
            this.startCaptureTimestamp = l;
        }

        public final long getEndCaptureTimestamp$intellij_android_profilers() {
            return this.endCaptureTimestamp;
        }

        public final void setEndCaptureTimestamp$intellij_android_profilers(long l) {
            this.endCaptureTimestamp = l;
        }

        public final int getCpuCoresCount$intellij_android_profilers() {
            return this.cpuCoresCount;
        }

        public final void setCpuCoresCount$intellij_android_profilers(int n) {
            this.cpuCoresCount = n;
        }

        @NotNull
        public final Map<Integer, ProcessModel> getProcessById$intellij_android_profilers() {
            return this.processById;
        }

        @NotNull
        public final Map<Integer, ThreadModel> getDanglingThreads$intellij_android_profilers() {
            return this.danglingThreads;
        }

        @NotNull
        public final Map<Integer, List<TraceEventModel>> getThreadToEventsMap$intellij_android_profilers() {
            return this.threadToEventsMap;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getThreadToScheduling$intellij_android_profilers() {
            return this.threadToScheduling;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getCoreToScheduling$intellij_android_profilers() {
            return this.coreToScheduling;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getCoreToCpuCounters$intellij_android_profilers() {
            return this.coreToCpuCounters;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getProcessToCounters$intellij_android_profilers() {
            return this.processToCounters;
        }

        @NotNull
        public final List<TraceProcessor.AndroidFrameEventsResult.Layer> getAndroidFrameLayers$intellij_android_profilers() {
            return this.androidFrameLayers;
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessMetadata(@NotNull TraceProcessor.ProcessMetadataResult processMetadataResult) {
            Intrinsics.checkNotNullParameter((Object)processMetadataResult, (String)"processMetadataResult");
            Iterator<GeneratedMessageV3> iterator = processMetadataResult.getProcessList().iterator();
            while (iterator.hasNext()) {
                String string;
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                TraceProcessor.ProcessMetadataResult.ProcessMetadata process;
                TraceProcessor.ProcessMetadataResult.ProcessMetadata processMetadata = process = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)processMetadata, (String)"process");
                Integer n = (int)processMetadata.getId();
                int n2 = (int)process.getId();
                Intrinsics.checkNotNullExpressionValue((Object)process.getName(), (String)"process.name");
                List<TraceProcessor.ProcessMetadataResult.ThreadMetadata> list = process.getThreadList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"process.threadList");
                Iterable iterable = list;
                int n3 = n2;
                Integer n4 = n;
                Map<Integer, ProcessModel> map2 = this.processById;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void t;
                    TraceProcessor.ProcessMetadataResult.ThreadMetadata threadMetadata = (TraceProcessor.ProcessMetadataResult.ThreadMetadata)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v4 = t;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"t");
                    Integer n5 = (int)v4.getId();
                    int n6 = (int)t.getId();
                    int n7 = (int)process.getId();
                    String string2 = t.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"t.name");
                    Pair pair = TuplesKt.to((Object)n5, (Object)new ThreadModel(n6, n7, string2, CollectionsKt.emptyList(), CollectionsKt.emptyList()));
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                Map map3 = MapsKt.emptyMap();
                Map map4 = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection));
                String string3 = string;
                int n8 = n3;
                map2.put(n4, new ProcessModel(n8, string3, map4, map3));
            }
            iterator = processMetadataResult.getDanglingThreadList().iterator();
            while (iterator.hasNext()) {
                TraceProcessor.ProcessMetadataResult.ThreadMetadata thread2;
                TraceProcessor.ProcessMetadataResult.ThreadMetadata threadMetadata = thread2 = (TraceProcessor.ProcessMetadataResult.ThreadMetadata)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)threadMetadata, (String)"thread");
                Integer n = (int)threadMetadata.getId();
                int n9 = (int)thread2.getId();
                String string = thread2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"thread.name");
                this.danglingThreads.put(n, new ThreadModel(n9, 0, string, CollectionsKt.emptyList(), CollectionsKt.emptyList()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addTraceEvents(@NotNull TraceProcessor.TraceEventsResult traceEventsResult) {
            Intrinsics.checkNotNullParameter((Object)traceEventsResult, (String)"traceEventsResult");
            for (TraceProcessor.TraceEventsResult.ThreadTraceEvents thread2 : traceEventsResult.getThreadList()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Long key$iv;
                Set rootIds = new LinkedHashSet();
                Map eventToChildrenIds = new LinkedHashMap();
                Map eventPerId = new LinkedHashMap();
                TraceProcessor.TraceEventsResult.ThreadTraceEvents threadTraceEvents = thread2;
                Intrinsics.checkNotNullExpressionValue((Object)threadTraceEvents, (String)"thread");
                Object object = threadTraceEvents.getTraceEventList().iterator();
                while (object.hasNext()) {
                    TraceProcessor.TraceEventsResult.TraceEvent event;
                    TraceProcessor.TraceEventsResult.TraceEvent traceEvent = event = object.next();
                    Intrinsics.checkNotNullExpressionValue((Object)traceEvent, (String)"event");
                    if (traceEvent.getDepth() > 0) {
                        Object object2;
                        void $this$getOrPut$iv;
                        Map map2 = eventToChildrenIds;
                        key$iv = event.getParentId();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(event.getId());
                    } else {
                        rootIds.add(event.getId());
                    }
                    long startTimestampUs = this.convertToUs(event.getTimestampNanoseconds());
                    long durationTimestampUs = this.convertToUs(event.getDurationNanoseconds());
                    long endTimestampUs = startTimestampUs + durationTimestampUs;
                    Long l = event.getId();
                    String string = event.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.name");
                    eventPerId.put(l, new TraceEventModel(string, startTimestampUs, endTimestampUs, durationTimestampUs, CollectionsKt.emptyList()));
                }
                Map<Long, TraceEventModel> reconstructedTree = this.reconstructTraceTree(rootIds, eventToChildrenIds, eventPerId);
                object = rootIds;
                Integer n = (int)thread2.getThreadId();
                Map<Integer, List<TraceEventModel>> map3 = this.threadToEventsMap;
                boolean $i$f$mapNotNull = false;
                key$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TraceEventModel traceEventModel;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    long it = ((Number)element$iv$iv).longValue();
                    boolean bl2 = false;
                    TraceEventModel traceEventModel2 = reconstructedTree.get(it);
                    if (traceEventModel2 == null) continue;
                    TraceEventModel it$iv$iv = traceEventModel = traceEventModel2;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                map3.put(n, list);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Long, TraceEventModel> reconstructTraceTree(Set<Long> rootIds, Map<Long, ? extends List<Long>> eventToChildrenIds, Map<Long, TraceEventModel> eventPerId) {
            Collection collection;
            Map reconstructedEventsPerId = new LinkedHashMap();
            Set visitedAllChildren = new LinkedHashSet();
            Deque eventIdStack = new LinkedList(rootIds);
            while (!(collection = (Collection)eventIdStack).isEmpty()) {
                TraceEventModel event;
                void $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object element$iv2;
                Long eventId = (Long)eventIdStack.getFirst();
                if (!visitedAllChildren.contains(eventId)) {
                    Long l = eventId;
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"eventId");
                    Iterable $this$forEach$iv = eventToChildrenIds.getOrDefault(l, (List)new ArrayList());
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        long it = ((Number)element$iv2).longValue();
                        boolean bl = false;
                        eventIdStack.addFirst(it);
                    }
                    visitedAllChildren.add(eventId);
                    continue;
                }
                eventIdStack.removeFirst();
                Long l = eventId;
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"eventId");
                Iterable $i$f$forEach = eventToChildrenIds.getOrDefault(l, (List)new ArrayList());
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TraceEventModel traceEventModel;
                    void it;
                    long l2 = ((Number)item$iv$iv).longValue();
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    if ((TraceEventModel)reconstructedEventsPerId.get((long)it) == null) {
                        String string = "Children should have been computed already";
                        throw new IllegalStateException(string.toString());
                    }
                    collection2.add(traceEventModel);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy2 = false;
                List children2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TraceEventModel it = (TraceEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getStartTimestampUs());
                        it = (TraceEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Long l = it.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                });
                if (eventPerId.get(eventId) == null) {
                    String $i$f$sortedBy2 = "Trace Event should be present in the map";
                    throw new IllegalStateException($i$f$sortedBy2.toString());
                }
                long myStart = event.getStartTimestampUs();
                TraceEventModel traceEventModel = (TraceEventModel)CollectionsKt.lastOrNull((List)children2);
                long maxEndTs = traceEventModel != null ? traceEventModel.getEndTimestampUs() : 0L;
                long myCpuTime = event.getCpuTimeUs();
                long l3 = myStart + myCpuTime;
                TraceEventModel updatedEvent = TraceEventModel.copy$default(event, null, 0L, Math.max(l3, maxEndTs), 0L, children2, 11, null);
                reconstructedEventsPerId.put(eventId, updatedEvent);
                l3 = this.startCaptureTimestamp;
                long l4 = updatedEvent.getStartTimestampUs();
                this.startCaptureTimestamp = Math.min(l3, l4);
                l3 = this.endCaptureTimestamp;
                l4 = updatedEvent.getEndTimestampUs();
                this.endCaptureTimestamp = Math.max(l3, l4);
            }
            return reconstructedEventsPerId;
        }

        public final void addSchedulingEvents(@NotNull TraceProcessor.SchedulingEventsResult schedEvents) {
            Iterable $this$sortedBy$iv;
            Map.Entry element$iv;
            Intrinsics.checkNotNullParameter((Object)schedEvents, (String)"schedEvents");
            int n = this.cpuCoresCount;
            int n2 = schedEvents.getNumCores();
            this.cpuCoresCount = Math.max(n, n2);
            Map perThreadScheduling = new LinkedHashMap();
            Map perCoreScheduling = new LinkedHashMap();
            Iterator<TraceProcessor.SchedulingEventsResult.SchedulingEvent> iterator = schedEvents.getSchedEventList().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                List answer$iv;
                Map $this$getOrPut$iv;
                TraceProcessor.SchedulingEventsResult.SchedulingEvent event;
                TraceProcessor.SchedulingEventsResult.SchedulingEvent schedulingEvent = event = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)schedulingEvent, (String)"event");
                long startTimestampUs = this.convertToUs(schedulingEvent.getTimestampNanoseconds());
                long durationTimestampUs = this.convertToUs(event.getDurationNanoseconds());
                long endTimestampUs = startTimestampUs + durationTimestampUs;
                long l = this.startCaptureTimestamp;
                this.startCaptureTimestamp = Math.min(l, startTimestampUs);
                l = this.endCaptureTimestamp;
                this.endCaptureTimestamp = Math.max(l, endTimestampUs);
                TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState schedulingState = event.getState();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)schedulingState), (String)"event.state");
                SchedulingEventModel schedEvent = new SchedulingEventModel(this.convertSchedulingState(schedulingState), startTimestampUs, endTimestampUs, durationTimestampUs, durationTimestampUs, (int)event.getProcessId(), (int)event.getThreadId(), event.getCpu());
                Map map2 = perThreadScheduling;
                Integer key$iv = (int)event.getThreadId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(schedEvent);
                $this$getOrPut$iv = perCoreScheduling;
                key$iv = event.getCpu();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(schedEvent);
            }
            Map $this$forEach$iv = perThreadScheduling;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                List list = this.threadToScheduling.get(it.getKey());
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List previousList = list;
                $this$sortedBy$iv = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                this.threadToScheduling.put((Integer)it.getKey(), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Long l = s.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                }));
            }
            $this$forEach$iv = perCoreScheduling;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                List list = this.coreToScheduling.get(it.getKey());
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List previousList = list;
                $this$sortedBy$iv = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                this.coreToScheduling.put((Integer)it.getKey(), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Long l = s.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                }));
            }
        }

        private final ThreadState convertSchedulingState(TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState state) {
            ThreadState threadState;
            switch (TraceProcessorModel$Builder$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    threadState = ThreadState.RUNNING_CAPTURED;
                    break;
                }
                case 2: {
                    threadState = ThreadState.RUNNING_CAPTURED;
                    break;
                }
                case 3: {
                    threadState = ThreadState.DEAD_CAPTURED;
                    break;
                }
                case 4: {
                    threadState = ThreadState.SLEEPING_CAPTURED;
                    break;
                }
                case 5: {
                    threadState = ThreadState.WAITING_CAPTURED;
                    break;
                }
                default: {
                    threadState = ThreadState.UNKNOWN;
                }
            }
            return threadState;
        }

        /*
         * WARNING - void declaration
         */
        public final void addCpuCounters(@NotNull TraceProcessor.CpuCoreCountersResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            int n = this.cpuCoresCount;
            int n2 = result.getNumCores();
            this.cpuCoresCount = Math.max(n, n2);
            List<TraceProcessor.CpuCoreCountersResult.CountersPerCore> list = result.getCountersPerCoreList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"result.countersPerCoreList");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<CounterModel> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                TraceProcessor.CpuCoreCountersResult.CountersPerCore countersPerCore = (TraceProcessor.CpuCoreCountersResult.CountersPerCore)element$iv;
                boolean bl = false;
                TraceProcessor.CpuCoreCountersResult.CountersPerCore countersPerCore2 = countersPerCore;
                Intrinsics.checkNotNullExpressionValue((Object)countersPerCore2, (String)"countersPerCore");
                Integer n3 = countersPerCore2.getCpu();
                List<TraceProcessor.Counter> list2 = countersPerCore.getCounterList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"countersPerCore.counterList");
                Iterable iterable = list2;
                Integer n4 = n3;
                Map<Integer, List<CounterModel>> map2 = this.coreToCpuCounters;
                boolean $i$f$map = false;
                void var12_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    Collection<Pair> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void counter;
                    TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    void v4 = counter;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"counter");
                    Intrinsics.checkNotNullExpressionValue((Object)v4.getName(), (String)"counter.name");
                    List<TraceProcessor.CounterValue> list3 = counter.getValueList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"counter.valueList");
                    Iterable iterable2 = list3;
                    boolean $i$f$map2 = false;
                    void var23_24 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        TraceProcessor.CounterValue counterValue = (TraceProcessor.CounterValue)item$iv$iv2;
                        collection2 = destination$iv$iv2;
                        boolean bl3 = false;
                        void v6 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                        Pair pair = TuplesKt.to((Object)this.convertToUs(v6.getTimestampNanoseconds()), (Object)it.getValue());
                        collection2.add(pair);
                    }
                    collection2 = (List)destination$iv$iv2;
                    SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection2));
                    String string2 = string;
                    CounterModel counterModel = new CounterModel(string2, sortedMap);
                    collection.add(counterModel);
                }
                collection = (List)destination$iv$iv;
                map2.put(n4, (List<CounterModel>)collection);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessCounters(@NotNull TraceProcessor.ProcessCountersResult counters) {
            Collection<CounterModel> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)counters, (String)"counters");
            Integer n = (int)counters.getProcessId();
            List<TraceProcessor.Counter> list = counters.getCounterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"counters.counterList");
            Iterable iterable = list;
            Integer n2 = n;
            Map<Integer, List<CounterModel>> map2 = this.processToCounters;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void counter;
                TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = counter;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"counter");
                Intrinsics.checkNotNullExpressionValue((Object)v2.getName(), (String)"counter.name");
                List<TraceProcessor.CounterValue> list2 = counter.getValueList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"counter.valueList");
                Iterable iterable2 = list2;
                boolean $i$f$map2 = false;
                void var14_16 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    TraceProcessor.CounterValue counterValue = (TraceProcessor.CounterValue)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    void v4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                    Pair pair = TuplesKt.to((Object)this.convertToUs(v4.getTimestampNanoseconds()), (Object)it.getValue());
                    collection2.add(pair);
                }
                collection2 = (List)destination$iv$iv2;
                SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection2));
                String string2 = string;
                CounterModel counterModel = new CounterModel(string2, sortedMap);
                collection.add(counterModel);
            }
            collection = (List)destination$iv$iv;
            map2.put(n2, (List<CounterModel>)collection);
        }

        public final void addAndroidFrameEvents(@NotNull TraceProcessor.AndroidFrameEventsResult frameEventsResult) {
            Intrinsics.checkNotNullParameter((Object)frameEventsResult, (String)"frameEventsResult");
            List<TraceProcessor.AndroidFrameEventsResult.Layer> list = frameEventsResult.getLayerList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"frameEventsResult.layerList");
            this.androidFrameLayers.addAll((Collection<TraceProcessor.AndroidFrameEventsResult.Layer>)list);
        }

        @NotNull
        public final TraceProcessorModel build() {
            return new TraceProcessorModel(this);
        }

        private final long convertToUs(long tsNanos) {
            return TimeUnit.NANOSECONDS.toMicros(tsNanos);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Companion;", "", "()V", "serialVersionUID", "", "getSerialVersionUID$annotations", "getSerialVersionUID", "()J", "intellij.android.profilers"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getSerialVersionUID$annotations() {
        }

        public final long getSerialVersionUID() {
            return serialVersionUID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

