/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.util.StringSearch;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0014H\u0086\bJ\t\u0010\u0015\u001a\u00020\u0016H\u0086\bJ\t\u0010\u0017\u001a\u00020\u0018H\u0086\bJ\t\u0010\u0019\u001a\u00020\u0018H\u0086\bJ\t\u0010\u001a\u001a\u00020\u0014H\u0086\bJ\u0011\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0018H\u0086\bJ\u0011\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0006H\u0086\bJ\u0011\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0018H\u0086\bJ\u0011\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0086\bJ \u0010#\u001a\u00020\u00142\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160%H\u0086\b\u00f8\u0001\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Ltrebuchet/util/BufferReaderState;", "", "()V", "buffer", "", "index", "", "endIndexExclusive", "([BII)V", "getBuffer", "()[B", "setBuffer", "([B)V", "getEndIndexExclusive", "()I", "setEndIndexExclusive", "(I)V", "getIndex", "setIndex", "end", "", "isDigit", "", "peek", "", "readByte", "skip", "skipChar", "char", "skipCount", "count", "skipSingle", "skipTo", "search", "Ltrebuchet/util/StringSearch;", "skipUntil", "cb", "Lkotlin/Function1;", "intellij.android.profilers.atrace"})
public class BufferReaderState {
    @NotNull
    private byte[] buffer;
    private int index;
    private int endIndexExclusive;

    public final byte peek() {
        int $i$f$peek = 0;
        return this.getBuffer()[this.getIndex()];
    }

    public final boolean isDigit() {
        int $i$f$isDigit = 0;
        byte $this$isDigit$iv = this.getBuffer()[this.getIndex()];
        boolean $i$f$isDigit2 = false;
        return $this$isDigit$iv >= (byte)48 && $this$isDigit$iv <= (byte)57;
    }

    public final void skip() {
        int $i$f$skip = 0;
        BufferReaderState bufferReaderState = this;
        int n = bufferReaderState.getIndex();
        bufferReaderState.setIndex(n + 1);
    }

    public final void skipCount(int count2) {
        int $i$f$skipCount = 0;
        BufferReaderState bufferReaderState = this;
        bufferReaderState.setIndex(bufferReaderState.getIndex() + count2);
    }

    public final void skipChar(byte by) {
        int $i$f$skipChar = 0;
        while (this.getIndex() < this.getEndIndexExclusive() && this.getBuffer()[this.getIndex()] == by) {
            BufferReaderState bufferReaderState = this;
            int n = bufferReaderState.getIndex();
            bufferReaderState.setIndex(n + 1);
        }
    }

    public final void skipSingle(byte by) {
        int $i$f$skipSingle = 0;
        BufferReaderState this_$iv = this;
        boolean $i$f$peek = false;
        if (this_$iv.getBuffer()[this_$iv.getIndex()] == by) {
            this_$iv = this;
            boolean $i$f$skip = false;
            BufferReaderState bufferReaderState = this_$iv;
            int n = bufferReaderState.getIndex();
            bufferReaderState.setIndex(n + 1);
        }
    }

    public final void skipUntil(@NotNull Function1<? super Byte, Boolean> cb) {
        int $i$f$skipUntil = 0;
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        while (this.getIndex() < this.getEndIndexExclusive()) {
            BufferReaderState this_$iv = this;
            boolean $i$f$peek = false;
            if (((Boolean)cb.invoke((Object)this_$iv.getBuffer()[this_$iv.getIndex()])).booleanValue()) break;
            BufferReaderState bufferReaderState = this;
            int n = bufferReaderState.getIndex();
            bufferReaderState.setIndex(n + 1);
        }
    }

    public final void end() {
        int $i$f$end = 0;
        this.setIndex(this.getEndIndexExclusive());
    }

    public final void skipTo(@NotNull StringSearch search) {
        int $i$f$skipTo = 0;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        int foundAt = search.find(this.getBuffer(), this.getIndex(), this.getEndIndexExclusive());
        this.setIndex(foundAt != -1 ? foundAt : this.getEndIndexExclusive());
    }

    public final byte readByte() {
        int $i$f$readByte = 0;
        byte[] byArray = this.getBuffer();
        BufferReaderState bufferReaderState = this;
        int n = bufferReaderState.getIndex();
        bufferReaderState.setIndex(n + 1);
        return byArray[n];
    }

    @NotNull
    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buffer = byArray;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getEndIndexExclusive() {
        return this.endIndexExclusive;
    }

    public final void setEndIndexExclusive(int n) {
        this.endIndexExclusive = n;
    }

    public BufferReaderState(@NotNull byte[] buffer, int index, int endIndexExclusive) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.index = index;
        this.endIndexExclusive = endIndexExclusive;
    }

    public BufferReaderState() {
        this(DataSlice.Companion.getEmptyBuffer(), 0, 0);
    }
}

