/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendContextRunnable;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTestCase;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public abstract class ExecutionWithDebuggerToolsTestCase
extends ExecutionTestCase {
    @Nullable
    private BreakpointProvider myBreakpointProvider;
    protected static final int RATHER_LATER_INVOKES_N = 10;
    public DebugProcessImpl myDebugProcess;
    private final List<Throwable> myException = new SmartList();
    public final List<InvokeRatherLaterRequest> myRatherLaterRequests = new ArrayList<InvokeRatherLaterRequest>();

    protected DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    protected String readValue(String comment, String valueName) {
        int valueStart = comment.indexOf(valueName);
        if (valueStart == -1) {
            return null;
        }
        return comment.substring((valueStart += valueName.length()) + 1, ExecutionWithDebuggerToolsTestCase.findMatchingParenthesis(comment, valueStart));
    }

    private static int findMatchingParenthesis(String input, int startPos) {
        int depth = 0;
        while (startPos < input.length()) {
            switch (input.charAt(startPos)) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    if (depth == 1) {
                        return startPos;
                    }
                    --depth;
                }
            }
            ++startPos;
        }
        return -1;
    }

    protected void resume(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createResumeCommand(context, PrioritizedTask.Priority.LOWEST));
    }

    protected void stepInto(SuspendContextImpl context) {
        this.stepInto(context, false);
    }

    protected void stepInto(SuspendContextImpl context, boolean ignoreFilters) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepIntoCommand(context, ignoreFilters, null));
    }

    protected void stepOver(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOverCommand(context, false));
    }

    protected void stepOut(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOutCommand(context));
    }

    @Override
    protected void tearDown() throws Exception {
        ThreadTracker.awaitJDIThreadsTermination(100, TimeUnit.SECONDS);
        try {
            this.myDebugProcess = null;
            this.myBreakpointProvider = null;
            this.myRatherLaterRequests.clear();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
            this.throwExceptionsIfAny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwExceptionsIfAny() {
        List<Throwable> list = this.myException;
        synchronized (list) {
            CompoundRuntimeException.throwIfNotEmpty(this.myException);
            this.myException.clear();
        }
    }

    @NotNull
    private BreakpointProvider getBreakpointProvider() {
        if (this.myBreakpointProvider == null) {
            DebugProcessImpl debugProcess = this.getDebugProcess();
            ExecutionWithDebuggerToolsTestCase.assertNotNull((String)"Debug process was not started", (Object)debugProcess);
            this.myBreakpointProvider = new BreakpointProvider(this.myDebugProcess);
            DelayedEventsProcessListener processListener = new DelayedEventsProcessListener(this.myBreakpointProvider);
            debugProcess.addDebugProcessListener((DebugProcessListener)processListener, this.getTestRootDisposable());
        }
        BreakpointProvider breakpointProvider = this.myBreakpointProvider;
        if (breakpointProvider == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(0);
        }
        return breakpointProvider;
    }

    protected void onBreakpoint(SuspendContextRunnable runnable) {
        this.getBreakpointProvider().onBreakpoint(runnable);
    }

    protected void onBreakpoints(SuspendContextRunnable runnable) {
        this.getBreakpointProvider().onBreakpoints(runnable);
    }

    protected void onStop(final SuspendContextRunnable runnable, final SuspendContextRunnable then) {
        this.onBreakpoint(new SuspendContextRunnable(){

            public void run(SuspendContextImpl suspendContext) throws Exception {
                try {
                    runnable.run(suspendContext);
                }
                finally {
                    then.run(suspendContext);
                }
            }
        });
    }

    protected void doWhenPausedThenResume(SuspendContextRunnable runnable) {
        this.onStop(runnable, this::resume);
    }

    protected void printFrameProxy(StackFrameProxyImpl frameProxy) throws EvaluateException {
        int frameIndex = frameProxy.getFrameIndex();
        Method method = frameProxy.location().method();
        this.println("frameProxy(" + frameIndex + ") = " + method, ProcessOutputTypes.SYSTEM);
    }

    protected static String toDisplayableString(SourcePosition sourcePosition) {
        int line = sourcePosition.getLine();
        if (line >= 0) {
            ++line;
        }
        return sourcePosition.getFile().getVirtualFile().getName() + ":" + line;
    }

    protected void printContext(StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context.getFrameProxy() != null) {
                this.println(ExecutionWithDebuggerToolsTestCase.toDisplayableString(Objects.requireNonNull(PositionUtil.getSourcePosition((StackFrameContext)context))), ProcessOutputTypes.SYSTEM);
            } else {
                this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
            }
        });
    }

    protected void printContextWithText(StackFrameContext context) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context.getFrameProxy() != null) {
                SourcePosition sourcePosition = PositionUtil.getSourcePosition((StackFrameContext)context);
                int offset = sourcePosition.getOffset();
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(sourcePosition.getFile());
                CharSequence text = Objects.requireNonNull(document).getImmutableCharSequence();
                String positionText = "";
                if (offset > -1) {
                    positionText = StringUtil.escapeLineBreak((String)(" [" + text.subSequence(Math.max(0, offset - 20), offset) + "<*>" + text.subSequence(offset, Math.min(offset + 20, text.length())) + "]"));
                }
                this.println(ExecutionWithDebuggerToolsTestCase.toDisplayableString(sourcePosition) + positionText, ProcessOutputTypes.SYSTEM);
            } else {
                this.println("Context thread is null", ProcessOutputTypes.SYSTEM);
            }
        });
    }

    protected void invokeRatherLater(SuspendContextImpl context, final Runnable runnable) {
        this.invokeRatherLater((DebuggerCommandImpl)new SuspendContextCommandImpl(context){

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                DebuggerInvocationUtil.invokeLater((Project)ExecutionWithDebuggerToolsTestCase.this.myProject, (Runnable)runnable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$2", "contextAction"));
            }
        });
    }

    protected void pumpSwingThread() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        final InvokeRatherLaterRequest request = this.myRatherLaterRequests.get(0);
        ++request.invokesN;
        if (request.invokesN == 10) {
            this.myRatherLaterRequests.remove(0);
            if (!this.myRatherLaterRequests.isEmpty()) {
                this.pumpSwingThread();
            }
        }
        if (request.myDebuggerCommand instanceof SuspendContextCommandImpl) {
            request.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(((SuspendContextCommandImpl)request.myDebuggerCommand).getSuspendContext()){

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$3", "contextAction"));
                }
            });
        } else {
            request.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                protected void action() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }
            });
        }
    }

    private void pumpDebuggerThread(InvokeRatherLaterRequest request) {
        if (request.invokesN == 10) {
            request.myDebugProcess.getManagerThread().schedule(request.myDebuggerCommand);
        } else if (!SwingUtilities.isEventDispatchThread()) {
            UIUtil.invokeAndWaitIfNeeded(() -> this.pumpSwingThread());
        } else {
            SwingUtilities.invokeLater(() -> this.pumpSwingThread());
        }
    }

    protected void invokeRatherLater(DebuggerCommandImpl command) {
        this.invokeRatherLater(this.getDebugProcess(), command);
    }

    protected void invokeRatherLater(@NotNull DebugProcessImpl debugProcess, DebuggerCommandImpl command) {
        if (debugProcess == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            InvokeRatherLaterRequest request = new InvokeRatherLaterRequest(command, debugProcess);
            this.myRatherLaterRequests.add(request);
            if (this.myRatherLaterRequests.size() == 1) {
                this.pumpSwingThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addException(@NotNull Throwable e) {
        if (e == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(2);
        }
        List<Throwable> list = this.myException;
        synchronized (list) {
            this.myException.add(e);
        }
    }

    protected void error(@NotNull Throwable th) {
        if (th == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(3);
        }
        ExecutionWithDebuggerToolsTestCase.fail((String)StringUtil.getThrowableText((Throwable)th));
    }

    private static Pair<ClassFilter[], ClassFilter[]> readClassFilters(String filtersString) {
        ArrayList<ClassFilter> include = new ArrayList<ClassFilter>();
        ArrayList<ClassFilter> exclude = new ArrayList<ClassFilter>();
        for (String s : filtersString.split(",")) {
            ClassFilter filter = new ClassFilter();
            filter.setEnabled(true);
            if (s.startsWith("-")) {
                exclude.add(filter);
                s = s.substring(1);
            } else {
                include.add(filter);
            }
            filter.setPattern(s);
        }
        return Pair.create((Object)include.toArray(ClassFilter.EMPTY_ARRAY), (Object)exclude.toArray(ClassFilter.EMPTY_ARRAY));
    }

    public void createBreakpoints(PsiFile file2) {
        Runnable runnable = () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
            String text = document.getText();
            int offset = -1;
            while ((offset = text.indexOf("Breakpoint!", offset + 1)) != -1) {
                String catchClassFilters;
                String classFilters;
                String passCount;
                String logExpression;
                String condition;
                MethodBreakpoint breakpoint;
                int commentLine = document.getLineNumber(offset);
                String comment = text.substring(document.getLineStartOffset(commentLine), document.getLineEndOffset(commentLine));
                if (comment.contains("Method")) {
                    breakpoint = breakpointManager.addMethodBreakpoint(document, commentLine + 1);
                    if (breakpoint != null) {
                        String exit;
                        String entry;
                        this.println("MethodBreakpoint created at " + file2.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                        String emulated = this.readValue(comment, "Emulated");
                        if (emulated != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).EMULATED = Boolean.parseBoolean(emulated);
                            this.println("Emulated = " + emulated, ProcessOutputTypes.SYSTEM);
                        }
                        if ((entry = this.readValue(comment, "OnEntry")) != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).WATCH_ENTRY = Boolean.parseBoolean(entry);
                            this.println("On Entry = " + entry, ProcessOutputTypes.SYSTEM);
                        }
                        if ((exit = this.readValue(comment, "OnExit")) != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).WATCH_EXIT = Boolean.parseBoolean(exit);
                            this.println("On Exit = " + exit, ProcessOutputTypes.SYSTEM);
                        }
                    }
                } else if (comment.contains("Field")) {
                    breakpoint = breakpointManager.addFieldBreakpoint(document, commentLine + 1, this.readValue(comment, "Field"));
                    if (breakpoint != null) {
                        this.println("FieldBreakpoint created at " + file2.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                } else if (comment.contains("Exception")) {
                    breakpoint = breakpointManager.addExceptionBreakpoint(this.readValue(comment, "Exception"), "");
                    if (breakpoint != null) {
                        this.println("ExceptionBreakpoint created at " + file2.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                } else {
                    breakpoint = breakpointManager.addLineBreakpoint(document, commentLine + 1);
                    if (breakpoint != null) {
                        this.println("LineBreakpoint created at " + file2.getVirtualFile().getName() + ":" + (commentLine + 2), ProcessOutputTypes.SYSTEM);
                    }
                }
                if (breakpoint == null) {
                    LOG.error("Unable to set a breakpoint at line " + (commentLine + 1));
                    continue;
                }
                String suspendPolicy = this.readValue(comment, "suspendPolicy");
                if (suspendPolicy != null) {
                    breakpoint.setSuspendPolicy(suspendPolicy);
                    this.println("SUSPEND_POLICY = " + suspendPolicy, ProcessOutputTypes.SYSTEM);
                }
                if ((condition = this.readValue(comment, "Condition")) != null) {
                    breakpoint.setCondition((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
                    this.println("Condition = " + condition, ProcessOutputTypes.SYSTEM);
                }
                if ((logExpression = this.readValue(comment, "LogExpression")) != null) {
                    breakpoint.getXBreakpoint().setLogExpression(logExpression);
                    this.println("LogExpression = " + logExpression, ProcessOutputTypes.SYSTEM);
                }
                if ((passCount = this.readValue(comment, "Pass count")) != null) {
                    breakpoint.setCountFilterEnabled(true);
                    breakpoint.setCountFilter(Integer.parseInt(passCount));
                    this.println("Pass count = " + passCount, ProcessOutputTypes.SYSTEM);
                }
                if ((classFilters = this.readValue(comment, "Class filters")) != null) {
                    breakpoint.setClassFiltersEnabled(true);
                    Pair<ClassFilter[], ClassFilter[]> filters = ExecutionWithDebuggerToolsTestCase.readClassFilters(classFilters);
                    breakpoint.setClassFilters((ClassFilter[])filters.first);
                    breakpoint.setClassExclusionFilters((ClassFilter[])filters.second);
                    this.println("Class filters = " + classFilters, ProcessOutputTypes.SYSTEM);
                }
                if ((catchClassFilters = this.readValue(comment, "Catch class filters")) == null || !(breakpoint instanceof ExceptionBreakpoint)) continue;
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setCatchFiltersEnabled(true);
                Pair<ClassFilter[], ClassFilter[]> filters = ExecutionWithDebuggerToolsTestCase.readClassFilters(catchClassFilters);
                exceptionBreakpoint.setCatchClassFilters((ClassFilter[])filters.first);
                exceptionBreakpoint.setCatchClassExclusionFilters((ClassFilter[])filters.second);
                this.println("Catch class filters = " + catchClassFilters, ProcessOutputTypes.SYSTEM);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, (Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invokeRatherLater";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class BreakpointProvider
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;
        private final List<SuspendContextRunnable> myBreakpointListeners = new ArrayList<SuspendContextRunnable>();
        private final Queue<SuspendContextRunnable> myScriptRunnables = new ArrayDeque<SuspendContextRunnable>();

        public BreakpointProvider(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        public void onBreakpoint(SuspendContextRunnable runnable) {
            this.myScriptRunnables.add(runnable);
        }

        public void onBreakpoints(SuspendContextRunnable runnable) {
            this.myBreakpointListeners.add(runnable);
        }

        public void paused(SuspendContextImpl suspendContext) {
            try {
                if (this.myScriptRunnables.isEmpty() && this.myBreakpointListeners.isEmpty()) {
                    ExecutionWithDebuggerToolsTestCase.this.print("resuming ", ProcessOutputTypes.SYSTEM);
                    ExecutionWithDebuggerToolsTestCase.this.printContext((StackFrameContext)suspendContext);
                    ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
                    return;
                }
                SuspendContextRunnable suspendContextRunnable = this.myScriptRunnables.poll();
                if (suspendContextRunnable != null) {
                    suspendContextRunnable.run(suspendContext);
                }
                for (SuspendContextRunnable it : this.myBreakpointListeners) {
                    it.run(suspendContext);
                }
            }
            catch (Exception e) {
                ExecutionWithDebuggerToolsTestCase.this.addException(e);
                ExecutionWithDebuggerToolsTestCase.this.error(e);
            }
            catch (AssertionError e) {
                ExecutionWithDebuggerToolsTestCase.this.addException((Throwable)((Object)e));
                ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
            }
        }

        public void resumed(SuspendContextImpl suspendContext) {
            final SuspendContextImpl pausedContext = this.myDebugProcess.getSuspendManager().getPausedContext();
            if (pausedContext != null) {
                this.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(pausedContext){

                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        BreakpointProvider.this.paused(pausedContext);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$BreakpointProvider$1", "contextAction"));
                    }
                });
            }
        }
    }

    protected static class DelayedEventsProcessListener
    implements DebugProcessListener {
        private final DebugProcessAdapterImpl myTarget;

        public DelayedEventsProcessListener(DebugProcessAdapterImpl target) {
            this.myTarget = target;
        }

        public void paused(@NotNull SuspendContext suspendContext) {
            if (suspendContext == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(0);
            }
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.paused(suspendContext);
        }

        public void resumed(SuspendContext suspendContext) {
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.resumed(suspendContext);
        }

        public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(1);
            }
            this.myTarget.processDetached(process, closedByUser);
        }

        public void processAttached(@NotNull DebugProcess process) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(2);
            }
            this.myTarget.processAttached(process);
        }

        public void connectorIsReady() {
            this.myTarget.connectorIsReady();
        }

        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            this.myTarget.attachException(state, exception, remoteConnection);
        }

        private static void pauseExecution() {
            TimeoutUtil.sleep((long)10L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$DelayedEventsProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paused";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDetached";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAttached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InvokeRatherLaterRequest {
        private final DebuggerCommandImpl myDebuggerCommand;
        private final DebugProcessImpl myDebugProcess;
        int invokesN;

        InvokeRatherLaterRequest(DebuggerCommandImpl debuggerCommand, DebugProcessImpl debugProcess) {
            this.myDebuggerCommand = debuggerCommand;
            this.myDebugProcess = debugProcess;
        }
    }
}

