/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.testFramework.HeavyTestHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/HeavyTestHelper;", "", "()V", "createTempDirectoryForTempDirTestFixture", "Ljava/nio/file/Path;", "dir", "prefix", "", "createTestProjectStructure", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "rootPath", "addProjectRoots", "", "getOrCreateProjectBaseDir", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class HeavyTestHelper {
    @NotNull
    public static final HeavyTestHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final VirtualFile createTestProjectStructure(@Nullable Module module, @Nullable String rootPath, @NotNull Path dir, boolean addProjectRoots) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(dir);
        if (virtualFile == null) {
            throw (Throwable)new IllegalStateException("Cannot find virtual directory by " + dir);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026rtual directory by $dir\")");
        VirtualFile virtualDir = virtualFile;
        virtualDir.getChildren();
        virtualDir.refresh(false, true);
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(rootPath, virtualDir, addProjectRoots, module){
            final /* synthetic */ String $rootPath;
            final /* synthetic */ VirtualFile $virtualDir;
            final /* synthetic */ boolean $addProjectRoots;
            final /* synthetic */ Module $module;

            public final void compute() {
                if (this.$rootPath != null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(StringsKt.replace$default((String)this.$rootPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
                    if (virtualFile == null) {
                        throw (Throwable)new Exception(this.$rootPath + " not found");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026on(\"$rootPath not found\")");
                    VirtualFile vDir1 = virtualFile;
                    VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)this.$virtualDir, null);
                }
                if (this.$addProjectRoots) {
                    Module module = this.$module;
                    Intrinsics.checkNotNull((Object)module);
                    ModuleRootModificationUtil.modifyModel((Module)module, (Function)new Function(this){
                        final /* synthetic */ createTestProjectStructure.1 this$0;

                        public final Boolean apply(ModifiableRootModel model) {
                            model.addContentEntry(this.this$0.$virtualDir).addSourceFolder(this.this$0.$virtualDir, false);
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.$rootPath = string;
                this.$virtualDir = virtualFile;
                this.$addProjectRoots = bl;
                this.$module = module;
            }
        });
        return virtualDir;
    }

    @JvmStatic
    @NotNull
    public static final Path createTempDirectoryForTempDirTestFixture(@Nullable Path dir, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path = dir;
        if (path == null) {
            path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        }
        Path parentDir = path;
        Files.createDirectories(parentDir, new FileAttribute[0]);
        Path path2 = Files.createTempDirectory(parentDir, prefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Files.createTempDirectory(parentDir, prefix)");
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getOrCreateProjectBaseDir(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path = ProjectKt.getStateStore((Project)project2).getProjectBasePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.stateStore.getProjectBasePath()");
        Path basePath = path;
        LocalFileSystem fs = LocalFileSystem.getInstance();
        VirtualFile baseDir = fs.findFileByNioFile(basePath);
        if (baseDir == null) {
            Files.createDirectories(basePath, new FileAttribute[0]);
            VirtualFile virtualFile = fs.refreshAndFindFileByNioFile(basePath);
            Intrinsics.checkNotNull((Object)virtualFile);
            return virtualFile;
        }
        return baseDir;
    }

    private HeavyTestHelper() {
    }

    static {
        HeavyTestHelper heavyTestHelper;
        INSTANCE = heavyTestHelper = new HeavyTestHelper();
    }
}

