/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.XmlMatchingStrategy;
import org.jetbrains.annotations.NotNull;

public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    @NotNull
    private final GlobalCompilingVisitor myCompilingVisitor;
    private final XmlWordOptimizer myOptimizer;

    public XmlCompilingVisitor(@NotNull GlobalCompilingVisitor compilingVisitor) {
        if (compilingVisitor == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(0);
        }
        this.myOptimizer = new XmlWordOptimizer();
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement @NotNull [] topLevelElements) {
        if (topLevelElements == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(1);
        }
        CompileContext context = this.myCompilingVisitor.getContext();
        CompiledPattern pattern = context.getPattern();
        MatchOptions options = context.getOptions();
        pattern.setStrategy(new XmlMatchingStrategy(options.getDialect()));
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            this.optimize(element);
            pattern.setHandler(element, new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    public void optimize(@NotNull PsiElement element) {
        if (element == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(2);
        }
        element.accept((PsiElementVisitor)this.myOptimizer);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            XmlCompilingVisitor.$$$reportNull$$$0(3);
        }
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitXmlToken(XmlToken token) {
        IElementType tokenType = token.getTokenType();
        if (tokenType != XmlTokenType.XML_NAME && tokenType != XmlTokenType.XML_COMMENT_CHARACTERS && tokenType != XmlTokenType.XML_DATA_CHARACTERS) {
            return;
        }
        super.visitXmlToken(token);
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
            this.myCompilingVisitor.setFilterSimple((PsiElement)token, TagValueFilter.getInstance());
        }
    }

    public void visitXmlText(XmlText text) {
        super.visitXmlText(text);
        if (this.myCompilingVisitor.getContext().getPattern().isRealTypedVar((PsiElement)text)) {
            this.myCompilingVisitor.setFilterSimple((PsiElement)text, TagValueFilter.getInstance());
        }
    }

    public void visitXmlTag(XmlTag tag) {
        super.visitXmlTag(tag);
        this.myCompilingVisitor.setFilterSimple((PsiElement)tag, element -> element instanceof XmlTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/XmlCompilingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "optimize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XmlWordOptimizer
    extends XmlRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private XmlWordOptimizer() {
        }

        public void visitXmlTag(XmlTag tag) {
            if (!this.handleWord(tag.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitXmlTag(tag);
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!this.handleWord(attribute.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            this.handleWord(attribute.getValue(), GlobalCompilingVisitor.OccurenceKind.CODE, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            super.visitXmlAttribute(attribute);
        }

        public void visitXmlToken(XmlToken token) {
            super.visitXmlToken(token);
            IElementType tokenType = token.getTokenType();
            if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                this.handleWord(token.getText(), GlobalCompilingVisitor.OccurenceKind.TEXT, XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }
    }
}

